<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !class_exists( 'RT_Postmeta' ) ) {
	return;
}

$Postmeta = RT_Postmeta::getInstance();

/*-------------------------------------
#. Page Settings
---------------------------------------*/
$nav_menus = wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus = array( 'default' => __( 'Default', 'greenova-core' ) ) + $nav_menus;

$Postmeta->add_meta_box( 'page_settings', __( 'Layout Settings', 'greenova-core' ), array( 'page', 'post', 'greenova_project' , 'greenova_team', 'green_testimonial', 'greenova_service' ), '', '', 'high', array(
	'fields' => array(
		'greenova_layout' => array(
			'label'   => __( 'Layout', 'greenova-core' ),
			'type'    => 'select',
			'options' => array(
				'default'       => __( 'Default', 'greenova-core' ),
				'full-width'    => __( 'Full Width', 'greenova-core' ),
				'left-sidebar'  => __( 'Left Sidebar', 'greenova-core' ),
				'right-sidebar' => __( 'Right Sidebar', 'greenova-core' ),
				),
			'default'  => 'default',
			),
		'greenova_page_menu' => array(
			'label'    => __( 'Main Menu', 'greenova-core' ),
			'type'     => 'select',
			'options'  => $nav_menus,
			'default'  => 'default',
			),
		'greenova_tr_header' => array(
			'label'    	  => __( 'Transparent Header', 'greenova-core' ),
			'type'     	  => 'select',
			'options'  	  => array(
				'default' => __( 'Default', 'greenova-core' ),
				'on'      => __( 'Enabled', 'greenova-core' ),
				'off'     => __( 'Disabled', 'greenova-core' ),
				),
			'default'  => 'default',
			),
		'greenova_top_bar' => array(
			'label' 	  => __( 'Top Bar', 'greenova-core' ),
			'type'  	  => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'on'      => __( 'Enabled', 'greenova-core' ),
				'off'     => __( 'Disabled', 'greenova-core' ),
				),
			'default'  	  => 'default',
			),
		'greenova_top_bar_style' => array(
			'label' 	=> __( 'Top Bar Layout', 'greenova-core' ),
			'type'  	=> 'select',
			'options'	=> array(
				'default' => __( 'Default',  'greenova-core' ),
				'1'       => __( 'Layout 1', 'greenova-core' ),
				'2'       => __( 'Layout 2', 'greenova-core' ),
				'3'       => __( 'Layout 3', 'greenova-core' ),
				'4'       => __( 'Layout 4', 'greenova-core' ),
				'5'       => __( 'Layout 5', 'greenova-core' ),
				'6'       => __( 'Layout 6', 'greenova-core' ),
				'7'       => __( 'Layout 7', 'greenova-core' ),
				),
			'default'   => 'default',
			),
		'greenova_header' => array(
			'label'   => __( 'Header Layout', 'greenova-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'1'       => __( 'Layout 1', 'greenova-core' ),
				'2'       => __( 'Layout 2', 'greenova-core' ),
				'3'       => __( 'Layout 3', 'greenova-core' ),
				'4'       => __( 'Layout 4', 'greenova-core' ),
				'5'       => __( 'Layout 5', 'greenova-core' ),
				'6'       => __( 'Layout 6', 'greenova-core' ),
				'10'      => __( 'Layout 7', 'greenova-core' ),
				'11'      => __( 'Layout 8', 'greenova-core' ),
				'12'      => __( 'Layout 9', 'greenova-core' ),
				'9'      => __( 'Layout 10', 'greenova-core' ),
				),
			'default'  => 'default',
			),
		'greenova_top_padding' => array(
			'label'   => __( 'Content Padding Top', 'greenova-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'0px'     => '0px',
				'10px'    => '10px',
				'20px'    => '20px',
				'30px'    => '30px',
				'40px'    => '40px',
				'50px'    => '50px',
				'60px'    => '60px',
				'70px'    => '70px',
				'80px'    => '80px',
				'90px'    => '90px',
				'100px'   => '100px',
				),
			'default'  => 'default',
			),
		'greenova_bottom_padding' => array(
			'label'   => __( 'Content Padding Bottom', 'greenova-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'0px'     => '0px',
				'10px'    => '10px',
				'20px'    => '20px',
				'30px'    => '30px',
				'40px'    => '40px',
				'50px'    => '50px',
				'60px'    => '60px',
				'70px'    => '70px',
				'80px'    => '80px',
				'90px'    => '90px',
				'100px'   => '100px',
				),
			'default'  => 'default',
			),
		'greenova_banner' => array(
			'label'   => __( 'Banner', 'greenova-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'on'	  => __( 'Enabled', 'greenova-core' ),
				'off'	  => __( 'Disabled', 'greenova-core' ),
				),
			'default'  => 'default',
			),
		'greenova_breadcrumb' => array(
			'label'   => __( 'Breadcrumb', 'greenova-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'on'      => __( 'Enabled', 'greenova-core' ),
				'off'	  => __( 'Disabled', 'greenova-core' ),
				),
			'default'  => 'default',
			),
		'greenova_banner_type' => array(
			'label' => __( 'Banner Background Type', 'greenova-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'greenova-core' ),
				'bgimg'    => __( 'Background Image', 'greenova-core' ),
				'bgcolor'  => __( 'Background Color', 'greenova-core' ),
				),
			'default' => 'default',
			),
		'greenova_banner_bgimg' => array(
			'label' => __( 'Banner Background Image', 'greenova-core' ),
			'type'  => 'image',
			'desc'  => __( 'If not selected, default will be used', 'greenova-core' ),
			),
		'greenova_banner_bgcolor' => array(
			'label' => __( 'Banner Background Color', 'greenova-core' ),
			'type'  => 'color_picker',
			'desc'  => __( 'If not selected, default will be used', 'greenova-core' ),
			),
		'greenova_footer_top_bar' => array(
			'label' 	  => __( 'Footer Top Bar', 'greenova-core' ),
			'type'  	  => 'select',
			'options' => array(
				'1' => __( 'Default', 'greenova-core' ),
				'1'      => __( 'Enabled', 'greenova-core' ),
				'0'     => __( 'Disabled', 'greenova-core' ),
				),
			'default'  	  => 'default',
			),			
		),
	) );

/*-------------------------------------
#. Projects
---------------------------------------*/
$Postmeta->add_meta_box( 'project_info', __( 'Project Info', 'greenova-core' ), array( 'greenova_project' ), '', '', 'high', array(
	'fields' => array(
		'greenova_proj_client' => array(
			'label' => __( 'Client', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_proj_url' => array(
			'label' => __( 'Live Demo', 'greenova-core' ),
			'type'  => 'text',
			),
		)
	)
);
/*-------------------------------------
#. Team
---------------------------------------*/
$team_socials = array(
	'facebook' => array(
		'label' => __( 'Facebook', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-facebook-f',
		'color' => '#3b5998',
		),
	'twitter' => array(
		'label' => __( 'Twitter', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-twitter',
		'color' => '#1da1f2',
		),
	'linkedin' => array(
		'label' => __( 'Linkedin', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-linkedin-in',
		'color' => '#006fa6',
		),
	'gplus' => array(
		'label' => __( 'Google Plus', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-google-plus-g',
		'color' => '#dd4f43',
		),
	'skype' => array(
		'label' => __( 'Skype', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-skype',
		'color' => '#02B4EB',
		),
	'youtube' => array(
		'label' => __( 'Youtube', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-youtube',
		'color' => '#DD2C28',
		),
	'pinterest' => array(
		'label' => __( 'Pinterest', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-pinterest-p',
		'color' => '#CB1F27',
		),
	'instagram' => array(
		'label' => __( 'Instagram', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-instagram',
		'color' => '#AA3DB2',
		),
	'github' => array(
		'label' => __( 'Github', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-github',
		'color' => '#111',
		),
	'stackoverflow' => array(
		'label' => __( 'Stackoverflow', 'greenova-core' ),
		'type'  => 'text',
		'icon'  => 'fa-stack-overflow',
		'color' => '#F48024',
		),
	);

$team_socials = apply_filters( 'team_socials', $team_socials );

GREENOVA_Theme::$team_social_fields = $team_socials;

$Postmeta->add_meta_box( 'team_settings', __( 'Team Member Settings', 'greenova-core' ), array( 'greenova_team' ), '', '', 'high', array(
	'fields' => array(
		'greenova_team_designation' => array(
			'label' => __( 'Designation', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_team_address' => array(
			'label' => __( 'Address', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_team_fax' => array(
			'label' => __( 'Fax', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_team_phone' => array(
			'label' => __( 'Phone Number', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_team_email' => array(
			'label' => __( 'Email', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_team_socials_header' => array(
			'label' => __( 'Socials', 'greenova-core' ),
			'type'  => 'header',
			'desc'  => __( 'Put your social links here', 'greenova-core' ),
			),
		'greenova_team_socials' => array(
			'type'  => 'group',
			'value'  => $team_socials
			),
		)
	)
);

$Postmeta->add_meta_box( 'team_skills', __( 'Team Skills', 'greenova-core' ), array( 'greenova_team' ), '', '', 'high', array(
	'fields' => array(
		'greenova_team_skill' => array(
			'type'  => 'repeater',
			'button' => __( 'Add New Skill', 'greenova-core' ),
			'value'  => array(
				'skill_name' => array(
					'label' => __( 'Skill Name', 'greenova-core' ),
					'type'  => 'text',
					'desc'  => __( 'eg. Investment', 'greenova-core' ),
					),
				'skill_value' => array(
					'label' => __( 'Skill Percentage (%)', 'greenova-core' ),
					'type'  => 'text',
					'desc'  => __( 'eg. 75', 'greenova-core' ),
					),
				)
			),
		)
	)
);

/*-------------------------------------
#. Service
---------------------------------------*/
$Postmeta->add_meta_box( 'greenova_service_info', __( 'Service Info', 'greenova-core' ), array( 'greenova_service' ), '', '', 'high', array(
	'fields' => array(
		'greenova_service_info_title' => array(
			'label' => __( 'Service Info Title', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_service_info_des' => array(
			'label' => __( 'Service Info Description', 'greenova-core' ),
			'type'  => 'text',
			),
		'greenova_service_infos' => array(
			'type'  => 'repeater',
			'button' => __( 'Add New Info', 'greenova-core' ),
			'value'  => array(
				'skill_name' => array(
					'label' => __( 'Benefit Title', 'greenova-core' ),
					'type'  => 'text',
					'desc'  => __( 'eg. Impact the environment', 'greenova-core' ),
					),
				'skill_value' => array(
					'label' => __( 'Benefit Description', 'greenova-core' ),
					'type'  => 'text',
					),
				)
			),
		)
	)
);

/*-------------------------------------
#. Testimonial
---------------------------------------*/
$Postmeta->add_meta_box( 'testimonial_info', __( 'Testimonial Info', 'greenova-core' ), array( 'green_testimonial' ), '', '', 'high', array(
	'fields' => array(
		'greenova_tes_designation' => array(
			'label' => __( 'Designation', 'greenova-core' ),
			'type'  => 'text',
			),
		)
	)
);