<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !class_exists( 'RT_Posts' ) ) {
	return;
}
$post_types = array(
	'greenova_team'   	 => array(
		'title'        => __( 'Team Member', 'greenova-core' ),
		'plural_title' => __( 'Team Members', 'greenova-core' ),
		'menu_icon'    => 'dashicons-businessman',
		'labels_override'     => array(
			'menu_name'  => __( 'Team', 'greenova-core' ),
			),
		'rewrite'      => GREENOVA_Theme::$options['team_slug'],
		),
	'greenova_service'    => array(
		'title'        => __( 'Service', 'greenova-core' ),
		'plural_title' => __( 'Service', 'greenova-core' ),
		'menu_icon'    => 'dashicons-book-alt',
		'rewrite'      => GREENOVA_Theme::$options['service_slug'],
		),
	'greenova_project'    => array(
		'title'        => __( 'Project', 'greenova-core' ),
		'plural_title' => __( 'Project', 'greenova-core' ),
		'menu_icon'    => 'dashicons-images-alt2',
		'rewrite'      => GREENOVA_Theme::$options['project_slug'],
		),
	'green_testimonial'  => array(
		'title'        => __( 'Testimonial', 'greenova-core' ),
		'plural_title' => __( 'Testimonials', 'greenova-core' ),
		'menu_icon'    => 'dashicons-awards',
		'rewrite'      => false,
		),
	);

$taxonomies = array(
	'greenova_service_category' => array(
		'title'        => __( 'Service Category', 'greenova-core' ),
		'plural_title' => __( 'Service Categories', 'greenova-core' ),
		'post_types'   => 'greenova_service',
		'rewrite'      => array( 'slug' => !empty( GREENOVA_Theme::$options['service_cat_slug'] ) ? GREENOVA_Theme::$options['service_cat_slug'] : '' ),
		),
	'greenova_project_category' => array(
		'title'        => __( 'Project Category', 'greenova-core' ),
		'plural_title' => __( 'Project Categories', 'greenova-core' ),
		'post_types'   => 'greenova_project',
		'rewrite'      => array( 'slug' => !empty( GREENOVA_Theme::$options['project_cat_slug'] ) ? GREENOVA_Theme::$options['project_cat_slug'] : '' ),
		),
	'green_team_cat' => array(
		'title'        => __( 'Team Category', 'greenova-core' ),
		'plural_title' => __( 'Team Categories', 'greenova-core' ),
		'post_types'   => 'greenova_team',
		'rewrite'      => array( 'slug' => !empty(GREENOVA_Theme::$options['team_cat_slug'] ) ? GREENOVA_Theme::$options['team_cat_slug'] : '' ),
		),
	'greenova_testimonial_category' => array(
		'title'        => __( 'Testimonial Category', 'greenova-core' ),
		'plural_title' => __( 'Testimonial Categories', 'greenova-core' ),
		'post_types'   => 'green_testimonial',
		),
	);

$Posts = RT_Posts::getInstance();
$Posts->add_post_types( $post_types );
$Posts->add_taxonomies( $taxonomies );