<?php

/**
 * Radiustheme Variation Gallery support.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SB\Controllers\PluginsSupport;

use RadiusTheme\SB\Helpers\ElementorDataMap;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Modules\WishList\WishlistFns;
use RadiusTheme\SB\Traits\SingletonTrait;
use RadiusTheme\SB\Helpers\BuilderFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class WooAddressBook {
	/**
	 * SingletonTrait.
	 */
	use SingletonTrait;

	/**
	 * Construct function
	 */
	private function __construct() {
		add_shortcode( 'rtsb_woo_address_book', [ $this, 'woo_address_book' ] );
	}

	/**
	 * @param $atts
	 * @param $content
	 *
	 * @return void
	 */
	public function woo_address_book( $atts, $content = '' ) {
		ob_start();
		$address = \WC_Address_Book::get_instance();
		$address->wc_address_book_page( '' );
		return ob_get_clean();
	}

}
