<?php
/**
 * The template to display the Builder content
 *
 * @author  RadiousTheme
 * @package RadiusTheme\SB
 */

use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'rtsb/builder/before/header' );

if ( Fns::check_is_block_theme() ) { ?>
    <!doctype html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div class="wp-site-blocks">
    <?php
    echo do_blocks( '<!-- wp:template-part {"slug":"header","theme":"' . esc_attr( rtsb()->current_theme ) . '","tagName":"header","className":"site-header"} /-->' );
} else {
    get_header( 'shop' );
}


$parent_class = apply_filters( 'rtsb/builder/wrapper/parent_class', [] );
?>
<div id="rtsb-builder-content" class="rtsb-builder-content content-invisible <?php echo esc_attr( implode( ' ', $parent_class ) ); ?>">
	<?php
	do_action( 'rtsb/builder/template/before/content' );
	if ( is_singular( BuilderFns::$post_type_tb ) && 'elementor' === Fns::page_edit_with( get_the_ID() ) ) {
		// \Elementor\Plugin::$instance->modules_manager->get_modules( 'page-templates' )->print_content();
		the_content();
	} else {
		do_action( 'rtsb/builder/template/main/content' );
	}
	do_action( 'rtsb/builder/template/after/content' );
	?>
</div>
<?php
do_action( 'rtsb/builder/before/footer' );

if ( Fns::check_is_block_theme() ) {
    echo do_blocks( '<!-- wp:template-part {"slug":"footer","theme":"' . esc_attr( rtsb()->current_theme ) . '","tagName":"footer","className":"site-footer"} /-->' );
    echo '</div>';
    wp_footer();
    echo '</body>';
    echo '</html>';
} else {
    get_footer( 'shop' );
}
