<?php
/**
 * ShortCode Meta field Class
 *
 * This will generate the meta field for ShortCode generator post type
 *
 * @package RT_WSL
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! class_exists( 'rtWLSSCMeta' ) ) :
	/**
	 * ShortCode Meta field Class
	 */
	class rtWLSSCMeta {
		public function __construct() {
			add_action( 'add_meta_boxes', [ $this, 'sc_meta_boxes' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_scripts' ], 99 );
			add_action( 'save_post', [ $this, 'save_team_sc_meta_data' ], 10, 3 );
			add_action( 'edit_form_after_title', [ $this, 'wls_sc_after_title' ] );
			add_action( 'admin_init', [ $this, 'rt_wls_pro_remove_all_meta_box' ] );
			add_filter( 'manage_edit-wlshowcasesc_columns', [ $this, 'arrange_wl_showcase_sc_columns' ] );
			add_action( 'manage_wlshowcasesc_posts_custom_column', [ $this, 'manage_wl_showcase_sc_columns' ], 10, 2 );
		}

		/**
		 * This will add input text field for shortCode
		 *
		 * @param $post
		 */
		public function wls_sc_after_title( $post ) {
			global $rtWLS;

			if ( $rtWLS->shortCodePT !== $post->post_type ) {
				return;
			}

			$html  = null;
			$html .= '<div class="postbox wls-sc-postbox"><div class="inside">';
			$html .= '<p><input type="text" onfocus="this.select();" readonly="readonly" value="[logo-showcase id=&quot;' . absint( $post->ID ) . '&quot; title=&quot;' . esc_html( $post->post_title ) . '&quot;]" class="large-text code rt-code-sc"><input type="text" onfocus="this.select();" readonly="readonly" value="&#60;&#63;php echo do_shortcode( &#39;[logo-showcase id=&quot;' . absint( $post->ID ) . '&quot; title=&quot;' . esc_html( $post->post_title ) . '&quot;]&#39; ); &#63;&#62;" class="large-text code rt-code-sc"></p>';
			$html .= '</div></div>';

			$rtWLS->print_html( $html, true );
		}

		/**
		 * Arrange the shortCode listing column
		 *
		 * @param $columns
		 *
		 * @return array
		 */
		public function arrange_wl_showcase_sc_columns( $columns ) {
			$shortcode = [ 'wls_short_code' => esc_html__( 'Shortcode', 'wp-logo-showcase' ) ];

			return array_slice( $columns, 0, 2, true ) + $shortcode + array_slice( $columns, 1, null, true );
		}

		public function manage_wl_showcase_sc_columns( $column ) {
			switch ( $column ) {
				case 'wls_short_code':
					echo '<input type="text" onfocus="this.select();" readonly="readonly" value="[logo-showcase id=&quot;' . absint( get_the_ID() ) . '&quot; title=&quot;' . esc_html( get_the_title() ) . '&quot;]" class="large-text code rt-code-sc">';
					break;

				default:
					break;
			}
		}

		/**
		 *  Remove all unwanted meta box
		 */
		public function rt_wls_pro_remove_all_meta_box() {
			if ( is_admin() ) {
				global $rtWLS;

				add_filter(
					"get_user_option_meta-box-order_{$rtWLS->shortCodePT}",
					[
						$this,
						'remove_all_meta_boxes_wls_sc',
					]
				);
			}
		}

		/**
		 * Add only custom meta box
		 *
		 * @return array
		 */
		public function remove_all_meta_boxes_wls_sc() {
			global $wp_meta_boxes, $rtWLS;

			$publishBox   = $wp_meta_boxes[ $rtWLS->shortCodePT ]['side']['core']['submitdiv'];
			$scBox        = $wp_meta_boxes[ $rtWLS->shortCodePT ]['normal']['high'][ $rtWLS->shortCodePT . '_sc_settings_meta' ];
			$scPreviewBox = $wp_meta_boxes[ $rtWLS->shortCodePT ]['normal']['high'][ $rtWLS->shortCodePT . '_sc_preview_meta' ];
			$docBox       = $wp_meta_boxes[ $rtWLS->shortCodePT ]['side']['low']['rt_plugin_sc_pro_information'];

			$wp_meta_boxes[ $rtWLS->shortCodePT ] = [
				'side'   => [
					'core' => [ 'submitdiv' => $publishBox ],
					'low'  => [ 'rt_plugin_sc_pro_information' => $docBox ],
				],
				'normal' => [
					'high' => [
						$rtWLS->shortCodePT . '_sc_settings_meta' => $scBox,
						$rtWLS->shortCodePT . '_sc_preview_meta'  => $scPreviewBox,
					],
				],
			];

			return [];
		}

		/**
		 *  Add script for the shortCode generate page only
		 */
		public function admin_enqueue_scripts() {
			global $pagenow, $typenow, $rtWLS;

			// validate page.
			if ( ! in_array( $pagenow, [ 'post.php', 'post-new.php', 'edit.php' ] ) ) {
				return;
			}

			if ( $typenow != $rtWLS->shortCodePT ) {
				return;
			}

			$select2Id = 'rt-select2';

			// scripts.
			wp_enqueue_script(
				[
					'jquery',
					'jquery-ui-core',
					'jquery-ui-sortable',
					'jquery-ui-tooltip',
					'rt-actual-height-js',
					'rt-images-load',
					'wp-color-picker',
					'rt-slick',
					$select2Id,
					'rt-isotope',
					'rt-wls-admin',
				]
			);

			// styles.
			wp_enqueue_style(
				[
					'wp-color-picker',
					'rt-select2',
					'rt-wls-preview',
					'rt-wls-admin',
				]
			);

			$nonce = wp_create_nonce( $rtWLS->nonceText() );

			wp_localize_script(
				'rt-wls-admin',
				'wls',
				[
					'nonceID' => esc_attr( $rtWLS->nonceID() ),
					'nonce'   => esc_attr( $nonce ),
					'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
				]
			);
		}

		/**
		 * Create the custom meta box for ShortCode post type
		 */
		public function sc_meta_boxes() {
			global $rtWLS;

			add_meta_box(
				$rtWLS->shortCodePT . '_sc_settings_meta',
				esc_html__( 'Short Code Generator', 'wp-logo-showcase' ),
				[ $this, 'wls_sc_settings_selection' ],
				$rtWLS->shortCodePT,
				'normal',
				'high'
			);

			add_meta_box(
				$rtWLS->shortCodePT . '_sc_preview_meta',
				esc_html__( 'Layout Preview', 'wp-logo-showcase' ),
				[ $this, 'wls_sc_preview_selection' ],
				$rtWLS->shortCodePT,
				'normal',
				'high'
			);

			add_meta_box(
				'rt_plugin_sc_pro_information',
				esc_html__( 'Documentation', 'wp-logo-showcase' ),
				[ $this, 'rt_plugin_sc_pro_information' ],
				$rtWLS->shortCodePT,
				'side',
				'low'
			);
		}


		/**
		 *  Preview section
		 */
		public function wls_sc_preview_selection() {
			global $rtWLS;

			$html  = null;
			$html .= "<div class='rt-response'></div><div class='wls-preview-container rt-wpls'><div id='wls-sc-preview' class='row'></div></div>";

			$rtWLS->print_html( $html, true );

		}

		/**
		 * Setting Sections
		 *
		 * @param $post
		 */
		public function wls_sc_settings_selection( $post ) {
			global $rtWLS;

			wp_nonce_field( $rtWLS->nonceText(), $rtWLS->nonceID() );

			$html  = null;
			$html .= '<div class="rt-tab-container">';
			$html .= '<ul class="rt-tab-nav">
						<li><a href="#sc-wls-layout"><i class="dashicons dashicons-layout"></i>' . esc_html__( 'Layout', 'wp-logo-showcase' ) . '</a></li>
						<li><a href="#sc-wls-filter"><i class="dashicons dashicons-filter"></i>' . esc_html__( 'Logo Filtering', 'wp-logo-showcase' ) . '</a></li>
						<li><a href="#sc-wls-layout-building"><i class="dashicons dashicons-editor-table"></i>' . esc_html__( 'Layout Building', 'wp-logo-showcase' ) . '</a></li>
						<li><a href="#sc-wls-style"><i class="dashicons dashicons-admin-customizer"></i>' . esc_html__( 'Styling', 'wp-logo-showcase' ) . '</a></li>
					</ul>';
			$html .= sprintf( '<div id="sc-wls-layout" class="rt-tab-content">%s</div>', $rtWLS->rtFieldGenerator( $rtWLS->scLayoutMetaFields(), true ) );

			$html .= sprintf( '<div id="sc-wls-filter" class="rt-tab-content">%s</div>', $rtWLS->rtFieldGenerator( $rtWLS->scFilterMetaFields(), true ) );

			$html .= sprintf( '<div id="sc-wls-layout-building" class="rt-tab-content">%s</div>', $this->rt_wls_sc_layout_building_meta() );

			$html .= sprintf( '<div id="sc-wls-style" class="rt-tab-content">%s</div>', $this->rt_wls_sc_style_meta( $post ) );
			$html .= '</div>';

			$rtWLS->print_html( $html, true );
		}

		public function rt_plugin_sc_pro_information() {
			global $rtWLS;

			$doc     = 'https://www.radiustheme.com/setup-configure-wp-logo-showcase-wordpress/';
			$contact = 'https://www.radiustheme.com/contact/';
			$fb      = 'https://www.facebook.com/groups/234799147426640/';
			$chat    = 'https://www.radiustheme.com/';

			$html = sprintf(
				'<div class="rt-document-box">
					<div class="rt-box-icon"><i class="dashicons dashicons-media-document"></i></div>
					<div class="rt-box-content">
						<h3 class="rt-box-title">%1$s</h3>
						<p>%2$s</p>
						<a href="' . esc_url( $doc ) . '" target="_blank" class="rt-admin-btn">%1$s</a>
					</div>
				</div>',
				esc_html__( 'Documentation', 'wp-logo-showcase' ),
				esc_html__( 'Get started by spending some time with the documentation we included step by step process with screenshots with video.', 'wp-logo-showcase' )
			);

			$html .= '<div class="rt-document-box">
						<div class="rt-box-icon"><i class="dashicons dashicons-sos"></i></div>
						<div class="rt-box-content">
							<h3 class="rt-box-title">Need Help?</h3>
							<p>Stuck with something? Please create a
							<a href="' . esc_url( $contact ) . '">ticket here</a> or post on <a href="' . esc_url( $fb ) . '">facebook group</a>. For emergency case join our <a href="' . esc_url( $chat ) . '">live chat</a>.</p>
							<a href="' . esc_url( $contact ) . '" target="_blank" class="rt-admin-btn">Get Support</a>
						</div>
					</div>';

			$rtWLS->print_html( $html );
		}


		/**
		 * Style section
		 *
		 * @param $post
		 *
		 * @return null|string
		 */
		public function rt_wls_sc_style_meta( $post ) {
			global $rtWLS;

			$html   = null;
			$html  .= "<div class='rt-sc-meta-field-holder'>";
			$html  .= $rtWLS->rtFieldGenerator( $rtWLS->scStyleFields(), true );
			$fields = $rtWLS->scStyleItems();

			foreach ( $fields as $key => $field ) {
				$meta             = get_post_meta( $post->ID, '_wls_style_' . $key, true );
				$html            .= "<div class='rt-field-wrapper {$key}'>";
				$html            .= "<div class='rt-label'><label>{$field}</label></div>";
				$html            .= "<div class='rt-field rt-multiple-field-container'>";
				$meta_color       = ( ! empty( $meta['color'] ) ? $meta['color'] : null );
				$html            .= "<div class='rt-inner-field rt-col-4'><label>Color</label><input type='text' value='{$meta_color}' class='rt-color' name='_wls_style_{$key}[color]'></div>";
				$meta_hover_color = ( ! empty( $meta['hover_color'] ) ? $meta['hover_color'] : null );
				$html            .= "<div class='rt-inner-field rt-col-4 rt-hover-color'><label>Hover Color</label><input type='text' value='{$meta_hover_color}' class='rt-color' name='_wls_style_{$key}[hover_color]'></div>";
				$html            .= "<div class='rt-inner-field rt-col-4'>";
				$html            .= sprintf( '<label>%s</label>', esc_html__( 'Font Weight', 'wp-logo-showcase' ) );
				$html            .= "<select name='_wls_style_{$key}[weight]' class='rt-select2'>";
				$html            .= sprintf( "<option value=''>%s</option>", esc_html__( 'Default', 'wp-logo-showcase' ) );
				$weight           = $rtWLS->scWlsFontWeight();
				$meta_align       = ( ! empty( $meta['weight'] ) ? $meta['weight'] : null );

				foreach ( $weight as $aKey => $aValue ) {
					$selected = ( $aKey == $meta_align ? 'selected' : null );
					$html    .= "<option {$selected} value='{$aKey}'>{$aValue}</option>";
				}

				$html      .= '</select>';
				$html      .= '</div>';
				$html      .= "<div class='rt-inner-field rt-col-3'>";
				$html      .= sprintf( '<label>%s</label>', esc_html__( 'Alignment', 'wp-logo-showcase' ) );
				$html      .= "<select name='_wls_style_{$key}[align]' class='rt-select2'>";
				$html      .= sprintf( "<option value=''>%s</option>", esc_html__( 'Default', 'wp-logo-showcase' ) );
				$aligns     = $rtWLS->scWlsAlign();
				$meta_align = ( ! empty( $meta['align'] ) ? $meta['align'] : null );

				foreach ( $aligns as $aKey => $aValue ) {
					$selected = ( $aKey == $meta_align ? 'selected' : null );
					$html    .= "<option {$selected} value='{$aKey}'>{$aValue}</option>";
				}

				$html     .= '</select>';
				$html     .= '</div>';
				$html     .= "<div class='rt-inner-field rt-col-3'>";
				$html     .= sprintf( '<label>%s</label>', esc_html__( 'Size', 'wp-logo-showcase' ) );
				$html     .= "<select name='_wls_style_{$key}[size]'  class='rt-select2'>";
				$html     .= sprintf( "<option value=''>%s</option>", esc_html__( 'Default', 'wp-logo-showcase' ) );
				$sizes     = $rtWLS->scWlsFontSize();
				$meta_size = ( ! empty( $meta['size'] ) ? $meta['size'] : null );

				foreach ( $sizes as $sKey => $sValue ) {
					$selected = ( $sKey == $meta_size ? 'selected' : null );
					$html    .= "<option {$selected} value='{$sKey}'>{$sValue}</option>";
				}

				$html .= '</select>';
				$html .= '</div>';
				$html .= '</div>';
				$html .= '</div>';
			}

			$html .= '</div>';

			return $html;

		}

		/**
		 * Layout drag and drop sorting Section
		 *
		 * @return null|string
		 */
		public function rt_wls_sc_layout_building_meta() {
			global $rtWLS;

			$metaItems = get_post_meta( get_the_ID(), '_wls_items' );

			if ( ! in_array( 'logo', $metaItems ) ) {
				array_push( $metaItems, 'logo' );
			}

			$items     = $rtWLS->scLayoutItems();
			$items_key = array_keys( $items );
			$html      = null;
			$html     .= "<div class='rt-field-wrapper'>";
			$html     .= "<div class='rt-field'>";
			$html     .= "<div class='rt-sortable'>";

			$html .= "<div class='sort-values'>";

			if ( ! empty( $metaItems ) ) {
				foreach ( $metaItems as $item ) {
					$html .= "<input type='hidden' name='_wls_items[]' value='{$item}' >";
				}
			}

			$html .= '</div>';

			$html .= "<div class='sortable-list-holder'>";
			$html .= "<div class='sortable-list-content'>";
			$html .= '<h2>' . esc_html__( 'Enabled', 'wp-logo-showcase' ) . '</h2>';
			$html .= "<ul class='sortable-list target'>";

			if ( ! empty( $metaItems ) ) {
				foreach ( $metaItems as $item ) {
					$html .= "<li class='sortable-item' data-item='$item'>{$items[$item]}</li>";
				}
			}

			$html     .= '</ul>';
			$html     .= '</div>';
			$html     .= '</div>';
			$html     .= "<div class='sortable-list-holder'>";
			$html     .= "<div class='sortable-list-content'>";
			$html     .= '<h2>' . esc_html__( 'Disabled', 'wp-logo-showcase' ) . '</h2>';
			$html     .= "<ul class='sortable-list source'>";
			$items_key = array_diff( $items_key, $metaItems );

			foreach ( $items_key as $item ) {
				$html .= "<li class='sortable-item' data-item='$item'>{$items[$item]}</li>";
			}

			$html .= '</ul>';
			$html .= '</div>';
			$html .= '</div>';

			$html .= '</div>';
			$html .= '</div>';
			$html .= '</div>';

			return $html;
		}


		/**
		 * Save all the meta value for shortCode meta field
		 *
		 * @param $post_id
		 * @param $post
		 * @param $update
		 */
		public function save_team_sc_meta_data( $post_id, $post, $update ) {
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			global $rtWLS;

			if ( ! $rtWLS->verifyNonce() ) {
				return $post_id;
			}

			if ( $rtWLS->shortCodePT != $post->post_type ) {
				return $post_id;
			}

			$mates = $rtWLS->wlsScMetaNames();

			foreach ( $mates as $field ) {
				$rValue = ! empty( $_REQUEST[ $field['name'] ] ) ? $_REQUEST[ $field['name'] ] : null;
				$value  = $rtWLS->sanitize( $field, $rValue );

				if ( empty( $field['multiple'] ) ) {
					update_post_meta( $post_id, $field['name'], $value );
				} else {
					delete_post_meta( $post_id, $field['name'] );
					if ( is_array( $value ) && ! empty( $value ) ) {
						foreach ( $value as $item ) {
							add_post_meta( $post_id, $field['name'], $item );
						}
					}
				}
			}

			$meta = [];

			foreach ( $rtWLS->scStyleItems() as $key => $value ) {
				$key = '_wls_style_' . $key;

				if ( ! empty( $_REQUEST[ $key ] ) && is_array( $_REQUEST[ $key ] ) ) {
					$mValue                = [];
					$mValue['color']       = ( ! empty( $_REQUEST[ $key ]['color'] ) ? $rtWLS->sanitize_hex_color( $_REQUEST[ $key ]['color'] ) : null );
					$mValue['hover_color'] = ( ! empty( $_REQUEST[ $key ]['hover_color'] ) ? $rtWLS->sanitize_hex_color( $_REQUEST[ $key ]['hover_color'] ) : null );
					$mValue['weight']      = ( ! empty( $_REQUEST[ $key ]['weight'] ) ? sanitize_text_field( $_REQUEST[ $key ]['weight'] ) : null );
					$mValue['align']       = ( ! empty( $_REQUEST[ $key ]['align'] ) ? sanitize_text_field( $_REQUEST[ $key ]['align'] ) : null );
					$mValue['size']        = ( ! empty( $_REQUEST[ $key ]['size'] ) ? sanitize_text_field( $_REQUEST[ $key ]['size'] ) : null );
					$meta[ $key ]          = $mValue;
				} else {
					delete_post_meta( $post_id, $key );
				}
			}

			foreach ( $meta as $key => $data ) {
				update_post_meta( $post_id, $key, $data );
			}
		}
	}
endif;
