<?php
/**
 * ShortCode Render Class
 *
 * This will generate the meta field for ShortCode generator post type
 *
 * @package RT_WSL
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! class_exists( 'rtWLSShortCode' ) ) :
	/**
	 * ShortCode Render Class
	 */
	class rtWLSShortCode {

		private $scA = [];

		public function __construct() {
			add_shortcode( 'logo-showcase', [ $this, 'wls_short_code' ] );
		}

		public function register_scripts() {
			$script = [];
			$iso    = false;
			$caro   = false;

			foreach ( $this->scA as $sc ) {
				if ( isset( $sc ) && is_array( $sc ) ) {
					if ( $sc['isIsotope'] ) {
						$iso = true;
					}

					if ( $sc['isCarousel'] ) {
						$caro = true;
					}
				}
			}
			if ( count( $this->scA ) ) {
				array_push( $script, 'jquery' );
				array_push( $script, 'rt-actual-height-js' );
				array_push( $script, 'rt-images-load' );

				if ( $iso ) {
					array_push( $script, 'rt-isotope' );
				}

				if ( $caro ) {
					array_push( $script, 'rt-slick' );
				}

				array_push( $script, 'rt-wls' );

				wp_enqueue_script( $script );
			}
		}

		/**
		 * ShortCode Generate
		 *
		 * @param $atts
		 *
		 * @return null|string
		 */
		public function wls_short_code( $atts ) {
			global $rtWLS;

			$html = null;
			$arg  = [];
			$atts = shortcode_atts(
				[
					'id'    => null,
					'title' => null,
				],
				$atts,
				'logo-showcase'
			);
			$scID = $atts['id'];

			if ( $scID && ! is_null( get_post( $scID ) ) ) {
				$scMeta = get_post_meta( $scID );

				$layout = ( isset( $scMeta['wls_layout'][0] ) ? $scMeta['wls_layout'][0] : 'grid-layout' );

				if ( ! in_array( $layout, array_keys( $rtWLS->scLayout() ) ) ) {
					$layout = 'grid-layout';
				}

				$isIsotope  = preg_match( '/isotope/', $layout );
				$isCarousel = preg_match( '/carousel/', $layout );

				$col           = ( isset( $scMeta['wls_column'][0] ) ? absint( $scMeta['wls_column'][0] ) : 4 );
				$colDesk       = ( isset( $scMeta['wls_desktop_column'][0] ) ? absint( $scMeta['wls_desktop_column'][0] ) : 4 );
				$colDeskSlider = isset( $scMeta['wls_desktop_slider'][0] ) ? absint( $scMeta['wls_desktop_slider'][0] ) : null;

				$colTab    = ( isset( $scMeta['wls_tab_column'][0] ) ? absint( $scMeta['wls_tab_column'][0] ) : 2 );
				$colMobile = ( isset( $scMeta['wls_mobile_column'][0] ) ? absint( $scMeta['wls_mobile_column'][0] ) : 1 );

				if ( ! in_array( $col, array_keys( $rtWLS->scColumns() ) ) ) {
					$col = 4;
				}

				if ( ! in_array( $colDesk, array_keys( $rtWLS->scColumns() ) ) ) {
					$colDesk = 4;
				}

				if ( ! in_array( $colTab, array_keys( $rtWLS->scColumns() ) ) ) {
					$colTab = 2;
				}

				if ( ! in_array( $colMobile, array_keys( $rtWLS->scColumns() ) ) ) {
					$colMobile = 1;
				}

				$arg['linkType'] = ( isset( $scMeta['wls_link_type'][0] ) ? $scMeta['wls_link_type'][0] : 'new_window' );
				$arg['nofollow'] = isset( $scMeta['wls_nofollow'][0] ) && ! empty( $scMeta['wls_nofollow'][0] ) ? true : false;

				/* Argument create */
				$args              = [];
				$itemIdsArgs       = [];
				$args['post_type'] = $rtWLS->post_type;

				// Common filters.
				/* post__in */
				$post__in = ( isset( $scMeta['wls_post__in'][0] ) ? $scMeta['wls_post__in'][0] : null );

				if ( $post__in ) {
					$post__in         = explode( ',', $post__in );
					$args['post__in'] = $post__in;
				}

				/* post__not_in */
				$post__not_in = ( isset( $scMeta['wls_post__not_in'][0] ) ? $scMeta['wls_post__not_in'][0] : null );

				if ( $post__not_in ) {
					$post__not_in         = explode( ',', $post__not_in );
					$args['post__not_in'] = $post__not_in;
				}

				/* LIMIT */
				$limit                  = ( ! empty( $scMeta['wls_limit'][0] ) ? ( $scMeta['wls_limit'][0] === '-1' ? 10000000 : (int) $scMeta['wls_limit'][0] ) : 10000000 );
				$args['posts_per_page'] = $limit;

				// Taxonomy.
				$taxQ = [];
				$cats = ( ! empty( $scMeta['wls_categories'] ) ? $scMeta['wls_categories'] : [] );

				if ( ! empty( $cats ) ) {
					$taxQ[] = [
						'taxonomy' => $rtWLS->taxonomy['category'],
						'field'    => 'term_id',
						'terms'    => $cats,
					];
				}

				if ( ! empty( $taxQ ) ) {
					$args['tax_query'] = $itemIdsArgs['tax_query'] = $taxQ;
				}

				// Order.
				$order_by = ( ! empty( $scMeta['wls_order_by'][0] ) ? $scMeta['wls_order_by'][0] : null );
				$order    = ( ! empty( $scMeta['wls_order'][0] ) ? $scMeta['wls_order'][0] : null );

				if ( $order ) {
					$args['order'] = $order;
				}

				if ( $order_by ) {
					$args['orderby'] = $order_by;
				}

				$containerDataAttr = " data-sc-id='{$scID}' data-desktop-col='{$colDesk}'  data-tab-col='{$colTab}'  data-mobile-col='{$colMobile}'";
				$deskItem          = $colDesk;
				$tabItem           = $colTab;
				$mobileItem        = $colMobile;
				$colDesk           = $colDesk == 5 ? '24' : round( 12 / $colDesk );
				$colTab            = $colTab == 5 ? '24' : round( 12 / $colTab );
				$colMobile         = $colMobile == 5 ? '24' : round( 12 / $colMobile );
				$arg['grid']       = "rt-col-md-{$colDesk} rt-col-sm-{$colTab} rt-col-xs-{$colMobile}";
				$arg['class']      = 'equal-height';

				$arg['styleClass'] = null;

				if ( ! empty( $scMeta['wls_tooltip'][0] ) ) {
					$arg['styleClass'] .= ' wls-tooltip';
				}

				if ( ! empty( $scMeta['wls_box_highlight'][0] ) ) {
					$arg['styleClass'] .= ' wls-boxhighlight';
				}

				if ( ! empty( $scMeta['wls_grayscale'][0] ) ) {
					$arg['styleClass'] .= ' wls-grayscale';
				}

				if ( $isIsotope ) {
					$arg['class'] .= ' isotope-item';
				}

				$arg['items'] = ! empty( $scMeta['_wls_items'] ) ? $scMeta['_wls_items'] : [];

				/* Some Custom option */
				$logoQuery = new WP_Query( $args );

				if ( $logoQuery->have_posts() ) {
					$rand          = wp_rand();
					$carouselClass = null;
					$isotopeClass  = $containerClass = null;
					$carouselDir   = $carouselAttribute = null;

					if ( $isCarousel ) {
						$carouselClass  = 'wpls-carousel ';
						$containerClass = 'rt-loading';
						$slidesToScroll = ( ! empty( $scMeta['wls_carousel_slidesToScroll'][0] ) ? (int) $scMeta['wls_carousel_slidesToScroll'][0] : 3 );
						$autoPlaySpeed  = ( ! empty( $scMeta['wls_carousel_auto_play_speed'][0] ) ? (int) $scMeta['wls_carousel_auto_play_speed'][0] : 3000 );
						$speed          = ( ! empty( $scMeta['wls_carousel_speed'][0] ) ? (int) $scMeta['wls_carousel_speed'][0] : 2000 );
						$options        = [];

						if ( ! empty( $scMeta['wls_carousel_options'] ) && is_array( $scMeta['wls_carousel_options'] ) ) {
							$options = $scMeta['wls_carousel_options'];
						}

						$deskItem          = $colDeskSlider ? $colDeskSlider : $deskItem;
						$carouselAttribute = "data-slick='{
						\"slidesToShow\": {$deskItem},
						\"slidesToShowTab\": {$tabItem},
						\"slidesToShowMobile\": {$mobileItem},
						\"slidesToScroll\": {$slidesToScroll},
						\"speed\": {$speed},
						\"autoplaySpeed\": {$autoPlaySpeed},
						\"dots\": " . ( in_array( 'dots', $options ) ? 'true' : 'false' ) . ',
						"arrows": ' . ( in_array( 'arrows', $options ) ? 'true' : 'false' ) . ',
						"infinite": ' . ( in_array( 'infinite', $options ) ? 'true' : 'false' ) . ',
						"lazyLoad": ' . ( in_array( 'lazyLoad', $options ) ? '"progressive"' : '"ondemand"' ) . ',
						"pauseOnHover": ' . ( in_array( 'pauseOnHover', $options ) ? 'true' : 'false' ) . ',
						"autoplay": ' . ( in_array( 'autoplay', $options ) ? 'true' : 'false' ) . ',
						"centerMode": ' . ( in_array( 'centerMode', $options ) ? 'true' : 'false' ) . ',
						"adaptiveHeight": ' . ( in_array( 'adaptiveHeight', $options ) ? 'true' : 'false' ) . ',
						"rtl": ' . ( in_array( 'rtl', $options ) ? 'true' : 'false' ) . "
						}'";

						$carouselAttribute = preg_replace( '/\s+/S', ' ', $carouselAttribute );

						$carouselDir = ( in_array( 'rtl', $options ) ? ' dir="rtl"' : null );
					}

					if ( $isIsotope ) {
						$isotopeClass = 'wpls-isotope';
					}

					$containerID = 'rt-container-' . $rand;
					$html       .= $this->layoutStyle( $rand, $scMeta );
					$settings    = get_option( $rtWLS->options['settings'] );
					$imgReSize   = ( ! empty( $settings['image_resize'] ) ? true : false );
					$imgSize     = [];

					if ( $imgReSize ) {
						$imgSize['width']  = isset( $settings['image_width'] ) ? absint( $settings['image_width'] ) : 180;
						$imgSize['height'] = isset( $settings['image_height'] ) ? absint( $settings['image_height'] ) : 90;
						$imgSize['crop']   = isset( $settings['image_crop'] ) ? ( $settings['image_crop'] ? true : false ) : false;
					}

					// image size.
					$wls_image_size = ! empty( $scMeta['wls_image_size'][0] ) ? $scMeta['wls_image_size'][0] : null;

					if ( $wls_image_size && 'wls_custom_image_size' == $wls_image_size ) {
						$imgReSize             = true;
						$wls_custom_image_size = maybe_unserialize( $scMeta['wls_custom_image_size'][0] );
						$imgSize['width']      = isset( $wls_custom_image_size['width'] ) ? absint( $wls_custom_image_size['width'] ) : 180;
						$imgSize['height']     = isset( $wls_custom_image_size['height'] ) ? absint( $wls_custom_image_size['height'] ) : 90;
						$imgSize['crop']       = isset( $wls_custom_image_size['crop'] ) ? ( $wls_custom_image_size['crop'] ? true : false ) : false;
					}

					$image_size = ( $wls_image_size && 'wls_custom_image_size' != $wls_image_size ) ? $wls_image_size : 'full';

					$html .= "<div class='rt-container-fluid rt-wpls {$containerClass}' id='{$containerID}' {$containerDataAttr}>";
					$html .= "<div class='rt-row {$layout} {$carouselClass}' {$carouselAttribute} {$carouselDir}>";

					if ( $isIsotope ) {
						$terms = get_terms(
							$rtWLS->taxonomy['category'],
							[
								'hide_empty' => true,
							]
						);

						$html .= '<div class="button-group filter-button-group option-set wls-isotope-button"><button data-filter="*" class="selected">' . esc_html__( 'Show all', 'wp-logo-showcase' ) . '</button>';

						if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
							foreach ( $terms as $term ) {
								if ( empty( $cats ) ) {
									$html .= "<button data-filter='.{$term->slug}'>" . $term->name . '</button>';
								} else {
									if ( in_array( $term->term_id, $cats ) ) {
										$html .= "<button data-filter='.{$term->slug}'>" . $term->name . '</button>';
									}
								}
							}
						}

						$html .= '</div>';
						$html .= "<div class='{$isotopeClass}' id='{$isotopeClass}-{$rand}'>";
					}

					while ( $logoQuery->have_posts() ) :
						$logoQuery->the_post();

						/* Argument for single member */
						$arg['pID']         = $pID = get_the_ID();
						$arg['title']       = get_the_title();
						$arg['url']         = get_post_meta( $pID, '_wls_site_url', true );
						$arg['description'] = get_post_meta( $pID, '_wls_logo_description', true );
						$arg['alt_text']    = get_post_meta( $pID, '_wls_logo_alt_text', true );
						$arg['img_src']     = get_post_meta( $pID, '_wls_logo_img_url', true );
						$imgClass           = 'wls-logo';

						if ( empty( $arg['img_src'] ) ) {
							if ( has_post_thumbnail() ) {
								$img            = wp_get_attachment_image(
									get_post_thumbnail_id(),
									$image_size,
									'',
									[
										'class' => $imgClass,
										'title' => $arg['title'],
									]
								);
								$imgS           = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
								$arg['img_src'] = $img;

								if ( 'full' == $image_size && ! empty( $imgSize ) ) {
									$c       = ( ! empty( $imgSize['crop'] ) ? true : false );
									$cropImg = $rtWLS->rtImageReSize( $imgS[0], $imgSize['width'], $imgSize['height'], $c );

									if ( $cropImg ) {
										$arg['img_src'] = "<img title='{$arg['title']}' src='{$cropImg}' width='{$imgSize['width']}' height='{$imgSize['height']}' class='{$imgClass}' alt='{$arg['alt_text']}'>";
									}
								}
							}
						} else {
							$arg['img_src'] = "<img title='{$arg['title']}' src='{$arg['img_src']}' width='{$imgSize['width']}' height='{$imgSize['height']}' class='{$imgClass}' alt='{$arg['alt_text']}'>";
						}

						if ( ! empty( $arg['img_src'] ) ) {
							$html .= $rtWLS->render( 'layouts/' . $layout, $arg, true );
						}

					endwhile;

					wp_reset_postdata();

					if ( $isIsotope ) {
						$html .= '</div>'; // end isotope item holder
					}

					$html .= '</div>'; // end row
					$html .= '</div>';// end container

					$scriptGenerator               = [];
					$scriptGenerator['isCarousel'] = $isCarousel;
					$scriptGenerator['isIsotope']  = $isIsotope;
					$this->scA[]                   = $scriptGenerator;

					add_action( 'wp_footer', [ $this, 'register_scripts' ] );
				} else {
					$html .= '<p>' . esc_html__( 'No logo found', 'wp-logo-showcase' ) . '</p>';
				}
			} else {
				$html .= '<p>' . esc_html__( 'No short code found', 'wp-logo-showcase' ) . '</p>';
			}

			return $html;
		}

		/**
		 * Layout inline style
		 *
		 * @param $rand
		 * @param $scMeta
		 *
		 * @return null|string
		 * @internal param $layoutId
		 */
		public function layoutStyle( $rand, $scMeta ) {
			$css  = null;
			$css .= '<style>';

			if ( isset( $scMeta['wls_primary_color'][0] ) && ! empty( $scMeta['wls_primary_color'][0] ) ) {
				$css .= "#rt-tooltip-{$rand}, #rt-tooltip-{$rand} .rt-tooltip-bottom:after{";
				$css .= "background-color : {$scMeta['wls_primary_color'][0]}";
				$css .= '}';
			}

			if ( isset( $scMeta['wls_button_bg_color'][0] ) && ! empty( $scMeta['wls_button_bg_color'][0] ) ) {
				$css .= "#rt-container-{$rand} .filter-button-group button{";
				$css .= "background-color : {$scMeta['wls_button_bg_color'][0]}";
				$css .= '}';

				$css .= "#rt-container-{$rand} .slick-prev:before, #rt-container-{$rand} .slick-next:before, #rt-container-{$rand} .slick-dots li button:before{";
				$css .= "color : {$scMeta['wls_button_bg_color'][0]}";
				$css .= '}';
			}

			if ( isset( $scMeta['wls_button_bg_hover_color'][0] ) && ! empty( $scMeta['wls_button_bg_hover_color'][0] ) ) {
				$css .= "#rt-container-{$rand} .filter-button-group button:hover{";
				$css .= "background-color : {$scMeta['wls_button_bg_hover_color'][0]}";
				$css .= '}';

				$css .= "#rt-container-{$rand} .slick-prev:hover:before, #rt-container-{$rand} .slick-next:hover:before, #rt-container-{$rand} .slick-dots li button:hover:before{";
				$css .= "color : {$scMeta['wls_button_bg_hover_color'][0]}";
				$css .= '}';
			}

			if ( isset( $scMeta['wls_button_bg_active_color'][0] ) && ! empty( $scMeta['wls_button_bg_active_color'][0] ) ) {
				$css .= "#rt-container-{$rand} .filter-button-group button.selected{";
				$css .= "background-color : {$scMeta['wls_button_bg_active_color'][0]}";
				$css .= '}';

				$css .= "#rt-container-{$rand} .slick-dots li.slick-active button:before{";
				$css .= "color : {$scMeta['wls_button_bg_active_color'][0]}";
				$css .= '}';
			}

			if ( ! empty( $scMeta['wls_button_text_color'][0] ) ) {
				$css .= "#rt-container-{$rand} .slick-prev:before, #rt-container-{$rand} .slick-next:before {";
				$css .= "background-color : {$scMeta['wls_button_text_color'][0]}";
				$css .= '}';

				$css .= "#rt-container-{$rand} .filter-button-group button {";
				$css .= "color : {$scMeta['wls_button_text_color'][0]}";
				$css .= '}';
			}

			if ( isset( $scMeta['_wls_style_title'][0] ) && ! empty( $scMeta['_wls_style_title'][0] ) ) {
				$title = unserialize( $scMeta['_wls_style_title'][0] );
				$css  .= "#rt-container-{$rand} .single-logo h3, #rt-container-{$rand} .single-logo h3 a {";

				if ( ! empty( $title['align'] ) ) {
					$css .= "text-align : {$title['align']};";
				}

				if ( ! empty( $title['color'] ) ) {
					$css .= "color : {$title['color']};";
				}

				if ( ! empty( $title['size'] ) ) {
					$css .= "font-size : {$title['size']}px;";
				}

				if ( ! empty( $title['weight'] ) ) {
					$css .= "font-weight : {$title['weight']};";
				}

				$css .= '}';

				if ( ! empty( $title['hover_color'] ) ) {
					$css .= "#rt-container-{$rand} .single-logo h3 a:hover {";
					$css .= "color : {$title['hover_color']};";
					$css .= '}';
				}
			}

			if ( isset( $scMeta['_wls_style_description'][0] ) && ! empty( $scMeta['_wls_style_description'][0] ) ) {
				$desc = unserialize( $scMeta['_wls_style_description'][0] );
				$css .= "#rt-container-{$rand} .single-logo .logo-description * {";

				if ( ! empty( $desc['align'] ) ) {
					$css .= "text-align : {$desc['align']};";
				}

				if ( ! empty( $desc['color'] ) ) {
					$css .= "color : {$desc['color']};";
				}

				if ( ! empty( $desc['size'] ) ) {
					$css .= "font-size : {$desc['size']}px;";
				}

				if ( ! empty( $desc['weight'] ) ) {
					$css .= "font-weight : {$desc['weight']};";
				}

				$css .= '}';
			}

			/* gutter */
			if ( isset( $scMeta['wls_gutter'][0] ) && ! empty( $scMeta['wls_gutter'][0] ) && $gutter = absint( $scMeta['wls_gutter'][0] ) ) {
				$css .= "#rt-container-{$rand}.rt-wpls [class*='rt-col-'] {";
				$css .= "padding-left : {$gutter}px;";
				$css .= "padding-right : {$gutter}px;";
				$css .= '}';

				$css .= "#rt-container-{$rand}.rt-wpls .rt-row{";
				$css .= "margin-left : -{$gutter}px;";
				$css .= "margin-right : -{$gutter}px;";
				$css .= '}';
			}

			global $rtWLS;

			$settings = get_option( $rtWLS->options['settings'] );
			$cCss     = ! empty( $settings['custom_css'] ) ? trim( $settings['custom_css'] ) : null;

			if ( $cCss ) {
				$css .= $cCss;
			}

			$css .= '</style>';

			return $css;
		}
	}
endif;
