<?php
/**
 * Helper Visual Composer compatibility Class
 *
 * This will generate the meta field for ShortCode generator post type
 *
 * @package RT_WSL
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! class_exists( 'rtWLVisualComposer' ) ) :
	/**
	 * Helper Visual Composer compatibility Class
	 */
	class rtWLVisualComposer {

		public function __construct() {
			add_action( 'vc_before_init', [ $this, 'wls_VC_initial' ] );
		}

		/**
		 *  Add the functionality for visual composer
		 */
		public function wls_VC_initial() {
			global $rtWLS;

			vc_map(
				[
					'name'     => esc_html__( 'Logo Showcase', 'wp-logo-showcase' ),
					'base'     => 'logo-showcase',
					'icon'     => $rtWLS->assetsUrl . 'images/icon-vc.png',
					'category' => esc_html__( 'Content', 'wp-logo-showcase' ),
					'params'   => [
						[
							'type'        => 'dropdown',
							'holder'      => 'div',
							'class'       => 'wpls-vc-wrapper',
							'admin_label' => true,
							'heading'     => esc_html__( 'Select a shortcode', 'wp-logo-showcase' ),
							'param_name'  => 'id',
							'value'       => $rtWLS->getWlsShortCodeListForVC(),
							'description' => esc_html__( 'Select a shortcode for displaying logo showcase', 'wp-logo-showcase' ),
						],
					],
				]
			);
		}
	}
endif;
