<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( post_password_required() ) {
    return;
}
?>
<div id="comments" class="comments-area">
    <?php if ( have_comments() ): ?>
        <?php
        $greenova_comment_count = get_comments_number();
        $greenova_comments_text = number_format_i18n( $greenova_comment_count ) . ' ';
        if ( $greenova_comment_count > 1 ) {
            $greenova_comments_text .= esc_html( 'Comments', 'greenova' );
        }
        else{
            $greenova_comments_text .= esc_html( 'Comment', 'greenova' );
        }
        ?>
        <h3 class="comment-num"><?php echo esc_html( $greenova_comments_text );?></h3>
        <?php
        $greenova_avatar = get_option( 'show_avatars' );
        ?>
       <ul class="comment-list<?php echo empty( $greenova_avatar ) ? ' avatar-disabled' : '';?>">
            <?php
            wp_list_comments(
                array(
                    'style'             => 'ul',
                    'callback'          => 'GREENOVA_Theme_Helper::comments_callback',
                    'reply_text'        => esc_html__( 'Reply', 'greenova' ),
                    'avatar_size'       => 100,
                    'format'            => 'html5',
                    ) 
                );
                ?>
            </ul>

            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
                <nav class="pagination-area comment-navigation">
                    <ul>
                        <li><?php previous_comments_link( esc_html__( 'Older Comments', 'greenova' ) ); ?></li>
                        <li><?php next_comments_link( esc_html__( 'Newer Comments', 'greenova' ) ); ?></li>
                    </ul>
                </nav><!-- #comment-nav-below -->
            <?php endif; // Check for comment navigation.?>

	<?php endif; ?>
	<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'greenova' ); ?></p>
	<?php endif;?>
	<?php
	// Start displaying Comment Form
	$greenova_commenter = wp_get_current_commenter();		
	$greenova_req = get_option( 'require_name_email' );
	$greenova_aria_req = ( $greenova_req ? " required" : '' );

	$greenova_fields =  array(
		'author' =>
		'<div class="col-sm-6 padding-left"><div class="form-group comment-form-author"><input type="text" id="author" name="author" value="' . esc_attr( $greenova_commenter['comment_author'] ) . '" placeholder="'.esc_attr__( 'Name', 'greenova' ).( $greenova_req ? ' *' : '' ).'" class="form-control"' . $greenova_aria_req . '></div></div>',

		'email' =>
		'<div class="col-sm-6 padding-right comment-form-email"><div class="form-group"><input id="email" name="email" type="email" value="' . esc_attr(  $greenova_commenter['comment_author_email'] ) . '" class="form-control" placeholder="'.esc_attr__( 'Email', 'greenova' ).( $greenova_req ? ' *' : '' ).'"' . $greenova_aria_req . '></div></div>',	
		
		'url' =>
		'<div class="col-sm-12 padding-left padding-right comment-form-website"><div class="form-group"><input id="website" name="website" type="text" value="' . esc_attr(  $greenova_commenter['comment_author_url'] ) . '" class="form-control" placeholder="'.esc_attr__( 'Website', 'greenova' ).( $greenova_req ? ' *' : '' ).'"' . $greenova_aria_req . '></div></div>',
		);

	$greenova_args = array(
		'class_submit'  => 'submit btn-send',
		'submit_field'  => '<div class="contact-dark-button form-group form-submit"><span class="">%1$s %2$s</span></div>',
		'comment_field' =>  '<div class="col-sm-12 padding-left padding-right comment-form-website"><div class="form-group comment-form-comment"><textarea id="comment" name="comment" placeholder="'.esc_attr__( 'Comment *', 'greenova' ).'" class="textarea form-control" rows="10" cols="40"></textarea></div></div>',
		'fields' => apply_filters( 'comment_form_default_fields', $greenova_fields ),
		);
		
		function move_comment_field_to_bottom( $fields ) {
			$comment_field = $fields['comment'];
			unset( $fields['comment'] );
			$fields['comment'] = $comment_field;
			return $fields;
		}

		add_filter( 'comment_form_fields', 'move_comment_field_to_bottom' );
		?>
		<?php comment_form( $greenova_args );?>
</div>