<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$greenova_theme_data = wp_get_theme();
define('GREENOVA_VERSION', (WP_DEBUG) ? time() : $greenova_theme_data->get('Version'));
define('GREENOVA_AUTHOR_URI', $greenova_theme_data->get('AuthorURI'));

// DIR
define('GREENOVA_BASE_DIR',    get_template_directory() . '/');
define('GREENOVA_INC_DIR',     GREENOVA_BASE_DIR . 'inc/');
define('GREENOVA_VIEW_DIR',    GREENOVA_INC_DIR . 'views/');
define('GREENOVA_LIB_DIR',     GREENOVA_BASE_DIR . 'lib/');
define('GREENOVA_PLUGINS_DIR', GREENOVA_INC_DIR . 'plugins/');
define('GREENOVA_ASSETS_DIR',  GREENOVA_BASE_DIR . 'assets/');
define('GREENOVA_CSS_DIR',     GREENOVA_ASSETS_DIR . 'css/');
define('GREENOVA_JS_DIR',      GREENOVA_ASSETS_DIR . 'js/');

// URL
define('GREENOVA_BASE_URL',    get_template_directory_uri() . '/');
define('GREENOVA_ASSETS_URL',  GREENOVA_BASE_URL . 'assets/');
define('GREENOVA_CSS_URL',     GREENOVA_ASSETS_URL . 'css/');
define('GREENOVA_AUTORTL_URL', GREENOVA_ASSETS_URL . 'css-rtl/'); //@rtl
define('GREENOVA_FONT_URL',    GREENOVA_ASSETS_URL . 'fonts/');
define('GREENOVA_JS_URL',      GREENOVA_ASSETS_URL . 'js/');
define('GREENOVA_IMG_URL',     GREENOVA_ASSETS_URL . 'img/');
define('GREENOVA_LIB_URL',     GREENOVA_BASE_URL . 'lib/');

// Includes
require_once GREENOVA_INC_DIR . 'redux-config.php';
require_once GREENOVA_INC_DIR . 'greenova.php';
require_once GREENOVA_INC_DIR . 'helper-functions.php';
require_once GREENOVA_INC_DIR . 'general.php';
require_once GREENOVA_INC_DIR . 'scripts.php';
require_once GREENOVA_INC_DIR . 'template-vars.php';
require_once GREENOVA_INC_DIR . 'vc-settings.php';
require_once GREENOVA_INC_DIR . 'sidebar-generator.php';

// WooCommerce
if (class_exists('WooCommerce')) {
	require_once GREENOVA_INC_DIR . 'woo-functions.php';
	require_once GREENOVA_INC_DIR . 'woo-hooks.php';
}

require_once GREENOVA_INC_DIR . 'search-widget.php'; // override default

// TGM Plugin Activation
require_once GREENOVA_INC_DIR . 'helper-traits/lc-utility.php';
require_once GREENOVA_LIB_DIR . 'class-tgm-plugin-activation.php';
require_once GREENOVA_INC_DIR . 'tgm-config.php';

add_editor_style('style-editor.css');

// Widgets fallback
if (function_exists('greenova_core_load_textdomain') && !defined('GREENOVA_CORE_UPDATE_1')) {
	add_action('admin_notices', 'greenova_widgets_fallback_notice');
}

function greenova_widgets_fallback_notice()
{
	$notice = '<div class="error"><p>' . sprintf(__("Please update plugin <b><i>Greenova Core</b></i> to the latest version otherwise some functionalities will not work properly. You can update it from <a href='%s'>here</a>", 'greenova'), menu_page_url('greenova-install-plugins', false)) . '</p></div>';
	echo wp_kses_post($notice);
}
