<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php do_action( 'wp_body_open' ); ?>
	<?php
		// Preloader
		if ( GREENOVA_Theme::$options['preloader'] ){
			if ( !empty( GREENOVA_Theme::$options['preloader_image']['url'] ) ) {
				$preloader_img = GREENOVA_Theme::$options['preloader_image']['url'];
			}
			else {
				$preloader_img = GREENOVA_IMG_URL . 'preloader.gif';
			}
			echo '<div id="preloader" style="background-image:url(' . esc_url( $preloader_img ) . ');"></div>';
		}
	?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'greenova' ); ?></a>
		<header id="masthead" class="site-header">
			<div id="header-<?php echo esc_attr( GREENOVA_Theme::$header_style ); ?>" class="header-area header-fixed ">
				<?php
				if ( GREENOVA_Theme::$top_bar == 1 || GREENOVA_Theme::$top_bar == 'on' ){ 		
				 	get_template_part( 'template-parts/header/header-top', GREENOVA_Theme::$top_bar_style );
				}	
				get_template_part( 'template-parts/header/header', GREENOVA_Theme::$header_style ); 
				?>
			</div>			
		</header>
		<?php get_template_part('template-parts/header/header', 'offscreen');?>
		<div id="header-area-space"></div>
		<div id="content" class="site-content">
			<?php get_template_part('template-parts/content', 'banner');?>