<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !isset( $content_width ) ) {
	$content_width = 1200;
}

add_action('after_setup_theme', 'greenova_setup');
if ( !function_exists( 'greenova_setup' ) ) {
	function greenova_setup() {
		// Language
		load_theme_textdomain( 'greenova', GREENOVA_BASE_DIR . 'languages' );

		// Theme support
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		add_theme_support( 'woocommerce' );
		
		// for gutenberg support
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-color-palette', array(
			array(
				'name' => __( 'strong magenta', 'greenova' ),
				'slug' => 'strong-magenta',
				'color' => '#a156b4',
			),
			array(
				'name' => __( 'light grayish magenta', 'greenova' ),
				'slug' => 'light-grayish-magenta',
				'color' => '#d0a5db',
			),
			array(
				'name' => __( 'very light gray', 'greenova' ),
				'slug' => 'very-light-gray',
				'color' => '#eee',
			),
			array(
				'name' => __( 'very dark gray', 'greenova' ),
				'slug' => 'very-dark-gray',
				'color' => '#444',
			),
		) );
		add_theme_support( 'editor-font-sizes', array(
			array(
				'name' => __( 'Small', 'greenova' ),
				'size' => 12,
				'slug' => 'small'
			),
			array(
				'name' => __( 'Normal', 'greenova' ),
				'size' => 16,
				'slug' => 'normal'
			),
			array(
				'name' => __( 'Large', 'greenova' ),
				'size' => 36,
				'slug' => 'large'
			),
			array(
				'name' => __( 'Huge', 'greenova' ),
				'size' => 50,
				'slug' => 'huge'
			)
		) );
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'editor-styles' );

		// Image sizes
		add_image_size( 'greenova-size1', 1200, 600, true ); // post/news large
		add_image_size( 'greenova-size2', 460, 270, true ); // in the blog page -layout 2
		add_image_size( 'greenova-size3', 80, 80, true ); // small image for side bar
		add_image_size( 'greenova-size4', 370, 475, true ); // Signle Team
		add_image_size( 'greenova-size5', 370, 370, true ); // Testimonial
		add_image_size( 'greenova-size6', 350, 450, true ); // Team Slider
		add_image_size( 'greenova-size7', 362, 234, true ); // Project Slider - 4
		add_image_size( 'greenova-size8', 600, 300, true ); // Service Slider 3 / Grid
		add_image_size( 'greenova-size9', 278, 326, true );
		add_image_size( 'greenova-size10', 152, 136, true ); // small image for side bar
		add_image_size( 'greenova-size11', 370, 240, true ); // Blog slider 7
		add_image_size( 'greenova-size12', 290, 270, true ); // Team Slider 10
		add_image_size( 'greenova-size13', 500, 308, true ); // project grid 03
		add_image_size( 'greenova-size14', 410, 265, true ); // project grid 03
		add_image_size( 'greenova-size15', 750, 400, true ); // Service layout 10
		add_image_size( 'greenova-size16', 460, 600, true ); // Project Slider - 3
		add_image_size( 'greenova-size17', 900, 700, true ); // project grid 04

		// Register menus
		register_nav_menus( array(
			'primary'  => esc_html__( 'Primary', 'greenova' ),
			'topright' => esc_html__( 'Header Right', 'greenova' ),
		) );

		//HTML5 Support
		add_theme_support( 'html5', [ 'script', 'style' ] );
		
		add_editor_style();		
	}
}

function greenova_theme_add_editor_styles() {
	add_editor_style( get_stylesheet_uri() );
}
add_action( 'admin_init', 'greenova_theme_add_editor_styles' );

// Initialize Widgets
add_action( 'widgets_init', 'greenova_widgets_register' );
if ( !function_exists( 'greenova_widgets_register' ) ) {
	function greenova_widgets_register() {
		
		$footer_widget_titles = array(
			'1' => esc_html__( 'Footer 1', 'greenova' ),
			'2' => esc_html__( 'Footer 2', 'greenova' ),
			'3' => esc_html__( 'Footer 3', 'greenova' ),
			'4' => esc_html__( 'Footer 4', 'greenova' ),
		);

		// Register Widget Areas ( Common )
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar', 'greenova' ),
			'id'            => 'sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widgettitle">',
			'after_title'   => '</h3>',
			) );
			
		// Register Widget Areas ( for Single Case Study Post )
		register_sidebar( array(
			'name'          => esc_html__( 'Service Sidebar', 'greenova' ),
			'id'            => 'sidebar-service',
			'before_widget' => '<div id="%1$s" class="widget %2$s custom-widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widgettitle">',
			'after_title'   => '</h3>',
			) );

		for ( $i = 1; $i <= GREENOVA_Theme::$options['footer_column']; $i++ ) {
			register_sidebar( array(
				'name'          => $footer_widget_titles[$i],
				'id'            => 'footer-'. $i,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widgettitle">',
				'after_title'   => '</h3>',
				) );		
		}
	}
}


// Head Script
add_action( 'wp_head', 'greenova_head', 1 );
if( !function_exists( 'greenova_head' ) ) {
	function greenova_head(){
		// Hide preloader if js is disabled
		echo '<noscript><style>#preloader{display:none;}</style></noscript>';
	}	
}

// Footer Html
add_action( 'wp_footer', 'greenova_footer_html', 1 );
if( !function_exists( 'greenova_footer_html' ) ) {
	function greenova_footer_html(){
		// Back-to-top link
		if ( GREENOVA_Theme::$options['back_to_top'] ){
			echo '<a href="#" class="scrollToTop"><i class="fas fa-arrow-up"></i></a>';
		}
	}	
}

add_action('admin_head', 'my_custom_fonts');

function my_custom_fonts() {
  echo '<style>
	.what{float:left; margin-right: 10px;}
  </style>';
}

// advanced search functionality
function advanced_search_query($query) {

    if($query->is_search()) {
        // category terms search.
        if (isset($_GET['category']) && !empty($_GET['category'])) {
            $query->set('tax_query', array(array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => array($_GET['category']) )
            ));
        }    
    }
    return $query;
}
add_action('pre_get_posts', 'advanced_search_query', 1000);

/*for image in the menu - LATER USE FOR HIDE THE IMAGE OPTION*/
add_filter( 'manage_nav-menus_columns', 'menu_image_nav_menu_manage_columns' , 11 );

function menu_image_nav_menu_manage_columns( $columns ) {
	return $columns + array( 'image' => esc_html__( 'Image', 'greenova' ) );
}

/*find new product with time*/
function rt_is_new( $id ) {
	$now    = time();
	$published_date = get_post_time('U');
	$diff =  $now - $published_date;
	if ($diff < 604800) { ?>
		<span class="new-product"><?php esc_html_e( 'New' , 'greenova' ); ?></span>
	<?php }
}

