<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !class_exists( 'GREENOVA_Theme_Helper' ) ) {
	
	class GREENOVA_Theme_Helper {

		public static function pagination() {

			if( is_singular() )
				return;

			global $wp_query;

			/** Stop execution if there's only 1 page */
			if( $wp_query->max_num_pages <= 1 )
				return;

			$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
			$max   = intval( $wp_query->max_num_pages );

			/**	Add current page to the array */
			if ( $paged >= 1 )
				$links[] = $paged;

			/**	Add the pages around the current page to the array */
			if ( $paged >= 3 ) {
				$links[] = $paged - 1;
				$links[] = $paged - 2;
			}

			if ( ( $paged + 2 ) <= $max ) {
				$links[] = $paged + 2;
				$links[] = $paged + 1;
			}
			include GREENOVA_VIEW_DIR . 'pagination.php';
		}


		public static function comments_callback( $comment, $args, $depth ){
			include GREENOVA_VIEW_DIR . 'comments-callback.php';
		}

		public static function hex2rgb($hex) {
			$hex = str_replace("#", "", $hex);
			if(strlen($hex) == 3) {
				$r = hexdec(substr($hex,0,1).substr($hex,0,1));
				$g = hexdec(substr($hex,1,1).substr($hex,1,1));
				$b = hexdec(substr($hex,2,1).substr($hex,2,1));
			} else {
				$r = hexdec(substr($hex,0,2));
				$g = hexdec(substr($hex,2,2));
				$b = hexdec(substr($hex,4,2));
			}
			$rgb = "$r, $g, $b";
			return $rgb;
		}

		public static function rt_modify_color( $hex, $steps ) {
			$steps = max( -255, min( 255, $steps ) );
			// Format the hex color string
			$hex = str_replace( '#', '', $hex );
			if ( strlen( $hex ) == 3 ) {
				$hex = str_repeat( substr( $hex,0,1 ), 2 ).str_repeat( substr( $hex,1,1 ), 2 ).str_repeat( substr( $hex,2,1 ), 2 );
			}
			// Get decimal values
			$r = hexdec( substr( $hex,0,2 ) );
			$g = hexdec( substr( $hex,2,2 ) );
			$b = hexdec( substr( $hex,4,2 ) );
			// Adjust number of steps and keep it inside 0 to 255
			$r = max( 0,min( 255,$r + $steps ) );
			$g = max( 0,min( 255,$g + $steps ) );
			$b = max( 0,min( 255,$b + $steps ) );
			$r_hex = str_pad( dechex( $r ), 2, '0', STR_PAD_LEFT );
			$g_hex = str_pad( dechex( $g ), 2, '0', STR_PAD_LEFT );
			$b_hex = str_pad( dechex( $b ), 2, '0', STR_PAD_LEFT );
			return '#'.$r_hex.$g_hex.$b_hex;
		}

		public static function filter_social( $args ){
			return ( $args['url'] != '' );
		}
		
		public static function fonts_url(){

			$font_url = '';

			if ( 'off' !== _x( 'on', 'Google fonts - Open Sans and Raleway : on or off', 'greenova' ) ) {
				$font_families = array();
		
				$font_families[] = 'Poppins:400,500,600,700';
				$font_families[] = 'Roboto:400,500,700';
		
				$query_args = array(
					'family' => urlencode( implode( '|', $font_families ) ),
					'display' => urlencode( 'swap' ),
				);
		
				$font_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
			}
		
			return esc_url_raw( $font_url );
		}
		
		//@rtl
		public static function maybe_rtl( $css ){
			if ( is_rtl() ) {
				return GREENOVA_AUTORTL_URL . $css;
			}
			else {
				return GREENOVA_CSS_URL . $css;
			}
		}
		
		public static function socials(){
			$greenova_socials = array(
				'social_facebook' => array(
					'icon' => 'fa-facebook-f',
					'url'  => GREENOVA_Theme::$options['social_facebook'],
				),
				'social_twitter' => array(
					'icon' => 'fa-twitter',
					'url'  => GREENOVA_Theme::$options['social_twitter'],
				),
				'social_gplus' => array(
					'icon' => 'fa-google-plus-g',
					'url'  => GREENOVA_Theme::$options['social_gplus'],
				),
				'social_linkedin' => array(
					'icon' => 'fa-linkedin-in',
					'url'  => GREENOVA_Theme::$options['social_linkedin'],
				),
				'social_youtube' => array(
					'icon' => 'fa-youtube',
					'url'  => GREENOVA_Theme::$options['social_youtube'],
				),
				'social_pinterest' => array(
					'icon' => 'fa-pinterest-p',
					'url'  => GREENOVA_Theme::$options['social_pinterest'],
				),
				'social_instagram' => array(
					'icon' => 'fa-instagram',
					'url'  => GREENOVA_Theme::$options['social_instagram'],
				),
				'social_skype' => array(
					'icon' => 'fa-skype',
					'url'  => GREENOVA_Theme::$options['social_skype'],
				),
				'social_rss' => array(
					'icon' => 'fa-rss',
					'url'  => GREENOVA_Theme::$options['social_rss'],
				),
			);
			return array_filter( $greenova_socials, array( 'GREENOVA_Theme_Helper' , 'filter_social' ) );
		}

		public static function nav_menu_args(){
			$greenova_pagemenu = false;
			if ( ( is_single() || is_page() ) ) {
				$greenova_menuid = get_post_meta( get_the_id(), 'greenova_page_menu', true );
				if ( !empty( $greenova_menuid ) && $greenova_menuid != 'default' ) {
					$greenova_pagemenu = $greenova_menuid;
				}
			}
			if ( $greenova_pagemenu ) {
				$nav_menu_args = array( 'menu' => $greenova_pagemenu,'container' => 'nav' );
			}
			else {
				$nav_menu_args = array( 'theme_location' => 'primary','container' => 'nav' );
			}
			return $nav_menu_args;		
		}
				
		public static function has_footer(){
			if ( !GREENOVA_Theme::$options['footer_area']  ) {
				return false;
			}
			$footer_column = GREENOVA_Theme::$options['footer_column'];
			for ( $i = 1; $i <= $footer_column; $i++ ) {
				if ( is_active_sidebar( 'footer-'. $i ) ) {
					return true;
				}
			}
			return false;
		}
		
		public static function filter_content( $content ){
			// wp filters
			$content = wptexturize( $content );
			$content = convert_smilies( $content );
			$content = convert_chars( $content );
			$content = wpautop( $content );
			$content = shortcode_unautop( $content );

			// remove shortcodes
			$pattern= '/\[(.+?)\]/';
			$content = preg_replace( $pattern,'',$content );

			// remove tags
			$content = strip_tags( $content );

			return $content;
		}

		public static function create_dynamic_css_file( $file ){
			global $wp_filesystem;
			if ( empty( $wp_filesystem ) ) {
				require_once ( ABSPATH . '/wp-admin/includes/file.php' );
				WP_Filesystem();
			}

			$dynamic_css = '/* This file is auto generated based on theme options. DO NOT MODIFY THIS FILE */';
			ob_start();
			include GREENOVA_INC_DIR . 'variable-style.php';
			include GREENOVA_INC_DIR . 'variable-style-vc.php';
			$dynamic_css .= ob_get_clean();
			//$dynamic_css .= wp_kses_post( GREENOVA_Theme::$options['custom_css'] ); // custom css
			$wp_filesystem->put_contents( $file, $dynamic_css, FS_CHMOD_FILE );
		}

		public static function dynamic_internal_style(){
			ob_start();
			include GREENOVA_INC_DIR . 'variable-style.php';
			include GREENOVA_INC_DIR . 'variable-style-vc.php';
			$dynamic_css  = ob_get_clean();
			//$dynamic_css .= wp_kses_post( GREENOVA_Theme::$options['custom_css'] ); // custom css
			wp_register_style( 'greenova-dynamic', false );
			wp_enqueue_style( 'greenova-dynamic' );
			wp_add_inline_style( 'greenova-dynamic', $dynamic_css );	
		}

		public static function get_file( $path ){
			$file = get_stylesheet_directory_uri() . $path;
			if ( !file_exists( $file ) ) {
				$file = get_template_directory_uri() . $path;
			}
			return $file;
		}

		public static function get_css( $filename ){
			$path = '/assets/css/' . $filename . '.css';
			return self::get_file( $path );
		}
	}
}