<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( ! class_exists( 'Redux' ) ) {
    return;
}

$opt_name = 'greenova';

$theme = wp_get_theme();
$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'disable_tracking' => true,
    'display_name'         => $theme->get( 'Name' ),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get( 'Version' ),
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__( 'Greenova Options', 'greenova' ),
	
    'page_title'           => esc_html__( 'Greenova Options', 'greenova' ),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    //'google_api_key'       => 'AIzaSyC2GwbfJvi-WnYpScCPBGIUyFZF97LI0xs',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,   // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-menu',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => false,
    'forced_dev_mode_off'  => false,
    // Show the time the page took to load, etc
    'update_notice'        => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'greenova-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => true,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
);

Redux::setArgs( $opt_name, $args );

// Fields
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'General', 'greenova' ),
    'id'               => 'general_section',
    'heading'          => '',
    'icon'             => 'el el-network',
    'fields' => array(
        array(
            'id'       => 'primary_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Primary Color', 'greenova' ),
            'default'  => '#1fa12e',
        ),		
        array(
            'id'       => 'container_width',
            'type'     => 'select',
            'title'    => esc_html__( 'Container width( Bootstrap Grid )', 'greenova'), 
            'subtitle' => esc_html__( 'Bootstrap Grid Container Width size for site.', 'greenova' ),
            'options'  => array(
                '1350' => esc_html__( '1350px', 'greenova' ),
                '1290' => esc_html__( '1290px', 'greenova' ),
                '1170' => esc_html__( '1170px', 'greenova' ),
            ),
            'default'  => '1350',
        ),
        array(
            'id'       => 'preloader',
            'type'     => 'switch',
            'title'    => esc_html__( 'Preloader', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Preloader Image', 'greenova' ),
            'subtitle' => esc_html__( 'Please upload your choice of preloader image. Transparent GIF format is recommended', 'greenova' ),
            'default'  => array(
                'url'=> GREENOVA_IMG_URL . 'preloader.gif'
            ),
            'required' => array( 'preloader', 'equals', true )
        ),
        array(
            'id'       => 'back_to_top',
            'type'     => 'switch',
            'title'    => esc_html__( 'Back to Top Arrow', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => 'no_preview_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Alternative Preview Image', 'greenova' ),
            'subtitle' => esc_html__( 'This image will be used as preview image in some archive pages if no featured image exists', 'greenova' ),
            'default'  => array(
                'url'=> GREENOVA_IMG_URL . 'noimage.jpg'
            ),
        ),
		array(
			'id'       => 'team_slug',
			'type'     => 'text',
			'title'    => esc_html__( 'Team Single Slug', 'greenova' ),
			'default'  => 'team',
		),
        array(
            'id'       => 'team_cat_slug',
            'type'     => 'text',
            'title'    => esc_html__( 'Team Category Slug', 'greenova' ),
            'default'  => 'green_team_cat',
        ),
		array(
			'id'       => 'service_slug',
			'type'     => 'text',
			'title'    => esc_html__( 'Service Single Slug', 'greenova' ),
			'default'  => 'service',
		),
        array(
            'id'       => 'service_cat_slug',
            'type'     => 'text',
            'title'    => esc_html__( 'Services Category Slug', 'greenova' ),
            'default'  => 'greenova_service_category',
        ),
		array(
			'id'       => 'project_slug',
			'type'     => 'text',
			'title'    => esc_html__( 'Project Single Slug', 'greenova' ),
			'default'  => 'project',
		),
        array(
            'id'       => 'project_cat_slug',
            'type'     => 'text',
            'title'    => esc_html__( 'Projects Category Slug', 'greenova' ),
            'default'  => 'greenova_project_category',
        ),
    )
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Contact & Socials', 'greenova' ),
    'id'               => 'socials_section',
    'heading'          => '',
    'desc'             => esc_html__( 'In case you want to hide any field, keep that field empty', 'greenova' ),
    'icon'             => 'el el-twitter',
    'fields' => array(
        array(
            'id'       => 'phone',
            'type'     => 'text',
            'title'    => esc_html__( 'Phone', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'email',
            'type'     => 'text',
            'title'    => esc_html__( 'Email', 'greenova' ),
            'validate' => 'email',
            'default'  => '',
        ),
        array(
            'id'       => 'address',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Address', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'hour',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Office Hour', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_facebook',
            'type'     => 'text',
            'title'    => esc_html__( 'Facebook', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_twitter',
            'type'     => 'text',
            'title'    => esc_html__( 'Twitter', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_gplus',
            'type'     => 'text',
            'title'    => esc_html__( 'Google Plus', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_linkedin',
            'type'     => 'text',
            'title'    => esc_html__( 'Linkedin', 'greenova' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_youtube',
            'type'     => 'text',
            'title'    => esc_html__( 'Youtube', 'greenova' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_pinterest',
            'type'     => 'text',
            'title'    => esc_html__( 'Pinterest', 'greenova' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_instagram',
            'type'     => 'text',
            'title'    => esc_html__( 'Instagram', 'greenova' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_skype',
            'type'     => 'text',
            'title'    => esc_html__( 'Skype', 'greenova' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_rss',
            'type'     => 'text',
            'title'    => esc_html__( 'RSS', 'greenova' ),
            'default'  => '',
        ),
    )            
) );

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Header', 'greenova' ),
    'id'               => 'header_section',
    'heading'          => '',
    'icon'             => 'el el-caret-up',
    'fields' => array(
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => esc_html__( 'Main Logo', 'greenova' ),
            'default'  => array(
                'url'=> GREENOVA_IMG_URL . 'logo.png'
            ),
            'subtitle' => esc_html__( 'Logo height less than 90px is recommended', 'greenova' ),
        ),
        array(
            'id'       => 'logo_light',
            'type'     => 'media',
            'title'    => esc_html__( 'Light Logo', 'greenova' ),
            'default'  => array(
                'url'=> GREENOVA_IMG_URL . 'logo2.png'
            ),
            'subtitle' => esc_html__( 'Used when Transparent Header is enabled. Logo height less than 90px is recommended', 'greenova' ),
        ),
        array(
            'id'       => 'logo_width',
            'type'     => 'select',
            'title'    => esc_html__( 'Logo Area Width', 'greenova'), 
            'subtitle' => esc_html__( 'Width is defined by the number of bootstrap columns. Please note, navigation menu width will be decreased with the increase of logo width', 'greenova' ),
            'options'  => array(
                '1' => esc_html__( '1 Column', 'greenova' ),
                '2' => esc_html__( '2 Column', 'greenova' ),
                '3' => esc_html__( '3 Column', 'greenova' ),
                '4' => esc_html__( '4 Column', 'greenova' ),
            ),
            'default'  => '3',
        ),
        array(
            'id'       => 'logo_width',
            'type'     => 'select',
            'title'    => esc_html__( 'Logo Area Width', 'greenova'), 
            'subtitle' => esc_html__( 'Width is defined by the number of bootstrap columns. Please note, navigation menu width will be decreased with the increase of logo width', 'greenova' ),
            'options'  => array(
                '1' => esc_html__( '1 Column', 'greenova' ),
                '2' => esc_html__( '2 Column', 'greenova' ),
                '3' => esc_html__( '3 Column', 'greenova' ),
                '4' => esc_html__( '4 Column', 'greenova' ),
            ),
            'default'  => '2',
        ),
        array(
            'id'       => 'sticky_menu',
            'type'     => 'switch',
            'title'    => esc_html__( 'Sticky Header', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
            'subtitle' => esc_html__( 'Show header when scroll down', 'greenova' ),
        ), 
        array(
            'id'       => 'tr_header',
            'type'     => 'switch',
            'title'    => esc_html__( 'Transparent Header', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => false,
            'subtitle' => esc_html__( 'You have to enable Banner or Slider in page to make it work properly. You can override this settings in individual pages', 'greenova' ),
        ),
        array(
            'id'       => 'top_bar',
            'type'     => 'switch',
            'title'    => esc_html__( 'Top Bar - Desktop', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => false,
            'subtitle' => esc_html__( 'Show topbar for Desktop. You can override this settings in individual pages', 'greenova' ),
        ),
        array(
	        'id'       => 'top_bar_mobile',
	        'type'     => 'switch',
	        'title'    => esc_html__( 'Top Bar - Mobile', 'greenova' ),
	        'on'       => esc_html__( 'Enabled', 'greenova' ),
	        'off'      => esc_html__( 'Disabled', 'greenova' ),
	        'default'  => true,
	        'subtitle' => esc_html__( 'Show Topbar for mobile', 'greenova' ),
        ),
        array(
            'id'       => 'top_bar_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Top Bar Text Color', 'greenova' ),
            'default'  => '#646464',
        ),
        array(
            'id'       => 'top_bar_color_tr',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Transparent Top Bar Text Color', 'greenova' ),
            'subtitle' => esc_html__( 'Applied when Transparent Header is enabled', 'greenova' ),
            'default'  => '#efefef',
        ),
        array(
            'id'       => 'top_bar_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Top Bar Layout', 'greenova' ),
			'subtitle' => esc_html__( 'You can override this settings in individual pages', 'greenova' ),
            'default'  => '7',
            'options' => array(
			
				'7' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top7.png',
                ),
                '1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top1.png',
                ),
                '2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 3', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top2.png',
                ),
                '3' => array(
                    'title' => '<b>'. esc_html__( 'Layout 4', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top3.png',
                ),
                '4' => array(
                    'title' => '<b>'. esc_html__( 'Layout 5', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top4.png',
                ),
                '5' => array(
                    'title' => '<b>'. esc_html__( 'Layout 6', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top5.png',
                ),
				'6' => array(
                    'title' => '<b>'. esc_html__( 'Layout 7', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'top6.png',
                ),
            ),
        ),
        array(
            'id'       => 'top_bar_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Top Bar Background Color', 'greenova' ),
            'default'  => '#f2f2f2',
        ),
        array(
            'id'       => 'header_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Header Layout', 'greenova' ),
			'subtitle' => esc_html__( 'You can override this settings in individual pages', 'greenova' ),
            'default'  => '1',
            'options' => array(
                '1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-1.png',
                ),
                '2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-2.png',
                ),
                '3' => array(
                    'title' => '<b>'. esc_html__( 'Layout 3', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-3.png',
                ),
                '4' => array(
                    'title' => '<b>'. esc_html__( 'Layout 4', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-4.png',
                ),
                '5' => array(
                    'title' => '<b>'. esc_html__( 'Layout 5', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-5.png',
                ),
                '6' => array(
                    'title' => '<b>'. esc_html__( 'Layout 6', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-6.png',
                ),
                '10' => array(
                    'title' => '<b>'. esc_html__( 'Layout 7', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-10.png',
                ),
                '11' => array(
                    'title' => '<b>'. esc_html__( 'Layout 8', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-11.png',
                ),
				'12' => array(
                    'title' => '<b>'. esc_html__( 'Layout 9', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-12.png',
                ),
				'9' => array(
                    'title' => '<b>'. esc_html__( 'Layout 10', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'header-13.png',
                ),
            ),
        ),
		/*for top quick link*/ 
        array(
            'id'       => 'header_hotline_txt',
            'type'     => 'text',
            'title'    => esc_html__( 'Header "Hotline" Text', 'greenova' ),
            'subtitle' => esc_html__( 'Used for header style 6 , 7, 8, 9', 'greenova' ),
            'default'  => esc_html__( 'Hotline', 'greenova' )
        ),
        array(
            'id'       => 'header_location_txt',
            'type'     => 'text',
            'title'    => esc_html__( 'Header "Location" Text', 'greenova' ),
            'subtitle' => esc_html__( 'Used for header style 6 , 7, 8, 9', 'greenova' ),
            'default'  => esc_html__( 'Location', 'greenova' )		
        ),
        array(
            'id'       => 'header_officehour_txt',
            'type'     => 'text',
            'title'    => esc_html__( 'Header "Office Hour" Text', 'greenova' ),
            'subtitle' => esc_html__( 'Used for header style 6 , 7, 8, 9', 'greenova' ),
            'default'  => esc_html__( 'Office Hour', 'greenova' )
        ),
        array(
            'id'       => 'header_mailus_txt',
            'type'     => 'text',
            'title'    => esc_html__( 'Header "Mail Us" Text', 'greenova' ),
            'subtitle' => esc_html__( 'Used for header style 9', 'greenova' ),
            'default'  => esc_html__( 'Mail Us', 'greenova' ),
			'required' => array(
				array('header_style','equals','12')
			)
        ),
		/**/
        array(
            'id'       => 'header_5_show_icon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Header 5 Show icon', 'greenova' ),
			'subtitle' => esc_html__( 'Only used in Header Layout-5', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,			
        ),
        array(
            'id'       => 'header_btn_txt',
            'type'     => 'text',
            'title'    => esc_html__( 'Header Button Text', 'greenova' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-4 and Layout-12. Keep blank if you don\'t want to use the button', 'greenova' ),
            'default'  => esc_html__( 'Get a Quota', 'greenova' ),
        ),
        array(
	        'id'       => 'header_mobile_btn_txt',
	        'type'     => 'text',
	        'title'    => esc_html__( 'Header Mobile Button Text', 'greenova' ),
	        'subtitle' => esc_html__( 'Keep blank if you don\'t want to use the button', 'greenova' ),
	        'default'  => esc_html__( 'Get a Quota', 'greenova' ),
        ),
        array(
            'id'       => 'header_btn_url',
            'type'     => 'text',
            'title'    => esc_html__( 'Header Button URL', 'greenova' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-4', 'greenova' ),
            'default'  => '#',
        ),		
        array(
            'id'       => 'top_bar_txt',
            'type'     => 'text',
            'title'    => esc_html__( 'Top Bar Text', 'greenova' ),
            'subtitle' => esc_html__( 'Only used in Topbar Layout-4', 'greenova' ),
            'default'  => esc_html__( 'We offer landscaping , maintenance and design for residential, commercial and industrial clients.', 'greenova' ),
        ),
        array(
            'id'       => 'search_icon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Search Icon', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'cart_icon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Cart Icon', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'vertical_menu_icon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Vertical Menu Icon', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ),
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Main Menu', 'greenova' ),
    'id'               => 'menu_section',
    'heading'          => '',
    'icon'             => 'el el-book',
    'fields' => array(
        array(
            'id'       => 'section-mainmenu',
            'type'     => 'section',
            'title'    => esc_html__( 'Main Menu Items', 'greenova' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'menu_typo',
            'type'     => 'typography',
            'title'    => esc_html__( 'Menu Font', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align' => false,
            'color'   => false,
            'text-transform' => true,
            'default'     => array(
                'font-family' 	 => 'Poppins',
                'google'      	 => true,
                'font-size'   	 => '15px',
                'font-weight' 	 => '500',
                'line-height' 	 => '16px',
                'text-transform' => 'uppercase',
            ),
        ),
        array(
            'id'       => 'menu_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Menu Color', 'greenova' ),
            'default'  => '#111111',
        ),
		/*menu background color for header style 6,10,11 */
		array(
            'id'       => 'menu_color_6',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Header 6 Menu Color', 'greenova' ),
            'default'  => '#ffffff',
			'required' => array(
				array('header_style','equals','6')
			)
        ),
		array(
            'id'       => 'menu_hover_color_6',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Header 6 Menu Hover Color', 'greenova' ),
            'default'  => '#e2e2e2',
			'required' => array(
				array('header_style','equals','6')
			)
        ),
        array(
            'id'       => 'menu_bgcolor_6',
            'type'     => 'color',
            'title'    => esc_html__('Menu Background Color', 'greenova'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#1fa12e',
			'required' => array(
				array('header_style','equals','6')
			)
        ),
		/*header 10*/
		array(
            'id'       => 'menu_color_10',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Header 7 Menu Color', 'greenova' ),
            'default'  => '#ffffff',
			'required' => array(
				array('header_style','equals','10')
			)
        ),
		array(
            'id'       => 'menu_hover_color_10',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Header 7 Menu Hover Color', 'greenova' ),
            'default'  => '#e2e2e2',
			'required' => array(
				array('header_style','equals','10')
			)
        ),
        array(
            'id'       => 'menu_bgcolor_10',
            'type'     => 'color',
            'title'    => esc_html__('Menu Background Color', 'greenova'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#1fa12e',
			'required' => array( 
				array('header_style','equals','10')
			)
        ),
		/*header 11*/
		array(
            'id'       => 'menu_color_11',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Header 8 Menu Color', 'greenova' ),
            'default'  => '#ffffff',
			'required' => array(
				array('header_style','equals','11')
			)
        ),
		array(
            'id'       => 'menu_hover_color_11',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Header 8 Menu Hover Color', 'greenova' ),
            'default'  => '#e2e2e2',
			'required' => array(
				array('header_style','equals','11')
			)
        ),
        array(
            'id'       => 'menu_bgcolor_11',
            'type'     => 'color',
            'title'    => esc_html__('Menu Background Color', 'greenova'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#1fa12e',
			'required' => array( 
				array('header_style','equals','11')
			)
        ),
        array(
            'id'       => 'menu_color_tr',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Transparent Menu Color', 'greenova' ),
            'subtitle' => esc_html__( 'Applied when Transparent Header is enabled', 'greenova' ),
            'default'  => '#fff',
        ),
        array(
            'id'       => 'menu_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Menu Hover Color', 'greenova' ),
            'default'  => '#1fa12e',
        ),
        array(
            'id'       => 'section-submenu',
            'type'     => 'section',
            'title'    => esc_html__( 'Sub Menu Items', 'greenova' ),
            'indent'   => true,
        ), 
        array(
            'id'       => 'submenu_typo',
            'type'     => 'typography',
            'title'    => esc_html__( 'Submenu Font', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'text-transform' => true,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '400',
                'line-height' => '21px',
                'text-transform' => 'inherit',
            ),
        ),
        array(
            'id'       => 'submenu_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Color', 'greenova' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'submenu_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Background Color', 'greenova' ),
            'default'  => '#1fa12e',
        ),  
        array(
            'id'       => 'submenu_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Hover Color', 'greenova' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'submenu_hover_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Hover Background Color', 'greenova' ),
            'default'  => '#1e902b',
        ),
        array(
            'id'       => 'section-resmenu',
            'type'     => 'section',
            'title'    => esc_html__( 'Mobile Menu', 'greenova' ),
            'indent'   => true,
        ), 
        array(
            'id'       => 'resmenu_width',
            'type'     => 'slider',
            'title'    => esc_html__( 'Screen width in which mobile menu activated', 'greenova' ),
            'subtitle' => esc_html__( 'Recommended value is: 992', 'greenova' ),
            'default'  => 992,
            'min'      => 0,
            'step'     => 1,
            'max'      => 2000,
        ),
        array(
            'id'       => 'resmenu_typo',
            'type'     => 'typography',
            'title'    => esc_html__( 'Mobile Menu Font', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'text-transform' => true,
            'default'     => array(
				'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '14px',
                'font-weight' => '400',
                'line-height' => '21px',
                'text-transform' => 'uppercase',				
            ),
        ),
    )
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Banner', 'greenova' ),
    'id'               => 'banner_section',
    'heading'          => '',
    'icon'             => 'el el-flag',
    'fields' => array(
        array(
            'id'       => 'banner_heading_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Banner Heading Color', 'greenova' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'breadcrumb_link_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Breadcrumb Link Color', 'greenova' ),
            'default'  => '#a3e0aa',
        ),
        array(
            'id'       => 'breadcrumb_link_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Breadcrumb Link Hover Color', 'greenova' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'breadcrumb_active_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Active Breadcrumb Color', 'greenova' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'breadcrumb_seperator_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Breadcrumb Seperator Color', 'greenova' ),
            'default'  => '#ffffff',
        ),
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Footer', 'greenova' ),
    'id'               => 'footer_section',
    'heading'          => '',
    'icon'             => 'el el-caret-down',
    'fields' => array(
		/*main footer part*/
        array(
            'id'       => 'section-footer-area',
            'type'     => 'section',
            'title'    => esc_html__( 'Footer Area', 'greenova' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'footer_area',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display Footer Area', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => 'footer_column',
            'type'     => 'select',
            'title'    => esc_html__( 'Number of Columns', 'greenova' ),
            'options'  => array(
                '1' => '1 Column',
                '2' => '2 Columns',
                '3' => '3 Columns',
                '4' => '4 Columns',
            ),
            'default'  => '4',
            'required' => array( 'footer_area', 'equals', true )
        ),
        array(
            'id'       => 'footer_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Background Color', 'greenova' ),
            'default'  => '#161616',
            'required' => array( 'footer_area', 'equals', true ),
        ), 
        array(
            'id'       => 'footer_title_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Title Text Color', 'greenova' ),
            'default'  => '#ffffff',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Body Text Color', 'greenova' ),
            'default'  => '#c4c4c4',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_link_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Body Link Color', 'greenova' ),
            'default'  => '#c4c4c4',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_link_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Body Link Hover Color', 'greenova' ),
            'default'  => '#1fa12e',
            'required' => array( 'footer_area', 'equals', true )
        ),
        array(
            'id'       => 'section-copyright-area',
            'type'     => 'section',
            'title'    => esc_html__( 'Copyright Area', 'greenova' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'copyright_area',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display Copyright Area', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => 'copyright_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Copyright Background Color', 'greenova' ),
            'default'  => '#000000',
            'required' => array( 'copyright_area', 'equals', true )
        ),
        array(
            'id'       => 'copyright_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Copyright Text Color', 'greenova' ),
            'default'  => '#dddddd',
            'required' => array( 'copyright_area', 'equals', true )
        ),
        array(
            'id'       => 'copyright_text',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Copyright Text', 'greenova' ),
            'default'  => '&copy; Copyright Greenova ' . date('Y') . '. Designed and Developed by <a target="_blank" rel="nofollow" href="' . GREENOVA_AUTHOR_URI . '">RadiusTheme</a>',
            'required' => array( 'copyright_area', 'equals', true )
        ),
    )
) );

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Typography', 'greenova' ),
    'id'               => 'typo_section',
    'icon'             => 'el el-text-width',
    'fields' => array(
        array(
            'id'       => 'typo_visibility',
            'type'     => 'switch',
            'title'    => esc_html__( 'Custom Typography', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => false,
        ),
        array(
            'id'       => 'typo_body',
            'type'     => 'typography',
            'title'    => esc_html__( 'Body', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '400',
                'line-height' => '28px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
        array(
            'id'       => 'typo_h1',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h1', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '38px',
                'font-weight' => '700',
                'line-height' => '42px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
        array(
            'id'       => 'typo_h2',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h2', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '30px',
                'font-weight' => '700',
                'line-height' => '36px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
        array(
            'id'       => 'typo_h3',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h3', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '24px',
                'font-weight' => '600',
                'line-height' => '32px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
        array(
            'id'       => 'typo_h4',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h4', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '22px',
                'font-weight' => '600',
                'line-height' => '30px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
        array(
            'id'       => 'typo_h5',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h5', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '18px',
                'font-weight' => '500',
                'line-height' => '28px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
        array(
            'id'       => 'typo_h6',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h6', 'greenova' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '400',
                'line-height' => '20px',
            ),
            'required' => array( 'typo_visibility', 'equals', true )
        ),
    )            
) );

// Generate Common post type fields
function greenova_redux_post_type_fields( $prefix ){
    return array(
        array(
            'id'       => $prefix. '_layout',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Layout', 'greenova' ),
            'options'  => array(
                'left-sidebar'  => esc_html__( 'Left Sidebar', 'greenova' ),
                'full-width'    => esc_html__( 'Full Width', 'greenova' ),
                'right-sidebar' => esc_html__( 'Right Sidebar', 'greenova' ),
            ),
            'default' => 'right-sidebar'
        ),
        array(
            'id'       => $prefix. '_padding_top',
            'type'     => 'text',
            'title'    => esc_html__( 'Content Padding Top', 'greenova' ),
            'validate'  => 'numeric',
            'default' => '100',
        ),
        array(
            'id'       => $prefix. '_padding_bottom',
            'type'     => 'text',
            'title'    => esc_html__( 'Content Padding Bottom', 'greenova' ),
            'validate'  => 'numeric',
            'default' => '100'
        ),
        array(
            'id'       => $prefix. '_banner',
            'type'     => 'switch',
            'title'    => esc_html__( 'Banner', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => $prefix. '_breadcrumb',
            'type'     => 'switch',
            'title'    => esc_html__( 'Breadcrumb', 'greenova' ),
            'on'       => esc_html__( 'Enabled', 'greenova' ),
            'off'      => esc_html__( 'Disabled', 'greenova' ),
            'default'  => true,
            'required' => array( $prefix. '_banner', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_bgtype',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Banner Background Type', 'greenova' ),
            'options'  => array(
                'bgimg'    => esc_html__( 'Background Image', 'greenova' ),
                'bgcolor'  => esc_html__( 'Background Color', 'greenova' ),
            ),
            'default' => 'bgimg',
            'required' => array( $prefix. '_banner', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_bgimg',
            'type'     => 'media',
            'title'    => esc_html__( 'Banner Background Image', 'greenova' ),
            'default'  => array(
                'url'=> GREENOVA_IMG_URL . 'banner.jpg'
            ),
            'required' => array( $prefix. '_bgtype', 'equals', 'bgimg' )
        ),
        array(
            'id'       => $prefix. '_bgcolor',
            'type'     => 'color',
            'title'    => esc_html__('Banner Background Color', 'greenova'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#606060',
            'required' => array( $prefix. '_bgtype', 'equals', 'bgcolor' )
        ),
    );
}

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Layout Defaults', 'greenova' ),
    'id'               => 'layout_defaults',
    'icon'             => 'el el-th',
    ) );

// Page
$greenova_page_fields = greenova_redux_post_type_fields( 'page' );
$greenova_page_fields[0]['default'] = 'full-width';
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Page', 'greenova' ),
    'id'               => 'pages_section',
    'subsection' => true,
    'fields' => $greenova_page_fields
    ) );

//Post Archive
$greenova_post_archive_fields = greenova_redux_post_type_fields( 'blog' );
Redux::setSection( $opt_name, array(
    'title'      => esc_html__( 'Blog / Archive', 'greenova' ),
    'id'         => 'blog_section',
    'subsection' => true,
    'fields' 	 => $greenova_post_archive_fields
    ) );

// Single Post
$greenova_single_post_fields = greenova_redux_post_type_fields( 'single_post' );
Redux::setSection( $opt_name, array(
    'title'      => esc_html__( 'Post Single', 'greenova' ),
    'id'         => 'single_post_section',
    'subsection' => true,
    'fields' 	 => $greenova_single_post_fields           
    ) );

// Service Single

$service_fields = greenova_redux_post_type_fields( 'service' );
$service_fields[0]['default'] = 'left-sidebar';
Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'Service Single', 'greenova' ),
		'id'         => 'service_section',
		'subsection' => true,
		'fields' 	 => $service_fields
	)
);

// Project Single

$project_fields = greenova_redux_post_type_fields( 'project' );
$project_fields[0]['default'] = 'full-width';
Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'Project Single', 'greenova' ),
		'id'         => 'project_section',
		'subsection' => true,
		'fields' 	 => $project_fields
	)
);

// Team Single
$team_fields = greenova_redux_post_type_fields( 'team' );
unset($team_fields[0]);
Redux::setSection( $opt_name, array(
		'title'      => esc_html__( 'Team Single', 'greenova' ),
		'id'         => 'team_section',
		'subsection' => true,
		'fields' 	 => $team_fields
	)
);

// Search
$greenova_search_fields = greenova_redux_post_type_fields( 'search' );
Redux::setSection( $opt_name, array(
    'title'      => esc_html__( 'Search Layout', 'greenova' ),
    'id'         => 'search_section',
    'heading'    => '',
    'subsection' => true,
    'fields' 	 => $greenova_search_fields            
) 
);

// Error 404 Layout
$greenova_error_fields = greenova_redux_post_type_fields( 'error' );
unset($greenova_error_fields[0]);
$greenova_error_fields[2]['default'] = 'full-width';
$greenova_error_fields[2]['default'] = '120';
$greenova_error_fields[3]['default'] = '120';
Redux::setSection( $opt_name, array(
    'title'   	 => esc_html__( 'Error 404 Layout', 'greenova' ),
    'id'      	 => 'error_section',
    'heading' 	 => '',
    'subsection' => true,
    'fields'  	 => $greenova_error_fields           
) 
);

if ( class_exists( 'WooCommerce' ) ) {
    // Woocommerce Shop Archive
    $greenova_shop_archive_fields = greenova_redux_post_type_fields( 'shop' );
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Shop Archive', 'greenova' ),
        'id'         => 'shop_section',
        'subsection' => true,
        'fields' 	 => $greenova_shop_archive_fields
        ) );

    // Woocommerce Product
    $greenova_product_fields = greenova_redux_post_type_fields( 'product' );
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Product Single', 'greenova' ),
        'id'         => 'product_section',
        'subsection' => true,
        'fields' 	 => $greenova_product_fields
        ) );
}

// Blog Settings
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Blog Settings', 'greenova' ),
    'id'               => 'blog_settings_section',
    'icon'             => 'el el-tags',
    'heading'          => '',
    'fields' => array(
        array(
            'id'       =>'blog_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Blog/Archive Layout', 'greenova' ),
            'default'  => 'style2',
            'options' => array(
                'style2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'blog2.png',
                ),
                'style1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'greenova' ) . '</b>',
                    'img' => GREENOVA_IMG_URL . 'blog1.png',
                ),
            ),
        ),
        array(
            'id'       => 'blog_date',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Date', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'blog_author_name',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Name', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => 'blog_comment_num',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Comment Number', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
			'on'       => esc_html__( 'On', 'greenova' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'blog_cats',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Categories', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
            'required' => array( 'blog_style', 'equals', 'style1' )
        ),
    )            
) 
);

// Post Settings
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Post Settings', 'greenova' ),
    'id'               => 'post_settings_section',
    'icon'             => 'el el-file-edit',
    'heading'          => '',
    'fields' => array(
        array(
            'id'       => 'post_author_name',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Name', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_date',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Post Date', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'post_comment_num',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Comment Number', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'post_cats',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Categories', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ),
		array(
           'id'       => 'post_social',
           'type'     => 'switch',
           'title'    => esc_html__( 'Show Social Shares', 'greenova' ),
		   'off'      => esc_html__( 'Off', 'greenova' ),
           'on'       => esc_html__( 'On', 'greenova' ),
           'default'  => true,
       ),
        array(
            'id'       => 'post_tags',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Tags', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ),		 
        array(
            'id'       => 'post_author_bio',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Bio', 'greenova' ),
            'on'       => esc_html__( 'On', 'greenova' ),
            'off'      => esc_html__( 'Off', 'greenova' ),
            'default'  => true,
        ),
    )
) 
);

// Error
$greenova_fields2 = array( 
    array(
        'id'       => 'error_title',
        'type'     => 'text',
        'title'    => esc_html__( 'Page Title', 'greenova' ),
        'default'  => esc_html__( 'Error 404', 'greenova' ),
    ), 
    array(
        'id'       => 'error_bodybg',
        'type'     => 'color',
        'transparent' => false,
        'title'    => esc_html__( 'Body Background Color', 'greenova' ),
        'default'  => '#f8f8f8',
    ), 
    array(
        'id'       => 'error_bodybanner',
        'type'     => 'media',
        'title'    => esc_html__( 'Body Banner', 'greenova' ),
        'default'  => array(
            'url'=> GREENOVA_IMG_URL . '404.png'
        ),
    ), 
    array(
        'id'       => 'error_text1',
        'type'     => 'text',
        'title'    => esc_html__( 'Body Text 1', 'greenova' ),
        'default'  => esc_html__( 'Sorry, Page Not Found', 'greenova' ),
    ),
    array(
        'id'       => 'error_text1_color',
        'type'     => 'color',
        'transparent' => false,
        'title'    => esc_html__( 'Body Text 1 Color', 'greenova' ),
        'default'  => '#ffffff',
    ),
    array(
        'id'       => 'error_text2',
        'type'     => 'text',
        'title'    => esc_html__( 'Body Text 2', 'greenova' ),
        'default'  => esc_html__( 'The page your are looking for is not available or has been removed. Try going to Home Page by using the buton below', 'greenova' ),
    ),
	array(
        'id'       => 'error_text2_color',
        'type'     => 'color',
        'transparent' => false,
        'title'    => esc_html__( 'Body Text 2 Color', 'greenova' ),
        'default'  => '#444444',
    ),
    array(
        'id'       => 'error_buttontext',
        'type'     => 'text',
        'title'    => esc_html__( 'Button Text', 'greenova' ),
        'default'  => esc_html__( 'Go Home', 'greenova' ),
    )
);
Redux::setSection( $opt_name, array(
    'title'   => esc_html__( 'Error Page Settings', 'greenova' ),
    'id'      => 'error_srttings_section',
    'heading' => '',
    'icon'    => 'el el-error-alt',
    'fields'  => $greenova_fields2           
) 
);

do_action('rt_after_redux_options_loaded','greenova');

if ( class_exists( 'WooCommerce' ) ) {
    // Woocommerce Settings
    Redux::setSection( $opt_name, array(
        'title'   => esc_html__( 'WooCommerce', 'greenova' ),
        'id'      => 'woo_Settings_section',
        'heading' => '',
        'icon'    => 'el el-shopping-cart',
        'fields'  => array(
            array(
                'id'       => 'wc_sec_general',
                'type'     => 'section',
                'title'    => esc_html__( 'General', 'greenova' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_num_product',
                'type'     => 'text',
                'title'    => esc_html__( 'Number of Products Per Page', 'greenova' ),
                'default'  => '9',
            ),
            array(
                'id'       => 'wc_product_hover',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Hover Effect', 'greenova' ),
                'on'       => esc_html__( 'Enabled', 'greenova' ),
                'off'      => esc_html__( 'Disabled', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_wishlist_icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Add to Wishlist Icon', 'greenova' ),
                'on'       => esc_html__( 'Enabled', 'greenova' ),
                'off'      => esc_html__( 'Disabled', 'greenova' ),
                'default'  => true,
                'required' => array( 'wc_product_hover', 'equals', true )
            ),
            array(
                'id'       => 'wc_quickview_icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Quickview Icon', 'greenova' ),
                'on'       => esc_html__( 'Enabled', 'greenova' ),
                'off'      => esc_html__( 'Disabled', 'greenova' ),
                'default'  => true,
                'required' => array( 'wc_product_hover', 'equals', true )
            ),
            array(
                'id'       => 'wc_sec_product',
                'type'     => 'section',
                'title'    => esc_html__( 'Product Single Page', 'greenova' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_show_excerpt',
                'type'     => 'switch',
                'title'    => esc_html__( "Show excerpt when short description doesn't exist", 'greenova' ),
                'on'       => esc_html__( 'Enabled', 'greenova' ),
                'off'      => esc_html__( 'Disabled', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_cats',
                'type'     => 'switch',
                'title'    => esc_html__( 'Categories', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_tags',
                'type'     => 'switch',
                'title'    => esc_html__( 'Tags', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Products', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_related_products',
                'type'     => 'slider',
                'title'    => esc_html__( 'Number of related product', 'greenova' ),
                'default'  => 4,
                'min'      => 1,
                'max'      => 15,
                'required' => array( 'wc_related', '=', true )
            ),
            array(
                'id'       => 'wc_description',
                'type'     => 'switch',
                'title'    => esc_html__( 'Description Tab', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_reviews',
                'type'     => 'switch',
                'title'    => esc_html__( 'Reviews Tab', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_additional_info',
                'type'     => 'switch',
                'title'    => esc_html__( 'Additional Information Tab', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_sec_cart',
                'type'     => 'section',
                'title'    => esc_html__( 'Cart Page', 'greenova' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_cross_sell',
                'type'     => 'switch',
                'title'    => esc_html__( 'Cross Sell Products', 'greenova' ),
                'on'       => esc_html__( 'Show', 'greenova' ),
                'off'      => esc_html__( 'Hide', 'greenova' ),
                'default'  => true,
            ),
        )
	) 
);
}

// -> END Fields


// If Redux is running as a plugin, this will remove the demo notice and links
add_action( 'redux/loaded', 'greenova_remove_demo' );
/**
 * Removes the demo link and the notice of integrated demo from the redux-framework plugin
 */
function greenovaredux_remove_extra_meta( $links, $file ){
    if ( strpos( $file, 'redux-framework.php' ) !== false ) {
        $links = array_slice( $links, 0, 3 );
    }

    return $links;
}

if ( ! function_exists( 'greenova_remove_demo' ) ) {
    function greenova_remove_demo() {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            add_filter( 'plugin_row_meta', 'greenovaredux_remove_extra_meta', 12, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }
}