<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_action( 'wp_enqueue_scripts', 'greenova_register_scripts', 12 );
if ( ! function_exists( 'greenova_register_scripts' ) ) {
	function greenova_register_scripts() {
		/*CSS*/
		// owl.carousel CSS
		wp_register_style( 'owl-carousel', GREENOVA_CSS_URL . 'owl.carousel.min.css', [], GREENOVA_VERSION );
		wp_register_style( 'owl-theme-default', GREENOVA_CSS_URL . 'owl.theme.default.min.css', [], GREENOVA_VERSION );

		wp_register_style( 'magnific-popup', GREENOVA_CSS_URL . 'magnific-popup.css', [], GREENOVA_VERSION );

		/*JS*/
		// owl.carousel.min js
		wp_register_script( 'owl-carousel', GREENOVA_JS_URL . 'owl.carousel.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		// counter js
		wp_register_script( 'rt-waypoints', GREENOVA_JS_URL . 'waypoints.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		wp_register_script( 'counterup', GREENOVA_JS_URL . 'jquery.counterup.min.js', [ 'jquery' ], GREENOVA_VERSION, true );

		// magnific popup
		wp_register_script( 'magnific-popup', GREENOVA_JS_URL . 'jquery.magnific-popup.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		wp_register_script( 'isotope-pkgd', GREENOVA_JS_URL . 'isotope.pkgd.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		//Masonary

	}
}

// Dequeue and Deregister Script
add_action( 'wp_enqueue_scripts', 'rt_dequeue_styles', 14 );
if ( ! function_exists( 'rt_dequeue_styles' ) ) {
	function rt_dequeue_styles() {
		// FontAwesome
		wp_dequeue_style( 'yith-wcwl-font-awesome' );
		wp_dequeue_style( 'font-awesome' );
		wp_deregister_style( 'yith-wcwl-font-awesome' );
		wp_deregister_style( 'font-awesome' );
	}
}

add_action( 'wp_enqueue_scripts', 'greenova_enqueue_scripts', 15 );

if ( ! function_exists( 'greenova_enqueue_scripts' ) ) {
	function greenova_enqueue_scripts() {
		/*CSS*/
		// Google fonts

		if ( isset(GREENOVA_Theme::$options['typo_visibility']) && ! GREENOVA_Theme::$options['typo_visibility'] ) {
		    wp_enqueue_style( 'greenova-gfonts', GREENOVA_Theme_Helper::fonts_url(), [], GREENOVA_VERSION );
		}
		// Bootstrap CSS
		wp_enqueue_style( 'bootstrap', GREENOVA_Theme_Helper::maybe_rtl( 'bootstrap.min.css' ), [], GREENOVA_VERSION );
		// font-awesome CSS

		//wp_enqueue_style( 'font-awesome', GREENOVA_CSS_URL . 'font-awesome.min.css', [], GREENOVA_VERSION );
		wp_enqueue_style( 'font-awesome-all', GREENOVA_CSS_URL . 'fontawesome-all.min.css', [], GREENOVA_VERSION );

		// Select 2 CSS
		wp_enqueue_style( 'select2', GREENOVA_CSS_URL . 'select2.min.css', [], GREENOVA_VERSION );

		//Flaticon
		wp_register_style( 'flaticon', GREENOVA_CSS_URL . 'flaticon', [], time() );

		// main CSS		
		wp_enqueue_style( 'greenova-default', GREENOVA_Theme_Helper::maybe_rtl( 'default.css' ), [], GREENOVA_VERSION );
		// vc modules css  
		wp_enqueue_style( 'greenova-vc', GREENOVA_Theme_Helper::maybe_rtl( 'vc.css' ), [], GREENOVA_VERSION );
		// Style CSS       
		wp_enqueue_style( 'greenova-style', GREENOVA_Theme_Helper::maybe_rtl( 'style.css' ), [], GREENOVA_VERSION );

		if ( is_rtl() ) {
			// Theme RTL CSS
			wp_enqueue_style( 'theme-rtl', GREENOVA_CSS_URL . 'rtl.css', [], GREENOVA_VERSION );
		}

		// Template Style
		wp_add_inline_style( 'greenova-style', greenova_template_style() );

		/*JS*/
		// bootstrap js
		wp_enqueue_script( 'bootstrap', GREENOVA_JS_URL . 'bootstrap.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		// Select2 js
		wp_enqueue_script( 'select2', GREENOVA_JS_URL . 'select2.min.js', [ 'jquery' ], GREENOVA_VERSION, true );

		// Nav smooth scroll
		//wp_enqueue_script( 'jquery-nav', GREENOVA_JS_URL . 'jquery.nav.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		wp_enqueue_script( 'navpoints', GREENOVA_JS_URL . 'jquery.navpoints.js', [ 'jquery' ], GREENOVA_VERSION, true );
		// Countdown
		wp_enqueue_script( 'js-countdown', GREENOVA_JS_URL . 'jquery.countdown.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		// Cookie js
		wp_enqueue_script( 'js-cookie', GREENOVA_JS_URL . 'js.cookie.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		// isotope
		wp_enqueue_script( 'isotope-pkgd', GREENOVA_JS_URL . 'isotope.pkgd.min.js', [ 'jquery' ], GREENOVA_VERSION, true );

		// wp_register_script( 'swiper', GREENOVA_JS_URL . 'swiper.min.js', [ 'jquery' ], GREENOVA_VERSION, true );
		// wp_enqueue_script( 'swiper' );

		wp_enqueue_script( 'masonry' );
		wp_enqueue_script( 'greenova-main', GREENOVA_JS_URL . 'main.js', [ 'jquery' ], GREENOVA_VERSION, true );

		if ( ! empty( GREENOVA_Theme::$options['logo']['url'] ) ) {
			$logo = '<img class="logo-small" src="' . esc_url( empty( GREENOVA_Theme::$options['logo']['url'] ) ? GREENOVA_IMG_URL . 'logo.png'
					: GREENOVA_Theme::$options['logo']['url'] ) . '" />';
		} else {
			$logo = esc_attr( get_bloginfo( 'title' ) );
		}

		$html = '';

		if ( GREENOVA_Theme::$options['phone'] ) {
			$html .= '<span class="mob-info phone"><a class="button-btn" target="_self" href="tel:' . esc_url( GREENOVA_Theme::$options['phone'] ) . '">'
			         . '<i class="far fa-phone" aria-hidden="true"></i>' . '</a></span>';
		}

		if ( GREENOVA_Theme::$options['email'] ) {
			$html .= '<span class="mob-info mail"><a class="button-btn" target="_self" href="mailto:' . esc_url( GREENOVA_Theme::$options['email'] ) . '">'
			         . '<i class="far fa-envelope" aria-hidden="true"></i>' . '</a></span>';
		}

		//Logo dimensions
		$dark_logo_width  = isset( GREENOVA_Theme::$options['logo']['width'] ) ? GREENOVA_Theme::$options['logo']['width'] : '';
		$dark_logo_height = isset( GREENOVA_Theme::$options['logo']['height'] ) ? GREENOVA_Theme::$options['logo']['width'] : '';

		$dark_logo_dimensions = ( ! empty( $dark_logo_width ) && ! empty( $dark_logo_height ) ) ? 'width="' . $dark_logo_width . '" height="' . $dark_logo_height . '"'
			: 'width="211" height="58"';

		// localize script
		$greenova_localize_data = [
			'ajaxurl'           => admin_url( 'admin-ajax.php' ),
			'stickyMenu'        => GREENOVA_Theme::$options['sticky_menu'],
			'meanWidth'         => GREENOVA_Theme::$options['resmenu_width'],
			'siteLogo'          => '<a href="' . esc_url( home_url( '/' ) ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '">
			<img ' . $dark_logo_dimensions . ' class="logo-small" src="' . esc_url( empty( GREENOVA_Theme::$options['logo']['url'] ) ? GREENOVA_IMG_URL . 'logo.png'
					: GREENOVA_Theme::$options['logo']['url'] )
			                       . '" /></a>' . $html,
			'day'               => esc_html__( 'Day', 'greenova' ),
			'hour'              => esc_html__( 'Hour', 'greenova' ),
			'minute'            => esc_html__( 'Minute', 'greenova' ),
			'second'            => esc_html__( 'Second', 'greenova' ),
			'extraOffset'       => GREENOVA_Theme::$options['sticky_menu'] ? 70 : 0,
			'extraOffsetMobile' => GREENOVA_Theme::$options['sticky_menu'] ? 52 : 0,
			'wishlist_nonce'    => wp_create_nonce( 'add_to_wishlist' ),
			'rtl'               => is_rtl() ? 'yes' : 'no', //@rtl
		];
		wp_localize_script( 'greenova-main', 'ThemeObj', $greenova_localize_data );
	}
}


add_action( 'wp_enqueue_scripts', 'greenova_high_priority_scripts', 1500 );
if ( ! function_exists( 'greenova_high_priority_scripts' ) ) {
	function greenova_high_priority_scripts() {
		// Dynamic style
		if ( apply_filters( 'greenova_force_internnal_dynamic_style', false ) ) {
			GREENOVA_Theme_Helper::dynamic_internal_style();

			return;
		}

		$file = GREENOVA_CSS_DIR . 'generated-style.css';
		if ( wp_is_writable( $file ) && ! is_customize_preview() ) {
			wp_enqueue_style( 'generated-style', GREENOVA_CSS_URL . 'generated-style.css', [], GREENOVA_VERSION );
		} else {
			GREENOVA_Theme_Helper::dynamic_internal_style();
		}
	}
}

// Admin Scripts
add_action( 'admin_enqueue_scripts', 'greenova_admin_scripts', 12 );
function greenova_admin_scripts() {
	wp_enqueue_style( 'greenova-admin', GREENOVA_CSS_URL . 'admin.css', [], GREENOVA_VERSION );
}

function greenova_template_style() {
	ob_start();
	?>
    .entry-banner {
	<?php if ( GREENOVA_Theme::$bgtype == 'bgcolor' ): ?>
        background-color: <?php echo esc_html( GREENOVA_Theme::$bgcolor ); ?>;
	<?php else: ?>
        background: url(<?php echo esc_url( GREENOVA_Theme::$bgimg ); ?>) no-repeat scroll center center / cover;
	<?php endif; ?>
    }
    .content-area {
    padding-top: <?php echo esc_html( GREENOVA_Theme::$padding_top ); ?>px;
    padding-bottom: <?php echo esc_html( GREENOVA_Theme::$padding_bottom ); ?>px;
    }
	<?php
	return ob_get_clean();
}

// for gutenberg support
function load_custom_wp_admin_script_1() {
	wp_enqueue_style( 'greenova-gfonts', GREENOVA_Theme_Helper::fonts_url(), [], GREENOVA_VERSION );
	wp_enqueue_style( 'font-awesome', GREENOVA_CSS_URL . 'font-awesome.min.css', [], GREENOVA_VERSION );
}

add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_script_1', 1 );

function load_custom_wp_admin_script() {
	if ( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
		return;
	}
	wp_register_style( 'greenova-admin-css', ZUGAN_CSS_URL . 'admin-style.css', false, GREENOVA_VERSION, true );
	wp_enqueue_style( 'greenova-admin-css' );
}

add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_script', 20 );