<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_action( 'template_redirect', 'rdtheme_template_vars' );
if( !function_exists( 'rdtheme_template_vars' ) ) {
    function rdtheme_template_vars() {
        // Single Pages
        if( is_single() || is_page() ) {
            $post_type = get_post_type();
            $post_id   = get_the_id();
            switch( $post_type ) {
                case 'page':
                $prefix = 'page';
                break;
                case 'post':
                $prefix = 'single_post';
                break;
                case 'greenova_service':
                $prefix = 'service';
                break;
                case 'greenova_project':
                $prefix = 'project';
                break;
                case 'greenova_team':
                $prefix = 'team';
				GREENOVA_Theme::$options[$prefix. '_layout'] = 'full-width';
                break;				
                case 'product':
                $prefix = 'product';
                break;
                default:
                $prefix = 'single_post';
                break;
            }
            
            $layout         = get_post_meta( $post_id, 'greenova_layout', true );
            $tr_header      = get_post_meta( $post_id, 'greenova_tr_header', true );
            $top_bar        = get_post_meta( $post_id, 'greenova_top_bar', true );
            $top_bar_style  = get_post_meta( $post_id, 'greenova_top_bar_style', true );
            $header_style   = get_post_meta( $post_id, 'greenova_header', true );
            $padding_top    = get_post_meta( $post_id, 'greenova_top_padding', true );
            $padding_bottom = get_post_meta( $post_id, 'greenova_bottom_padding', true );
            $has_banner     = get_post_meta( $post_id, 'greenova_banner', true );
            $has_breadcrumb = get_post_meta( $post_id, 'greenova_breadcrumb', true );
            $bgtype         = get_post_meta( $post_id, 'greenova_banner_type', true );
            $bgcolor        = get_post_meta( $post_id, 'greenova_banner_bgcolor', true );
            $bgimg          = get_post_meta( $post_id, 'greenova_banner_bgimg', true );
            
            GREENOVA_Theme::$layout = ( empty( $layout ) || $layout == 'default' ) ? GREENOVA_Theme::$options[$prefix . '_layout'] : $layout;

            GREENOVA_Theme::$tr_header = ( empty( $tr_header ) || $tr_header == 'default' ) ? GREENOVA_Theme::$options['tr_header'] : $tr_header;
            
            GREENOVA_Theme::$top_bar = ( empty( $top_bar ) || $top_bar == 'default' ) ? GREENOVA_Theme::$options['top_bar'] : $top_bar;
            
            GREENOVA_Theme::$top_bar_style = ( empty( $top_bar_style ) || $top_bar_style == 'default' ) ? GREENOVA_Theme::$options['top_bar_style'] : $top_bar_style;
            
            GREENOVA_Theme::$header_style = ( empty( $header_style ) || $header_style == 'default' ) ? GREENOVA_Theme::$options['header_style'] : $header_style;
            
            $padding_top = ( empty( $padding_top ) || $padding_top == 'default' ) ? GREENOVA_Theme::$options[$prefix . '_padding_top'] : $padding_top;
            GREENOVA_Theme::$padding_top = (int) $padding_top;
            
            $padding_bottom = ( empty( $padding_bottom ) || $padding_bottom == 'default' ) ? GREENOVA_Theme::$options[$prefix . '_padding_bottom'] : $padding_bottom;
            GREENOVA_Theme::$padding_bottom = (int) $padding_bottom;
            
            GREENOVA_Theme::$has_banner = ( empty( $has_banner ) || $has_banner == 'default' ) ? GREENOVA_Theme::$options[$prefix . '_banner'] : $has_banner;
            
            GREENOVA_Theme::$has_breadcrumb = ( empty( $has_breadcrumb ) || $has_breadcrumb == 'default' ) ? GREENOVA_Theme::$options[$prefix . '_breadcrumb'] : $has_breadcrumb;
            
            GREENOVA_Theme::$bgtype = ( empty( $bgtype ) || $bgtype == 'default' ) ? GREENOVA_Theme::$options[$prefix . '_bgtype'] : $bgtype;
            
            GREENOVA_Theme::$bgcolor = empty( $bgcolor ) ? GREENOVA_Theme::$options[$prefix . '_bgcolor'] : $bgcolor;
            
            if( !empty( $bgimg ) ) {
                $attch_url      = wp_get_attachment_image_src( $bgimg, 'rdtheme-size1', true );
                GREENOVA_Theme::$bgimg = $attch_url[0];
            } elseif( !empty( GREENOVA_Theme::$options[$prefix . '_bgimg']['id'] ) ) {
                $attch_url      = wp_get_attachment_image_src( GREENOVA_Theme::$options[$prefix . '_bgimg']['id'], 'rdtheme-size1', true );
                GREENOVA_Theme::$bgimg = $attch_url[0];
            } else {
                GREENOVA_Theme::$bgimg = GREENOVA_IMG_URL . 'banner.jpg';
            }
        }
        
        // Blog and Archive
        elseif( is_home() || is_archive() || is_search() || is_404() ) {
            if( is_search() ) {
                $prefix = 'search';
            } elseif( is_404() ) {
                $prefix                                = 'error';
                GREENOVA_Theme::$options[$prefix . '_layout'] = 'full-width';
            } elseif( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
                $prefix = 'shop';
            } else {
                $prefix = 'blog';
            }
            
            GREENOVA_Theme::$layout         = GREENOVA_Theme::$options[$prefix . '_layout'];
            GREENOVA_Theme::$tr_header      = GREENOVA_Theme::$options['tr_header'];
            GREENOVA_Theme::$top_bar        = GREENOVA_Theme::$options['top_bar'];
            GREENOVA_Theme::$top_bar_style  = GREENOVA_Theme::$options['top_bar_style'];
            GREENOVA_Theme::$header_style   = GREENOVA_Theme::$options['header_style'];
            GREENOVA_Theme::$padding_top    = GREENOVA_Theme::$options[$prefix . '_padding_top'];
            GREENOVA_Theme::$padding_bottom = GREENOVA_Theme::$options[$prefix . '_padding_bottom'];
            GREENOVA_Theme::$has_banner     = GREENOVA_Theme::$options[$prefix . '_banner'];
            GREENOVA_Theme::$has_breadcrumb = GREENOVA_Theme::$options[$prefix . '_breadcrumb'];
            GREENOVA_Theme::$bgtype         = GREENOVA_Theme::$options[$prefix . '_bgtype'];
            GREENOVA_Theme::$bgcolor        = GREENOVA_Theme::$options[$prefix . '_bgcolor'];
			
            if( !empty( GREENOVA_Theme::$options[$prefix . '_bgimg']['id'] ) ) {
                $attch_url      = wp_get_attachment_image_src( GREENOVA_Theme::$options[$prefix . '_bgimg']['id'], 'rdtheme-size1', true );
                GREENOVA_Theme::$bgimg = $attch_url[0];
            } else {
                GREENOVA_Theme::$bgimg = GREENOVA_IMG_URL . 'banner.jpg';
            }
        }
    }
}

// Add body class
add_filter( 'body_class', 'rdtheme_body_classes' );
if( !function_exists( 'rdtheme_body_classes' ) ) {
    function rdtheme_body_classes( $classes ) {
        
        $classes[] = 'header-style-'. GREENOVA_Theme::$header_style;

        if ( GREENOVA_Theme::$top_bar == 1 || GREENOVA_Theme::$top_bar == 'on' ){
            $classes[] = 'has-topbar topbar-style-'. GREENOVA_Theme::$top_bar_style;
        }

        if ( GREENOVA_Theme::$tr_header == 1 || GREENOVA_Theme::$tr_header == 'on' ){
           $classes[] = 'trheader';
        }
        
        $classes[] = ( GREENOVA_Theme::$layout == 'full-width' ) ? 'no-sidebar' : 'has-sidebar';
		
		$classes[] = ( GREENOVA_Theme::$layout == 'left-sidebar' ) ? 'left-sidebar' : 'right-sidebar';
        
		if ( class_exists( 'WC_Widget_Cart' ) && is_shop()  ) { 
			
			if( isset( $_COOKIE["shopview"] ) && $_COOKIE["shopview"] == 'list' ) {
				$classes[] = 'product-list-view';
			} else {
				$classes[] = 'product-grid-view';
			}
		}
        
        return $classes;
    }
}