<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_action('tgmpa_register', 'greenova_register_required_plugins');
function greenova_register_required_plugins()
{
	$plugins = [
		// Bundled
		[
			'name'         => 'Greenova Core',
			'slug'         => 'greenova-core',
			'source'       => 'greenova-core.zip',
			'required'     => true,
			'external_url' => 'http://radiustheme.com',
			'version'      => '2.2.2',
		],
		[
			'name'         => 'RT Framework',
			'slug'         => 'rt-framework',
			'source'       => 'rt-framework.zip',
			'required'     => true,
			'external_url' => 'http://radiustheme.com',
			'version'      => '2.5',
		],
		[
			'name'         => 'RT Demo Importer',
			'slug'         => 'rt-demo-importer',
			'source'       => 'rt-demo-importer.zip',
			'required'     => true,
			'external_url' => 'http://radiustheme.com',
			'version'      => '6.0.0',
		],
		[
			'name'         => 'WPBakery Page Builder',
			'slug'         => 'js_composer',
			'source'       => 'js_composer.zip',
			'required'     => true,
			'external_url' => 'http://vc.wpbakery.com',
			'version'      => '7.4',
		],
		[
			'name'         => 'LayerSlider WP',
			'slug'         => 'LayerSlider',
			'source'       => 'LayerSlider.zip',
			'required'     => false,
			'external_url' => 'https://layerslider.kreaturamedia.com',
			'version'      => '7.9.9',
		],
		[
			'name'         => 'WP Logo Showcase',
			'slug'         => 'wp-logo-showcase',
			'source'       => 'wp-logo-showcase.zip',
			'required'     => true,
			'external_url' => 'https://radiustheme.com/',
			'version'      => '2.6.3',
		],
		[
			'name'     => 'Review Schema Pro',
			'slug'     => 'review-schema-pro',
			'source'   => 'review-schema-pro.zip',
			'required' => false,
			'version'  => '1.1.6',
		],

		// Repository
		[
			'name'     => 'Redux Framework',
			'slug'     => 'redux-framework',
			'required' => true,
		],
		[
			'name'     => 'Elementor Website Builder',
			'slug'     => 'elementor',
			'required' => false,
		],
		[
			'name'     => 'Breadcrumb NavXT',
			'slug'     => 'breadcrumb-navxt',
			'required' => true,
		],
		[
			'name'     => 'Contact Form 7',
			'slug'     => 'contact-form-7',
			'required' => false,
		],
		[
			'name'     => 'MailChimp for WordPress',
			'slug'     => 'mailchimp-for-wp',
			'required' => false,
		],
		[
			'name'     => 'WP Retina 2x',
			'slug'     => 'wp-retina-2x',
			'required' => false,
		],
		[
			'name'     => 'WooCommerce',
			'slug'     => 'woocommerce',
			'required' => false,
		],
		[
			'name'     => 'ShopBuilder - Elementor WooCommerce Builder Addons',
			'slug'     => 'shopbuilder',
			'required' => false,
		],
		[
			'name'     => 'Review Schema Free',
			'slug'     => 'review-schema',
			'required' => false,
		],
	];

	$config = [
		'id'           => 'greenova',             // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => GREENOVA_PLUGINS_DIR,   // Default absolute path to bundled plugins.
		'menu'         => 'greenova-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	];

	tgmpa($plugins, $config);
}
