<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$primary_color   = GREENOVA_Theme::$options['primary_color']; // #1fa12e
$secondery_color = '#797979';
$primary_rgb     = GREENOVA_Theme_Helper::hex2rgb( $primary_color ); // 31, 161, 46
$secondary_rgb   = GREENOVA_Theme_Helper::hex2rgb( $secondery_color ); // 0, 33, 71

/*---------------------------------    
INDEX
===================================
#. VC: Button
#. VC: Section Title
#. VC: Owl Nav 1
#. VC: Owl Nav 2
#. VC: Owl Nav 3
#. VC: Owl Nav 4
#. VC: Testimonial Slider 1
#. VC: Testimonial Slider 2
#. VC: Team Slider
#. VC: About
#. VC: Opening Hour
#. VC: Text With Button
#. VC: Post
#. VC: Info Text
#. VC: Tab ( Restyling )
#. VC: Award Box
#. VC: CTA
#. VC: Law Grids
#. VC: Team Sliders
#. VC: Pricing Table 1
#. VC: Pricing Table 2
#. VC: Logo Showcase
#. VC: History Box
#. VC: Counter
#. VC: Service Grid
#. VC: Project
#. VC: WooCommerce Featured Product Isotope
#. VC: Others
----------------------------------*/
/*-----------------------
#. VC: Button
------------------------*/
?>
.entry-content .light-button ,
.entry-content .light-button i,
.entry-content .rt-text-with-btn a.light-box:hover {
	color: <?php echo esc_html($primary_color); ?> !important;
}
.entry-content .light-button:hover,
.entry-content .light-button:hover i {
	background: <?php echo esc_html($primary_color); ?> !important;
	color: #ffffff !important;
	border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.entry-content a.grid-fill-btn,
.entry-content .rt-grid-fill-btn a.grid-fill-btn,
.dark-button,
.slider-dark-button {
	border: 2px solid <?php echo esc_html($primary_color); ?>;
	background: <?php echo esc_html($primary_color); ?>;
}
.entry-content .rt-text-with-btn a.light-box {
    background: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-----------------------
#. VC: Section Title
------------------------*/
?>
.rt-vc-title-1 h2::after,
.rt-vc-title h2:after ,
.section-title h2:after {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-vc-title-5 .rt-section-sub-title-vc {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Owl Nav 1
---------------------------------------*/
?>
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-prev ,
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-next {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-prev:hover ,
.rt-owl-nav-1 .owl-carousel .owl-nav .owl-next:hover {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-1 .owl-carousel .owl-dots .owl-dot span:hover span ,
.rt-owl-nav-1 .owl-carousel .owl-dots .owl-dot.active span {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Owl Nav 2
---------------------------------------*/
?>
/*for both option control*/
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-prev ,
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-next {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-prev:hover ,
.rt-owl-nav-2.slider-nav-enabled .owl-carousel .owl-next:hover {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dot span:hover span ,
.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dot.active span {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Owl Nav 3
---------------------------------------*/
?>
.rt-owl-nav-3 .owl-custom-nav .owl-prev {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-3 .owl-custom-nav .owl-prev:hover ,
.rt-owl-nav-3 .owl-custom-nav .owl-next:hover {
  background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-3 .owl-custom-nav .owl-next {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-owl-nav-3.slider-dot-enabled .owl-carousel .owl-dot span:hover span ,
.rt-owl-nav-3.slider-dot-enabled .owl-carousel .owl-dot.active span {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-project-slider-one .sub-title {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-project-slider-one .rtin-projects-box .our-projects-content-holder span {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-project-slider-one .rtin-projects-box .our-projects-img-holder:before {
    background: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);	
}
.rt-project-slider-one .rtin-projects-box .our-projects-content-holder h3 a:hover,
.project-gallery1-area .sub-title {
	color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Testimonial Slider 1
---------------------------------------*/
?>
.rt-testimonial-slider-1 .rtin-single-client-area h3 a:hover ,
.rt-testimonial-slider-1 .rtin-single-client-area .picture ul li a i {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Testimonial Slider 2
---------------------------------------*/
?>
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:before ,
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:after {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Testimonial Slider 2
---------------------------------------*/
?>
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:before ,
.rt-testimonial-slider-2 .rtin-single-testimonial .rtin-testi-content:after {
  color: <?php echo esc_html($primary_color); ?>;
}
.client-inner-area-right.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dots > .active span {
    background: <?php echo esc_html($primary_color); ?>;
    border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.client-inner-area-right .client-box .media .image-holder img {
    border: 1px dashed <?php echo esc_html($primary_color); ?>;
}
.rt-testimonial-slider-6 .owl-item .tlp-tm-content-wrapper .item-content {
	background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-testimonial-slider-6 .ts-section-title::after,
.rt-testimonial-slider-7 .owl-item .tlp-tm-content-wrapper .item-content {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-testimonial-slider-6 .owl-item .tlp-tm-content-wrapper .item-content::after,
.rt-testimonial-slider-7 .owl-item .tlp-tm-content-wrapper .item-content:after {
  border-color: <?php echo esc_html($primary_color); ?> transparent transparent;
}
<?php
/*-------------------------------------
#. VC: Team Slider
---------------------------------------*/
?>
.rt-team-slider-one .section-title h2:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-one .rtin-single-team .rtin-item-content h3 a:hover ,
.rt-team-slider-one .rtin-single-team .rtin-item-content .position ,
.rt-team-slider-one .rtin-single-team .rtin-item-content ul.social-icons li a {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-one .rtin-single-team .rtin-item-content ul.social-icons li a:hover {
  background: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
/*team slider 2*/
.rt-team-slider-three .rtin-single-team .rtin-item-content .position ,
.rt-team-slider-four .rtin-single-team .rtin-item-content h3 a:hover ,
.rt-team-slider-five .rtin-team-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-three .rtin-single-team:hover ,
.rt-team-slider-two .rtin-single-team,
.rt-team-slider-eleven .rtin-team-social ul li a:hover {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-five .rtin-single-team .rtin-team-picture .overlay h2 a {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-five .rtin-single-team .rtin-team-picture .overlay h2 a:hover {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  background: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-team-slider-five .rtin-single-team .rtin-team-picture .overlay .social-media ul li a:hover {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-five .rtin-single-team .rtin-team-picture .overlay .social-media ul li a {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-six .rtin-single-team .rtin-team-picture .detail-button a:hover {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-13 .rtin-single-team .rtin-item-content .position,
.rt-team-slider-eleven .rtin-team-content h3 a:hover,
.rt-team-slider-eleven .rtin-single-team .rtin-team-picture .detail-button a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}

<?php
/*--------------------------------
#. VC: About
--------------------------------*/
?>
.rt-about-one .rtin-about-content h1 span ,
.rt-about-one .rtin-about-content ul li:before ,
.rt-about-one .rtin-about-content .read-more-button a:after {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-about-one .rtin-about-content .read-more-button a {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-about-one .rtin-about-content .read-more-button a:hover {
  background: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Post
---------------------------------------*/
?>
.rt-post-vc-section-1 .rtin-single-post .rtin-item-image span.date ,
.rt-post-vc-section-2 .rtin-single-post .rtin-item-image span.date ,
.rt-post-vc-section-3 .rt-post-slider-3 .entry-thumbnail-area .post-date ,
.rt-post-vc-section-3 .rt-post-slider-3 .entry-thumbnail-area ul .active {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-1 .rtin-single-post:hover .rtin-item-info h3 a ,
.rt-post-vc-section-2 .rtin-single-post:hover .rtin-item-info h3 a ,
.rt-post-vc-section-3 .rt-post-slider-3 .entry-thumbnail-area ul li i ,
.rt-post-vc-section-3 .rt-post-slider-3 .entry-thumbnail-area ul li a:hover ,
.rt-post-vc-section-3 .rt-post-slider-3 .entry-content h3 a:hover,
.rt-post-vc-section-1 .rtin-single-post .rtin-item-info i {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-4 .rtin-single-post:hover .rtin-item-info h3 a ,
.rt-post-vc-section-4 .rtin-single-post .rtin-item-info .rtin-post-date {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-5 .owl-custom-nav.owl-nav div {
    border: 1px solid <?php echo esc_html($primary_color); ?>;
}
/*style 7*/
.rt-post-vc-section-7 .rtin-single-post .rtin-item-image span.date,
.rt-post-vc-grid-3 .rtin-single-post .rtin-item-image .date {  
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-7 .rtin-single-post:hover .rtin-item-info h3 a,
.rt-post-vc-section-8 .rtin-single-post span.date i,
.rt-post-vc-section-8 .rtin-single-post .rtin-item-info .comments i,
.rt-post-vc-section-8 .rtin-single-post .rtin-item-info h3 a:hover,
.rt-post-vc-section-8 .rtin-single-post .by-author i,
.rt-post-vc-section-8 .rtin-single-post .by-author a:hover {
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-7 .rtin-single-post .rtin-item-info a.light-button {
	border: 2px solid <?php echo esc_html($primary_color); ?>;
	color: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-grid-2 .rtin-single-post i,
.rt-post-vc-grid-3 .rtin-single-post i,
.rt-post-vc-grid-1 .rtin-single-post .rtin-item-info .date,
.rt-post-vc-grid-2 .rtin-single-post .rtin-item-image .date,
.rt-post-vc-grid-2 .rtin-single-post .rtin-item-info h3 a:hover,
.rt-post-vc-grid-3 .rtin-single-post .rtin-item-info h3 a:hover {
	color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Info Text
---------------------------------------*/
?>
.rt-info-text-2 span {
  border-color: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text .info-ghost-button a {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text .info-ghost-button a:hover {
  background: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-info-text.layout1 i, 
.rt-info-text.layout2 i,
.rt-info-text.layout3 i {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text.layout4 i ,
.rt-infobox-5 .rtin-single-info .rtin-info-item-icon ,
.rt-infobox-6 .rtin-info-icon ,
.rt-infobox-6:hover .rtin-info-content h3 ,
.rt-infobox-6:hover .rtin-info-content h3 a,
.rt-info-text-6 .service-box > a,
.rt-infobox-7 .rtin-single-info-item .rtin-single-info:hover .rtin-info-content h3 a ,
.rt-infobox-8 .media .media-left i ,
.rt-infobox-9 .media .media-left i ,
.rt-infobox-10 h3 a:hover ,
.rt-infobox-10:hover h2 a,
.rt-info-text-8 .service-box > a,
.rt-info-text-10 .service-box .feature-list li:before {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-infobox-8 .media .media-body h3:after ,
.rt-infobox-10 .rtin-info-icon a ,
.rt-infobox-10 h3 a:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text-3 .service-box:hover .service-title,
.rt-info-text-8 .service-box {
  background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.estimate-holder {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-info-text-6 .service-box a.btn-dark,
.rt-info-text-9 .service-box a.btn-dark {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-----------------------
#. VC: Tab ( Restyling )
------------------------*/
?>
.wpb-js-composer .vc_tta-container .greenova-tab .vc_tta-tabs-container .vc_tta-tab.vc_active .vc_tta-title-text {
  color: <?php echo esc_html($primary_color); ?>;
}
.wpb-js-composer .vc_tta-style-classic.dark .vc_tta-panel .vc_tta-panel-heading {
	background: <?php echo esc_html($primary_color); ?> !important;
}
.wpb-js-composer .vc_tta-style-classic.service-inner .vc_tta-panel.vc_active .vc_tta-panel-title > a {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-----------------------
#. VC: CTA
------------------------*/
?>
.rt-cta-4 .emergrncy-content-holder-inner span i,
.rt-text-advertise h2 span,
.rt-cta-1 .rtin-cta-contact-button a:hover {
	color: <?php echo esc_html($primary_color); ?>;
}
.footer-topbar .emergrncy-content-holder,
.rt-cta-2 .rtin-cta-right:before ,
.rt-cta-2 .rtin-cta-right {	
  background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Law Grid 01
---------------------------------------*/
?>
.rt-service-layout-1 .rtin-single-item .rtin-item-content h3 a {
  color: <?php echo esc_html($secondery_color); ?>;
}
.rt-service-layout-1 .rtin-single-item:hover .rtin-item-content h3 a ,
.rt-law-grid .rtin-single-law .rtin-law-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-service-layout-1 .view-more-button a,
.rt-law-grid .view-more-button a ,
.rt-law-grid .rtin-single-law .rtin-law-image .overlay {
  background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Law Grid 03
---------------------------------------*/
?>
.rt-service-layout-3 .rtin-single-item .rtin-item-content h3:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-service-layout-3 .rtin-single-item .rtin-item-content a.greenova-button-7 {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-service-layout-3 .rtin-single-item .rtin-item-content a.greenova-button-7:hover {
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-service-layout-3 .rtin-single-item .rtin-item-content a.greenova-button-7 i,
.rt-service-layout-3 .rtin-single-item:hover .rtin-item-content h3 a {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Law Grid 05
---------------------------------------*/
?>
.rt-service-layout-5 .rtin-single-item .rtin-item-content {
	background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.btn-submit {
	background: <?php echo esc_html($primary_color); ?>;
}
.title-bar50:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-text-with-btn h3 span,
.rt-text-with-btn ul li:before {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-eight .rtin-team-box .team-img-holder:after {
	background: rgba(<?php echo esc_html($primary_rgb); ?>, 0.5);
}
.rt-team-slider-eight .rtin-team-box .team-content-holder p,
.rt-team-slider-eight .sub-title {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-eight .owl-custom-nav.owl-nav div {
	border-color: <?php echo esc_html($primary_color); ?> !important;
}
.client-inner-area-right.rt-owl-nav-2.slider-dot-enabled .owl-carousel .owl-dots > .active span {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-eight .rtin-team-box .team-social li:hover {
	background: <?php echo esc_html($primary_color); ?>;
}
.rt-post-vc-section-5 .sub-title,
.rt-team-slider-13 .rtin-single-team .rtin-item-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. VC: Team Sliders
---------------------------------------*/
?>
.rt-team-slider-one .section-title h2:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-one .rtin-single-team .rtin-item-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-one .rtin-single-team .rtin-item-content .position {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-one .rtin-single-team .rtin-item-content ul.social-icons li a {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-one .rtin-single-team .rtin-item-content ul.social-icons li a:hover {
  background: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
/*team slider 2*/
.rt-team-slider-two .rtin-single-team {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-two .rtin-single-team .rtin-item-content h3 a:hover {
  color: <?php echo esc_html($secondery_color); ?>;
}
.rt-team-grid-2 .rtin-single-team .rtin-item-content ul.social-icons li a {
  color: <?php echo esc_html($primary_color); ?>;
  border-color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-grid-2 .rtin-single-team .rtin-item-content ul.social-icons li a:hover {
  background: <?php echo esc_html($primary_color); ?>;
  border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.rt-team-grid-2 .rtin-single-team:hover .rtin-item-content h3 a {
  color: <?php echo esc_html($primary_color); ?>;
}
/*team slider 3*/
.rt-team-slider-three .rtin-single-team .rtin-item-content .position {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-three .rtin-single-team:hover {
  background: <?php echo esc_html($primary_color); ?>;
}
/*team slider 4*/
.rt-team-slider-four .rtin-single-team .rtin-item-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
/*team slider 5*/
.rt-team-slider-five .vc-item-wrap .vc-item .vc-overly {
  background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-team-slider-five .vc-item-wrap .vc-team-meta .name a {
  color: <?php echo esc_html($primary_color); ?>;
}
/*Team Slider 6*/
.rt-team-slider-six .rtin-team-slider-holder .tab-content .single-team .media-body h3.media-heading a:hover ,
.rt-team-slider-six .rtin-team-slider-holder .tab-content .single-team .media-body p.designation,
.rt-team-slider-six .rtin-team-social ul li a i {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-six .rtin-team-slider-holder .tab-content .single-team .media-body .social-media-area ul li a {
  color: <?php echo esc_html($primary_color); ?>;
  border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-six .rtin-team-social ul li a:hover i,
.rt-team-slider-six .rtin-team-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-six .rtin-team-content:after {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-13 .rtin-team-social ul li a:hover,
.rt-team-slider-six .rtin-team-content:after,
.rt-team-slider-six .rtin-team-slider-holder .tab-content .single-team .media-body .social-media-area ul li:hover a ,
.rt-team-slider-six .rtin-single-team .rtin-team-picture .overlay {
  background-color: <?php echo esc_html($primary_color); ?>;
}
/*Team Slider 7*/
.rt-team-slider-seven .single-team-area h3 .team-name {
  background: <?php echo esc_html($primary_color); ?>;
}
/*team slider 9*/
.rt-team-slider-ten .rtin-single-team .rtin-team-picture .tm-social ul li:hover a,
.wpb_wrapper .rt-team-slider-nine .team-box .team-social li:hover i,
.wpb_wrapper .rt-team-slider-twelve .rtin-team-social ul li a i,
.rt-team-slider-ten .rtin-team-content h3 a:hover,
.rt-team-slider-twelve .rtin-team-content h3 a:hover {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-twelve .rtin-single-team:hover .rtin-team-picture img,
.rt-team-slider-eleven .rtin-team-social ul li a {
	border-color: <?php echo esc_html($primary_color); ?>;
}
.rt-team-slider-ten .rtin-single-team .rtin-team-picture:after,
.rt-team-slider-eleven .rtin-single-team .rtin-team-picture .overlay {
  background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-team-grid-2 .rtin-single-team .rtin-item-image:after {
	background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-team-slider-13 .rtin-single-team .rtin-item-image a:after {
  background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
<?php
/*-------------------------------------
#. VC: Pricing Table 1
---------------------------------------*/
?>
.rt-price-table-box .rtin-price-button a.btn-price-button {
  color: <?php echo esc_html($primary_color); ?>;
}
.rt-price-table-box:hover .price-header,
.rt-price-table-box:hover .rtin-price-button a.btn-price-button,
.rt-price-table-box.active-class .rtin-price-button a.btn-price-button,
.active-class .price-header {
  background-color: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. VC: Pricing Table 2
---------------------------------------*/
?>
.entry-content .rt-price-table-box1 .price-holder {
  background: <?php echo esc_html($primary_color); ?>;
}
.rt-text-with-video .rtin-text-content h2::after ,
.entry-content .rt-price-table-box1 .pricetable-btn {
  background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*--------------------------------------
#. VC: Logo Showcase
---------------------------------------*/
?>
.rt-wpls .wpls-carousel .slick-prev, .rt-wpls .wpls-carousel .slick-next {
	background-color:<?php echo esc_html($primary_color); ?>;
}
.rt-vc-counter-2 .rtin-counter-content .rt-counter {
	border: 5px solid <?php echo esc_html($primary_color); ?>;
	color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*--------------------------------------
#. VC: History Box
---------------------------------------*/
?>
.rt-history-box .rtin-history-list li:before {
  background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*--------------------------------------
#. VC: Counter
---------------------------------------*/
?>
.rt-vc-counter-4 .awards-box a {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-counter-4 .awards-box a i {
	background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*--------------------------------------
#. VC: Service Grid
---------------------------------------*/
?>
.rt-service-grid-4 .rtin-single-post .rtin-item-image:after,
.rt-service-grid-5 .service-content-holder {
	background-color: rgba(<?php echo esc_html ( $primary_rgb ); ?>, 0.8);
}
.rt-service-grid-4 .rtin-single-post .rtin-item-image a.plus-icon:hover,
.rt-service-grid-4 .rtin-single-post:hover .rtin-item-info h3 a,
.rt-service-grid-3 .rtin-single-post:hover .rtin-item-info h3 a,
.rt-service-grid-3 .rtin-single-post .rtin-item-image a.plus-icon:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
.rt-service-grid-1 .service-box .service-img-holder:before,
.rt-service-grid-2 .service-box .service-img-holder:after,
.rt-service-grid-3 .service-box:after,
.rt-service-grid-3 .rtin-single-post .rtin-item-image:after {
  background-color: rgba(<?php echo esc_html ( $primary_rgb ); ?>, 0.8);
}
.rt-info-text-4.service3-box-right:hover .service3-content-holder h3 a {
	color: <?php echo esc_html( $primary_color );?> !important;
}
<?php
/*--------------------------------------
#. VC: Project
---------------------------------------*/
?>
.myisotop2 a:hover {
    background: <?php echo esc_html( $primary_color );?>;
}
.project5-box .project5-box-inner .project5-img-holder:after {
    background-color: rgba(<?php echo esc_html ( $primary_rgb ); ?>, 0.7);
}
.rtin-proj6-box-info-2:before {
    background-color: rgba(<?php echo esc_html ( $primary_rgb ); ?>, 0.9);
}
.project3-box .project3-box-inner .project3-box-content,
.tlp-portfolio .layout1 .tlp-portfolio-item .tlp-portfolio-thum .tlp-overlay,
.tlp-portfolio .isotope9 .tlp-portfolio-item .tlp-overlay {
    background-color: rgba(<?php echo esc_html ( $primary_rgb ); ?>, 0.8);
}
.rt-project-gallery-4 .project4-box:nth-child(odd) .project4-content,
.rt-project-gallery-4 .project4-box:nth-child(even) .project4-content {
    background-color: rgba(<?php echo esc_html ( $primary_rgb ); ?>, 0.9);
}
.project2-box .project2-box-inner .project2-social li a i,
.tlp-portfolio .layout1 .tlp-portfolio-item .tlp-content-holder h3 a:hover,
.project9-box .rt-portfolio-item a.grid9-btn:hover,
.project10-box-inner .rtin-proj10-box-info a.grid10-btn:hover,
.project11-box .project11-content h3 a:hover {
    color: <?php echo esc_html( $primary_color );?>;
}
.project11-box .project-button:before, 
.project11-box .project-button span a {
    color: <?php echo esc_html( $primary_color );?>;
}
.rt-portfolio-tab.isotop-classes-tab a.current,
.rt-portfolio-tab.isotop-classes-tab a:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.project9-box .rt-portfolio-item .rt-content,
.project10-box-inner .rtin-proj10-box-info {
	background-color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------------
#. VC: WooCommerce Featured Product Isotope
-------------------------------------------*/
?>
.rt-featured-product-isotope .featured-product-title h2:after {
	background: <?php echo esc_html( $primary_color );?>;
}
.rt-product-slider .featuredContainerrr .rtin-item-image .new-product:after {
	border-top: 10px solid <?php echo esc_html( $primary_color );?>;
}
.rt-product-slider .featuredContainerrr .rtin-item-image .new-product {
	background: <?php echo esc_html( $primary_color );?>;
}
.woocommerce.rt-product-slider-2 .popular-product-single #respond input#submit, .woocommerce.rt-product-slider-2 .popular-product-single a.button, .woocommerce.rt-product-slider-2 .popular-product-single button.button, .woocommerce.rt-product-slider-2 .popular-product-single input.button {
  border: 1px solid <?php echo esc_html( $primary_color );?>;
  color: <?php echo esc_html( $primary_color );?> !important;
}
.woocommerce.rt-product-slider-2 .popular-product-single .wishlist {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.woocommerce.rt-product-slider-2 .popular-product-single #respond input#submit, .woocommerce.rt-product-slider-2 .popular-product-single a.button:hover, .woocommerce.rt-product-slider-2 .popular-product-single button.button:hover, .woocommerce.rt-product-slider-2 .popular-product-single input.button:hover {
  background-color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-----------
# VC: Others
------------*/
?>
.project1-box .project1-box-inner .project1-box-content {
  background: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-post-vc-section-6 .rtin-single-post .rtin-item-info .rtin-post-date,
.rt-post-vc-section-6 .rtin-single-post:hover .rtin-item-info h3 a {
    color: <?php echo esc_html( $primary_color ); ?>;
}
.rt-vc-title-3 .title-bottom-icon i {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.rt-info-text-4 .service-box span {
    background: <?php echo esc_html( $primary_color );?>;
    border: 2px solid <?php echo esc_html( $primary_color );?>;
}
.rt-project-slider-two .our-projects-box2 .project-img-holder:before,
.rt-team-slider-nine .team-box .team-img-holder:after {
    background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}
.rt-project-slider-two .our-projects-box2 .project-content-holder h3 a:hover,
.rt-project-slider-three .our-projects-box3:hover .project-content-holder h3 a {
  color: <?php echo esc_html( $primary_color );?>;
}
.rt-team-slider-nine .team-box .team-content-holder {
  background: <?php echo esc_html( $primary_color );?>;
}
.rt-team-slider-nine .team-box .team-social li:hover i {
  color: <?php echo esc_html( $primary_color );?>;
}
.rt-after-before .rtin-ba-text i {
  color: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-contact-1 ul.rtin-item > li > i {
  color: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-contact-1 ul.rtin-item > li .contact-social li a {
  color: <?php echo esc_html( $primary_color );?>;
  border-color: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-contact-1 ul.rtin-item > li .contact-social li a:hover {
  background: <?php echo esc_html( $primary_color );?>;
}
.rt-vc-contact-2 ul.rtin-item > li > i {
  color: <?php echo esc_html( $primary_color );?>;
}
.skewbg {
    background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.73);
}
