<?php

/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

/*-------------------------------------
INDEX
=======================================
#. Container
#. Top Bar
#. Header
#. Typography
#. Banner
#. Footer
#. Slider
#. Widgets
#. Inner Contents
#. Error 404
#. comment
#. Buttons
#. Single Content
#. Archive Contents
#. Pagination
#. Contact Form 7
#. Single Project
#. Single Team
#. WooCommerce
#. Miscellaneous
-------------------------------------*/

$primary_color         = GREENOVA_Theme::$options['primary_color']; // #1fa12e
$primary_dark          = GREENOVA_Theme_Helper::rt_modify_color($primary_color, -50);
$primary_light          = GREENOVA_Theme_Helper::rt_modify_color($primary_color, 50);
$secondery_color       = '#797979';
$primary_rgb           = GREENOVA_Theme_Helper::hex2rgb($primary_color); // 31, 161, 46

$container_width	   = GREENOVA_Theme::$options['container_width']; // Grid Container width

$menu_typo             = GREENOVA_Theme::$options['menu_typo'];
$menu_color            = GREENOVA_Theme::$options['menu_color'];
$menu_color_tr         = GREENOVA_Theme::$options['menu_color_tr'];
$menu_hover_color      = GREENOVA_Theme::$options['menu_hover_color'];
$menu_bgcolor_6        = GREENOVA_Theme::$options['menu_bgcolor_6'];
$menu_bgcolor_10       = GREENOVA_Theme::$options['menu_bgcolor_10'];
$menu_bgcolor_11       = GREENOVA_Theme::$options['menu_bgcolor_11'];

$menu_color_6          = GREENOVA_Theme::$options['menu_color_6'];
$menu_hover_color_6    = GREENOVA_Theme::$options['menu_hover_color_6'];

$menu_color_10         = GREENOVA_Theme::$options['menu_color_10'];
$menu_hover_color_10   = GREENOVA_Theme::$options['menu_hover_color_10'];

$menu_color_11         = GREENOVA_Theme::$options['menu_color_11'];
$menu_hover_color_11   = GREENOVA_Theme::$options['menu_hover_color_11'];

$submenu_typo          = GREENOVA_Theme::$options['submenu_typo'];
$submenu_color         = GREENOVA_Theme::$options['submenu_color'];
$submenu_bgcolor       = GREENOVA_Theme::$options['submenu_bgcolor'];
$submenu_hover_color   = GREENOVA_Theme::$options['submenu_hover_color'];
$submenu_hover_bgcolor = GREENOVA_Theme::$options['submenu_hover_bgcolor'];
$resmenu_typo          = GREENOVA_Theme::$options['resmenu_typo'];

$greenova_typo_body     = GREENOVA_Theme::$options['typo_body'];
$greenova_typo_h1       = GREENOVA_Theme::$options['typo_h1'];
$greenova_typo_h2       = GREENOVA_Theme::$options['typo_h2'];
$greenova_typo_h3       = GREENOVA_Theme::$options['typo_h3'];
$greenova_typo_h4       = GREENOVA_Theme::$options['typo_h4'];
$greenova_typo_h5       = GREENOVA_Theme::$options['typo_h5'];
$greenova_typo_h6       = GREENOVA_Theme::$options['typo_h6'];
?>
<?php
/*-------------------------------------
#. Container
---------------------------------------*/
?>
:root{
--rt-primary-color: <?php echo esc_html($primary_color); ?>;
--rt-secondary-color: <?php echo esc_html($secondery_color); ?>;
--rt-primary-dark: <?php echo esc_html($primary_dark); ?>;
--rt-primary-light: <?php echo esc_html($primary_light); ?>;
--rt-primary-rgb: <?php echo esc_html($primary_rgb); ?>;
}

@media ( min-width:1440px ) {
.container {
width: <?php echo esc_html($container_width); ?>px;
}
}
<?php
/*-------------------------------------
#. Top Bar
---------------------------------------*/
?>
#tophead {
background-color: <?php echo esc_html(GREENOVA_Theme::$options['top_bar_bgcolor']); ?>;
}
#tophead .tophead-contact i,
#tophead .tophead-address i {
color:<?php echo esc_html($primary_color); ?>;
}
#tophead,
#tophead a,
#tophead .tophead-contact a {
color: <?php echo esc_html(GREENOVA_Theme::$options['top_bar_color']); ?>;
}

#tophead .tophead-social li a:hover {
background-color: <?php echo esc_html($primary_color); ?>;
}
#tophead .tophead-contact a:hover,
.topbar-style-5 #tophead .tophead-social li a,
.topbar-style-7 #tophead .tophead-social li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.trheader #tophead,
.trheader #tophead a,
.trheader #tophead .tophead-social li a {
color: <?php echo esc_html(GREENOVA_Theme::$options['top_bar_color_tr']); ?>;
}
.greenova-primary-color{
color:<?php echo esc_html($primary_color); ?>;
}
.greenova-primary-bgcolor {
background-color: <?php echo esc_html($primary_color); ?>;
}
.header-style-10 .header-address li.header-social ul li a:hover {
border-color:<?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Header
---------------------------------------*/
?>
<?php // Main Menu 
?>
.site-header .main-navigation ul li a,
.site-header .main-navigation nav ul li a {
font-family: <?php echo esc_html($menu_typo['font-family']); ?>, sans-serif;
font-size : <?php echo esc_html($menu_typo['font-size']); ?>;
font-weight : <?php echo esc_html($menu_typo['font-weight']); ?>;
line-height : <?php echo esc_html($menu_typo['line-height']); ?>;
color: <?php echo esc_html($menu_color); ?>;
text-transform : <?php echo esc_html($menu_typo['text-transform']); ?>;
font-style: <?php echo empty($menu_typo['font-style']) ? 'normal' : $menu_typo['font-style']; ?>;
}
.site-header .main-navigation ul.menu > li > a:hover,
.site-header .main-navigation ul.menu > li.current-menu-item > a,
.site-header .main-navigation ul.menu > li.current > a {
color: <?php echo esc_html($menu_hover_color); ?>;
}
.site-header .main-navigation ul li a.active {
color: <?php echo esc_html($menu_hover_color); ?> !important;
}
.trheader.non-stick .site-header .main-navigation ul.menu > li > a,
.trheader.non-stick .site-header .search-box .search-button i,
.trheader.non-stick .header-icon-seperator,
.trheader.non-stick .header-icon-area .cart-icon-area > a,
.trheader.non-stick .additional-menu-area a.side-menu-trigger {
color: <?php echo esc_html($menu_color_tr); ?>;
}
<?php // Submenu 
?>
.site-header .main-navigation ul li ul li {
background-color: <?php echo esc_html($submenu_bgcolor); ?>;
}
.site-header .main-navigation ul li ul li:hover {
background-color: <?php echo esc_html($submenu_hover_bgcolor); ?>;
}
.site-header .main-navigation ul li ul li a {
font-family: <?php echo esc_html($submenu_typo['font-family']); ?>, sans-serif;
font-size : <?php echo esc_html($submenu_typo['font-size']); ?>;
font-weight : <?php echo esc_html($submenu_typo['font-weight']); ?>;
line-height : <?php echo esc_html($submenu_typo['line-height']); ?>;
color: <?php echo esc_html($submenu_color); ?>;
text-transform : <?php echo esc_html($submenu_typo['text-transform']); ?>;
font-style: <?php echo empty($submenu_typo['font-style']) ? 'normal' : $submenu_typo['font-style']; ?>;
}
.site-header .main-navigation ul li ul li:hover > a {
color: <?php echo esc_html($submenu_hover_color); ?>;
}

<?php // Sticky Menu 
?>
.mean-container .mean-bar,
.stick .site-header {
border-color: <?php echo esc_html($primary_color); ?>
}
.mean-container .mean-bar .mob-info a {
background-color: <?php echo esc_html($primary_color); ?>
}
<?php // Multi Column Menu 
?>
.site-header .main-navigation ul li.mega-menu > ul.sub-menu {
background-color: <?php echo esc_html($submenu_bgcolor); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a {
color: <?php echo esc_html($submenu_color); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a:hover {
background-color: <?php echo esc_html($submenu_hover_bgcolor); ?>;
color: <?php echo esc_html($submenu_hover_color); ?>;
}
<?php // Mean Menu 
?>
.mean-container a.meanmenu-reveal,
.mean-container .mean-nav ul li a.mean-expand {
color: <?php echo esc_html($primary_color); ?>;
}
.mean-container .mean-bar {
border-color: <?php echo esc_html($primary_color); ?>;
}
.mean-container .mean-nav ul li a {
font-family: <?php echo esc_html($resmenu_typo['font-family']); ?>, sans-serif;
font-size : <?php echo esc_html($resmenu_typo['font-size']); ?>;
font-weight : <?php echo esc_html($resmenu_typo['font-weight']); ?>;
line-height : <?php echo esc_html($resmenu_typo['line-height']); ?>;
color: <?php echo esc_html($menu_color); ?>;
text-transform : <?php echo esc_html($resmenu_typo['text-transform']); ?>;
font-style: <?php echo empty($resmenu_typo['font-style']) ? 'normal' : $resmenu_typo['font-style']; ?>;
}
.mean-container .mean-nav ul li a:hover,
.mean-container .mean-nav > ul > li.current-menu-item > a {
color: <?php echo esc_html($menu_hover_color); ?>;
}
<?php // Header icons 
?>
.header-icon-area .cart-icon-area .cart-icon-num {
background-color: <?php echo esc_html($primary_color); ?>;
}
.additional-menu-area a.side-menu-trigger:hover,
.trheader.non-stick .additional-menu-area a.side-menu-trigger:hover {
color: <?php echo esc_html($menu_hover_color); ?>;
}
.site-header .search-box .search-text {
border-color: <?php echo esc_html($primary_color); ?>;
}

<?php // Header Layout 3 
?>
.header-style-3 .header-contact .fa,
.header-style-3 .header-social li a:hover,
.header-style-3.trheader .header-social li a:hover {
color: <?php echo esc_html($menu_hover_color); ?>;
}
.header-style-3.trheader .header-contact li a,
.header-style-3.trheader .header-social li a {
color: <?php echo esc_html($menu_color_tr); ?>;
}

<?php // Header Layout 4 
?>
.header-style-4 .header-contact .fa,
.header-style-4 .header-social li a:hover,
.header-style-4.trheader .header-social li a:hover {
color: <?php echo esc_html($menu_hover_color); ?>;
}
.header-style-4.trheader .header-contact li a,
.header-style-4.trheader .header-social li a {
color: <?php echo esc_html($menu_color_tr); ?>;
}

<?php // Header Layout 5 
?>
.header-style-5 .header-menu-btn {
background-color: <?php echo esc_html($primary_color); ?>;
}
.trheader.non-stick.header-style-5 .header-menu-btn {
color: <?php echo esc_html($menu_color_tr); ?>;
}
.header-style-5.non-stickh ul.header-address li .icon-left i {
color: <?php echo esc_html($primary_color); ?>;
}

<?php // Header Layout 6 
?>
.header-style-6 .header-address li i,
.header-style-6 .site-header .main-navigation .nav-area .header-cta a:hover,
.site-header .additional-menu-area ul li ul.sub-menu li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.header-style-6.stick .site-header::before {
background-color: <?php echo esc_html($primary_color); ?>;
}
.header-style-6 .site-header .main-navigation .nav-area {
background-color: <?php echo esc_html($menu_bgcolor_6); ?>;
}
.header-style-6 .site-header .main-navigation .nav-area ul.menu li > a {
color: <?php echo esc_html($menu_color_6); ?>;
}
.header-style-6 .site-header .main-navigation .nav-area ul.menu li > a:hover {
color: <?php echo esc_html($menu_hover_color_6); ?>;
}

<?php // Header Layout 7 
?>
.header-style-7.has-topbar .site-header .header-area:before,
.header-style-7 .site-header .header-area:before,
.header-style-7 .site-header .site-branding {
background: <?php echo esc_html($primary_color); ?>;
}
.header-style-7 .site-header .site-branding:before {
border-color: transparent <?php echo esc_html($primary_color); ?>;
}
<?php // Header Layout 8 
?>
.header-style-8 .site-header .site-branding,
.header-style-8 .site-header .logo-part,
.header-style-8.trheader .site-header .site-branding {
background: <?php echo esc_html($primary_color); ?>;
}
.header-style-8 .site-header .site-branding:before {
border-color: transparent <?php echo esc_html($primary_color); ?>;
}
.header-style-8.trheader.non-stickh .header-area::before,
.header-style-10 .header-address li.header-social ul li a:hover,
.header-style-10.non-stickh .full-menu {
background: <?php echo esc_html($primary_color); ?>;
}
.header-style-10 .site-header .main-navigation .nav-area {
background: <?php echo esc_html($menu_bgcolor_10); ?>;
}
.header-style-10 .site-header .main-navigation .nav-area ul.menu li > a {
color: <?php echo esc_html($menu_color_10); ?>;
}
.header-style-10 .site-header .main-navigation .nav-area ul.menu li > a:hover {
color: <?php echo esc_html($menu_hover_color_10); ?>;
}

.header-style-11 .full-menu,
.header-style-11 .site-header .main-navigation .nav-area {
background: <?php echo esc_html($menu_bgcolor_11); ?>;
}
.header-style-11 .site-header .main-navigation .nav-area ul.menu li > a {
color: <?php echo esc_html($menu_color_11); ?>;
}
.header-style-11 .site-header .main-navigation .nav-area ul.menu li > a:hover {
color: <?php echo esc_html($menu_hover_color_11); ?>;
}
<?php // Header Layout 6 
?>
.header-style-9 .site-header .main-navigation .nav-area .header-cta a:hover,
.header-style-10 .header-address li i,
.header-style-11 .header-address li i,
.header-style-12 .header-address li i {
color: <?php echo esc_html($primary_color); ?>;
}
.header-style-10.trheader #tophead .tophead-social li a:hover {
border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.header-style-12 .site-header .main-navigation .menu-main-menu-container ul.menu > li.current-menu-parent > a:before,
.header-style-12 .site-header .main-navigation .menu-main-menu-container ul.menu > li.current-menu-item > a:before,
.header-style-12 .site-header .main-navigation .menu-main-menu-container ul.menu > li.menu-item:hover > a:before,
.header-style-12 .header-icon-area .cart-icon-area .cart-icon-num {
background-color: <?php echo esc_html($primary_color); ?>;
}
.header-style-9 .main-navigation .address a.light-button,
.header-style-12 .header-address li .address a.light-button {
background-color: <?php echo esc_html($primary_color); ?>;
border-color: <?php echo esc_html($primary_color); ?>;
}
.header-style-9 .main-navigation .address a.light-button:hover,
.header-style-12 .header-address li .address a.light-button:hover,
.header-style-12 .header-address li .address a.light-button:hover i {
color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Typography
---------------------------------------*/
?>
body {
font-family: <?php echo esc_html($greenova_typo_body['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_body['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_body['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_body['font-weight']); ?>;
}
h1 {
font-family: <?php echo esc_html($greenova_typo_h1['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_h1['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_h1['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_h1['font-weight']); ?>;
}
h2 {
font-family: <?php echo esc_html($greenova_typo_h2['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_h2['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_h2['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_h2['font-weight']); ?>;
}
h3 {
font-family: <?php echo esc_html($greenova_typo_h3['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_h3['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_h3['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_h3['font-weight']); ?>;
}
h4 {
font-family: <?php echo esc_html($greenova_typo_h4['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_h4['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_h4['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_h4['font-weight']); ?>;
}
h5 {
font-family: <?php echo esc_html($greenova_typo_h5['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_h5['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_h5['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_h5['font-weight']); ?>;
}
h6 {
font-family: <?php echo esc_html($greenova_typo_h6['font-family']); ?>, sans-serif;
font-size: <?php echo esc_html($greenova_typo_h6['font-size']); ?>;
line-height: <?php echo esc_html($greenova_typo_h6['line-height']); ?>;
font-weight: <?php echo esc_html($greenova_typo_h6['font-weight']); ?>;
}
<?php
/*-------------------------------------
#. Banner
---------------------------------------*/
?>
.entry-banner .entry-banner-content h1 {
color: <?php echo esc_html(GREENOVA_Theme::$options['banner_heading_color']); ?>;
}
.breadcrumb-area .entry-breadcrumb span a {
color: <?php echo esc_html(GREENOVA_Theme::$options['breadcrumb_link_color']); ?>;
}
.breadcrumb-area .entry-breadcrumb span a:hover {
color: <?php echo esc_html(GREENOVA_Theme::$options['breadcrumb_link_hover_color']); ?>;
}
.breadcrumb-area .entry-breadcrumb .breadcrumb-seperator {
color: <?php echo esc_html(GREENOVA_Theme::$options['breadcrumb_seperator_color']); ?>;
}
.breadcrumb-area .entry-breadcrumb > span:last-child {
color: <?php echo esc_html(GREENOVA_Theme::$options['breadcrumb_active_color']); ?>;
}
.breadcrumb-area .entry-breadcrumb {
background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Footer
---------------------------------------*/
?>
.scrollToTop {
background-color: <?php echo esc_html($primary_color); ?>;
}
.footer-top-area {
background-color: <?php echo esc_html(GREENOVA_Theme::$options['footer_bgcolor']); ?>;
}
.footer-top-area .widget h3 {
color: <?php echo esc_html(GREENOVA_Theme::$options['footer_title_color']); ?>;
}
.footer-top-area .widget {
color: <?php echo esc_html(GREENOVA_Theme::$options['footer_color']); ?>;
}
.footer-top-area a:link,
.footer-top-area a:visited {
color: <?php echo esc_html(GREENOVA_Theme::$options['footer_link_color']); ?>;
}
.footer-top-area a:hover,
.footer-top-area a:active {
color: <?php echo esc_html(GREENOVA_Theme::$options['footer_link_hover_color']); ?>;
}
.footer-bottom-area {
background-color: <?php echo esc_html(GREENOVA_Theme::$options['copyright_bgcolor']); ?>;
}
.footer-bottom-area .footer-bottom-left {
color: <?php echo esc_html(GREENOVA_Theme::$options['copyright_color']); ?>;
}
.footer-top-area .widget_archive li {
border-bottom: 1px dotted <?php echo esc_html($primary_color); ?>;
}
.footer-top-area .widget_tag_cloud a:hover {
background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Slider
---------------------------------------*/
?>
.ls-v6 .ls-nav-prev:hover,
.ls-v6 .ls-nav-next:hover {
background-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Widgets
---------------------------------------*/
?>
.search-form .input.search-submit {
background-color: <?php echo esc_html($primary_color); ?>;
border-color: <?php echo esc_html($primary_color); ?>;
}
.search-form .input.search-submit a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.search-no-results .custom-search-input .btn{
background-color: <?php echo esc_html($primary_color); ?>;
}
.widget ul li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.sidebar-widget-area .widget h3.widgettitle:after {
background-color: <?php echo esc_html($primary_color); ?>;
}
.sidebar-widget-area .widget_tag_cloud a {
border-color: <?php echo esc_html($primary_color); ?>;
}
.sidebar-widget-area .widget h3.widgettitle:after {
background: <?php echo esc_html($primary_color); ?>;
}
.sidebar-widget-area .widget .rt-slider-sidebar .rt-single-slide .testimo-info .testimo-title h3,
.sidebar-widget-area .rt_widget_recent_entries_with_image .media-body .posted-date,
.sidebar-widget-area .widget ul li a:before,
.sidebar-widget-area .widget ul li a:hover,
.sidebar-widget-area .widget ul li.active a,
.sidebar-widget-area .widget ul li.active a:before,
.footer-top-area .search-form input.search-submit,
.footer-top-area ul li:before,
.footer-top-area ul li a:before {
color: <?php echo esc_html($primary_color); ?>;
}
.footer-top-area .corporate-address li i ,
.footer-top-area .search-form input.search-submit,
.footer-top-area ul li a:before,
.footer-top-area .stylish-input-group .input-group-addon button i,
.footer-top-area .widget_archive li a:before,
.footer-top-area .rt_footer_social_widget .footer-social li:hover i {
color: <?php echo esc_html($primary_color); ?>;
}
.footer-top-area .search-form button {
background-color: <?php echo esc_html($primary_color); ?>;
}
.footer-topbar ,
.footer-top-area .widgettitle:after,
#respond .comment-reply-title:after {
background: <?php echo esc_html($primary_color); ?>;
}
.footer-topbar .emergrncy-content-holder:before {
border-color: transparent <?php echo esc_html($primary_color); ?>;
}
.sidebar-widget-area .rt_widget_recent_entries_with_image .media-body a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.widget.rt_widget_download.custom-widget a {
background: <?php echo esc_html($primary_color); ?>;
}
.sidebar-widget-area .widget_tag_cloud a:hover {
background: <?php echo esc_html($primary_color); ?>;
border-color: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Inner Contents
---------------------------------------*/
?>
a:link,
a:visited,
.entry-footer .about-author .media-body .author-title,
.entry-title h1 a {
color: <?php echo esc_html($primary_color); ?>;
}
.entry-content a {
color:<?php echo esc_html($primary_color); ?>;
}
.entry-footer .tags a:hover,
.entry-title h1 a:hover {
color: <?php echo esc_html($secondery_color); ?>;
}
.comments-area .main-comments .replay-area a,
#respond form .btn-send,
.blog-style-2 .readmore-btn {
background-color: <?php echo esc_html($primary_color); ?>;
}
#respond form .btn-send:hover,
.blog-style-2 .readmore-btn:hover {
background-color: <?php echo esc_html($primary_color); ?>;
color: #ffffff;
}
blockquote p:before{
color: <?php echo esc_html($primary_color); ?>;
}
.blog-box .blog-img-holder:after,
.entry-footer .item-tags .tag_styles li:hover {
background: <?php echo esc_html($primary_color); ?>;
}
.sticky .blog-box {
border-color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Error 404
---------------------------------------*/
?>
.error-page-area {
background-color: <?php echo esc_html(GREENOVA_Theme::$options['error_bodybg']); ?>;
}
.error-page-area .error-page p {
color: <?php echo esc_html(GREENOVA_Theme::$options['error_text1_color']); ?>;
}
.error-page-area .error-page-content p {
color: <?php echo esc_html(GREENOVA_Theme::$options['error_text2_color']); ?>;
}

<?php
/*-------------------------------------
#. Comment
---------------------------------------*/
?>
.comments-area h3:before{
background: <?php echo esc_html($secondery_color); ?>;
}
#respond form .btn-send:hover {
color: #ffffff;
}
.item-comments .item-comments-list ul.comments-list li .comment-reply {
background-color: <?php echo esc_html($primary_color); ?>;
}
.item-comments .item-comments-form .comments-form .form-group .form-control {
background-color: <?php echo esc_html($secondery_color); ?>;
}
.title-bar35:after {
background: <?php echo esc_html($primary_color); ?>;
}
<?php
/*------------------------------------
#. Buttons
------------------------------------*/
?>
.greenova-button-1,
.entry-content a.grid-fill-btn:hover:after,
.entry-content .rt-grid-fill-btn a.grid-fill-btn:hover:after {
color: <?php echo esc_html($primary_color); ?>;
}
.greenova-button-1:hover {
background: <?php echo esc_html($primary_color); ?>;
}
.greenova-button-2 {
background: <?php echo esc_html($primary_color); ?>;
}
.greenova-button-2:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.greenova-primary-color {
color: <?php echo esc_html($primary_color); ?>;
}
.btn-read-more-h-b {
border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.con-home-6 .btn-send-message {
background: <?php echo esc_html($primary_color); ?>;
border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.con-home-6 .btn-send-message:hover,
.dark-button:after,
.btn-square-transparent:hover,
.contact-form input[type="submit"],
.entry-content .btn-square-transparent.more:hover {
background: <?php echo esc_html($primary_color); ?>;
}
.dark-button:hover,
.btn-square-transparent {
border-color: <?php echo esc_html($primary_color); ?>;
}
.entry-content .btn-square-transparent.more {
color: <?php echo esc_html($primary_color); ?>;
}
.contact-form input[type="submit"],
.con-home-6 input[type="submit"],
.contact-dark-button {
background: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Single Content
---------------------------------------*/
?>
.entry-header .entry-meta ul li i ,
.entry-header .entry-meta ul li a:hover ,
.entry-footer ul.item-tags li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.entry-footer .item-tags .tag_styles li {
border-color: <?php echo esc_html($primary_color); ?>;
}
.comments-area h3.comment-num:after {
background: <?php echo esc_html($primary_color); ?>;
}
.service-details-top .rt-vc-title-1 ul li:before {
color: <?php echo esc_html($primary_color); ?>;
}
<?php
/*-------------------------------------
#. Archive Contents
---------------------------------------*/
?>
.blog-layout-1 .entry-header .entry-thumbnail-area .post-date1 {
background: <?php echo esc_html($primary_color); ?>;
}
.blog-layout-1 .entry-header .entry-content h3 a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.blog-layout-1 .entry-header .entry-content .greenova-button-7 {
background: <?php echo esc_html($primary_color); ?>;
}
.custom-search-input .btn {
background-color: <?php echo esc_html($primary_color); ?>;
}
.search-no-results .custom-search-input .btn {
background-color: <?php echo esc_html($primary_color); ?>;
}
.rt-blog-layout .entry-thumbnail-area ul li i {
color: <?php echo esc_html($primary_color); ?>;
}
.rt-blog-layout .entry-thumbnail-area ul li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.rt-blog-layout .entry-thumbnail-area ul .active {
background: <?php echo esc_html($primary_color); ?>;
}
.rt-blog-layout .entry-content h3 a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.blog-box .blog-social li a:hover i {
color: <?php echo esc_html($primary_color); ?>;
}

<?php /*blog style 2*/ ?>
.blog-box .blog-img-holder .blog-content-holder,
.blog-box .blog-bottom-content-holder a.blog-button:hover:after {
background: <?php echo esc_html($primary_color); ?>;
}
.blog-box .blog-bottom-content-holder h3 a:hover,
.blog-box .blog-bottom-content-holder ul li i,
.blog-box .blog-bottom-content-holder ul li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}

.blog-box .blog-bottom-content-holder a.blog-button {
color: <?php echo esc_html($primary_color); ?>;
border-color: <?php echo esc_html($primary_color); ?>;
}
.blog-box .blog-bottom-content-holder a.blog-button:hover {
background: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Pagination
---------------------------------------*/
?>
.pagination-area li.active a:hover,
.pagination-area ul li.active a,
.pagination-area ul li a:hover,
.pagination-area ul li span.current {
background-color: <?php echo esc_html($primary_color); ?>;
}
.woocommerce nav.woocommerce-pagination ul li.active a,
.woocommerce nav.woocommerce-pagination ul li span.current,
.pagination-area ul li.active a,
.woocommerce nav.woocommerce-pagination ul li a:hover,
.pagination-area ul li a:hover {
background-color: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Contact Form 7
---------------------------------------*/
?>
.rt-contact-info ul li a:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.cf7-quote-submit input {
border: 2px solid <?php echo esc_html($secondery_color); ?>;
}
.cf7-quote-submit input:hover {
background-color: <?php echo esc_html($secondery_color); ?> !important;
}
.contact-form h2:after {
background: <?php echo esc_html($primary_color); ?>;
}
.contact-form legend {
color: <?php echo esc_html($secondery_color); ?>;
}
.rt-request-call-four .request-form-wrapper .request-form .request-form-input .form-group.margin-bottom-none .default-big-btn ,
.rt-request-call-four .request-form-wrapper .request-form .form-heading ,
.contact-form .wpcf7-submit.contact-submit,
.contact-slider .contact-header {
background: <?php echo esc_html($primary_color); ?>;
}
.contact-form .wpcf7-submit.contact-submit:hover {
background: <?php echo esc_html($secondery_color); ?>;
}
.contact-slider .contact-header:after {
border-top-color: <?php echo esc_html($primary_color); ?>;
}
.contact-slider .input-form input[type="submit"],
.request-home5 .input-form input[type="submit"],
.request-home5 .input-button .contact-light-button {
background: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Single Project
---------------------------------------*/
?>
.project-details .project-info ul li span {
color: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Single Team
---------------------------------------*/
?>
.team-details-social li a {
background: <?php echo esc_html($primary_color); ?>;
border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.team-details-social li:hover a {
border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.team-details-social li:hover a i {
color: <?php echo esc_html($primary_color); ?>;
}
.skill-area .progress .lead {
border: 2px solid <?php echo esc_html($primary_color); ?>;
}
.skill-area .progress .progress-bar {
background: <?php echo esc_html($primary_color); ?>;
}
.team-details-info li i {
color: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. Single Service
---------------------------------------*/
?>
.single-greenova_service .sidebar-widget-area .custom-widget .menu li.current-menu-item a,
.single-greenova_service .sidebar-widget-area .custom-widget .menu li a:hover {
background: <?php echo esc_html($primary_color); ?>;
}

<?php
/*-------------------------------------
#. WooCommerce
---------------------------------------*/
?>
.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
.rt-woo-nav .owl-custom-nav-title::after,
.rt-woo-nav .owl-custom-nav .owl-prev:hover,
.rt-woo-nav .owl-custom-nav .owl-next:hover,
.woocommerce ul.products li.product .onsale,
.woocommerce span.onsale,
.woocommerce a.added_to_cart,
.woocommerce div.product form.cart .button,
.woocommerce #respond input#submit,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
p.demo_store,
.woocommerce-message::before,
.woocommerce-info::before,
.woocommerce #respond input#submit.disabled:hover,
.woocommerce #respond input#submit:disabled:hover,
.woocommerce #respond input#submit[disabled]:disabled:hover,
.woocommerce a.button.disabled:hover,
.woocommerce a.button:disabled:hover,
.woocommerce a.button[disabled]:disabled:hover,
.woocommerce button.button.disabled:hover,
.woocommerce button.button:disabled:hover,
.woocommerce button.button[disabled]:disabled:hover,
.woocommerce input.button.disabled:hover,
.woocommerce input.button:disabled:hover,
.woocommerce input.button[disabled]:disabled:hover,
.woocommerce #respond input#submit.alt,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,
.woocommerce-account .woocommerce .woocommerce-MyAccount-navigation ul li a {
background-color: <?php echo esc_html($primary_color); ?>;
}
.woo-shop-top .view-mode ul li:first-child .fa,
.woo-shop-top .view-mode ul li:last-child .fa,
.woocommerce ul.products li.product h3 a:hover,
.woocommerce ul.products li.product .price,
.woocommerce .product-thumb-area .product-info ul li a:hover .fa,
.woocommerce div.product p.price,
.woocommerce div.product span.price,
.woocommerce div.product .product-meta a:hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active a,
.woocommerce a.woocommerce-review-link:hover {
color: <?php echo esc_html($primary_color); ?>;
}
.woocommerce-message,
.woocommerce-info,
.woocommerce nav.woocommerce-pagination ul li span,
.pagination-area ul li span {
border-color: <?php echo esc_html($primary_color); ?>;
}
.woocommerce .product-thumb-area .overlay {
background-color: rgba(<?php echo esc_html($primary_rgb); ?>, 0.8);
}

<?php
/*--------------
 # isotope
 ---------------*/
?>

.myisotop1 a:hover,
.myisotop1 .current,
.btn-slider-fill,
.btn-quote2,
.entry-content .btn-slider:hover {
background: <?php echo esc_html($primary_color); ?>;
}
.myisotop1 a {
border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.entry-content .btn-slider:hover {
border: 2px solid <?php echo esc_html($primary_color); ?> !important;
}

<?php
/*----------------------
#. Miscellaneous
----------------------*/
?>
<?php /* Theme Color */ ?>
.style4 .rtin-single-testimonial .rtin-testi-img h3,
.style1 .rtin-single-testimonial .rtin-testi-img h3,
.rt-info-text-4.service3-box-right .service3-icon-holder i,
.section-heading .top-title,
.experince h2 span,
.rt-info-text-4.service3-box-right .service3-icon-holder i,
.rt-info-text-8 .service-box a.btn-quote2 {
color: <?php echo esc_html($primary_color); ?>;
}

.entry-content .rtin-proj6-box-info-2 .rt-grid-fill-btn a.grid-fill-btn:hover {
color: <?php echo esc_html($primary_color); ?> !important;
}

<?php /* Theme Background Color */ ?>

.header-style-12 .site-header .main-navigation nav ul.menu > li.current-menu-parent > a:before,
.header-style-12 .site-header .main-navigation nav ul.menu > li.current-menu-item > a:before,
.header-style-12 .site-header .main-navigation nav ul.menu > li.menu-item:hover > a:before,
.entry-content .wpb_layerslider_element a.layerslider-button,
.title-bar35small::after,
button,
input[type="button"],
input[type="reset"],
input[type="submit"],
.square-style.elementor-image-carousel-wrapper .elementor-swiper-button i,
.rt-info-text-6 .service-box {
background-color: <?php echo esc_html($primary_color); ?>;
}

<?php //Primary Dark 
?>
.rt-owl-nav-4.slider-dot-enabled .owl-carousel .owl-dot.active span,
.rt-owl-nav-4.slider-dot-enabled .owl-carousel .owl-dot:hover span,
.greenova-primary-bg-dark {
background-color: <?php echo esc_html($primary_dark); ?> !important;
}

.entry-content .btn-read-more-h-b {
border: 1px solid <?php echo esc_html($primary_color); ?>;
}
.bottomBorder {
border-bottom: 2px solid <?php echo esc_html($primary_color); ?>;
}