<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
 
$greenova_has_entry_meta  = ( ( !has_post_thumbnail() && GREENOVA_Theme::$options['blog_date'] ) || GREENOVA_Theme::$options['blog_author_name'] || GREENOVA_Theme::$options['blog_comment_num'] || GREENOVA_Theme::$options['blog_cats'] ) ? true : false;

$greenova_comments_number = number_format_i18n( get_comments_number() );
$greenova_comments_html = $greenova_comments_number < 2 ? esc_html__( 'Comment' , 'greenova' ) : esc_html__( 'Comments' , 'greenova' );
$greenova_comments_html = '('. $greenova_comments_number . ') ' . $greenova_comments_html;
$thumbnail = false;
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'blog-layout-1' ); ?>>
	<div class="blog-box">								
		<div class="blog-img-holder">	
			<a href="<?php the_permalink(); ?>">
			<?php if ( has_post_thumbnail() ) { ?>
				<?php the_post_thumbnail( 'greenova-size1', array( 'class' => 'img-responsive' ) );?>
			<?php } else {
				if ( !empty( GREENOVA_Theme::$options['no_preview_image']['id'] ) ) {
					$thumbnail = wp_get_attachment_image( GREENOVA_Theme::$options['no_preview_image']['id'], $thumb_size );
				}
				// elseif ( !empty( GREENOVA_Theme::$options['no_preview_image']['url'] ) ) {
					// $thumbnail = '<img class="attachment-greenova-size5 size-greenova-size5 wp-post-image" src="'.GREENOVA_IMG_URL.'noimage_460x270.jpg" alt="'.get_the_title().'">';
				// }
				echo wp_kses_post( $thumbnail );
			} ?></a>
		</div>
		<div class="blog-bottom-content-holder">
			<ul>	
				<?php if ( GREENOVA_Theme::$options['blog_date'] ) { ?>
					<li class="blog-date"><i class="fa fa-calendar" aria-hidden="true"></i><?php echo get_the_date();?></li>
				<?php } ?>
				<?php if ( GREENOVA_Theme::$options['blog_author_name'] ): ?>
					<li><i class="fa fa-user-circle" aria-hidden="true"></i><?php esc_html_e( 'By ', 'greenova' ); ?><?php the_author_posts_link(); ?></li>
				<?php endif; ?>
				<?php if ( GREENOVA_Theme::$options['blog_cats'] ): ?>
					<li><i class="fa fa-th-list" aria-hidden="true"></i><?php the_category( ', ' );?></li>
				<?php endif; ?>
				<?php if ( GREENOVA_Theme::$options['blog_comment_num'] ): ?>
					<li><i class="far fa-comments" aria-hidden="true"></i><?php echo esc_html( $greenova_comments_html );?></li>
				<?php endif; ?>
			</ul>
			<h3 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<?php
				$id = get_the_ID();
				$content = get_the_content();
				$content = apply_filters( 'the_content', $content );
				$content = wp_trim_words( $content, 60 );
			?>
			<p><?php echo wp_kses_post( $content ); ?></p>
			<a class="blog-button" href="<?php the_permalink(); ?>"><span><?php esc_html_e( 'Read More', 'greenova' ); ?></span><i class="fa fa-angle-right" aria-hidden="true"></i></a>			
		</div>
	</div>
</div>