<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
	$greenova_title = woocommerce_page_title( false );
}
elseif ( is_404() ) {
	$greenova_title = GREENOVA_Theme::$options['error_title'];
}
elseif ( is_search() ) {
	$greenova_title = esc_html__( 'Search Results for : ', 'greenova' ) . get_search_query();
}
elseif ( is_home() ) {
	if ( get_option( 'page_for_posts' ) ) {
		$greenova_title = get_the_title( get_option( 'page_for_posts' ) );
	}
	else {
		$greenova_title = apply_filters( 'greenova_blog_title', esc_html__( 'All Posts', 'greenova' ) );
	}
}
elseif ( is_archive() ) {
	$greenova_title = get_the_archive_title();
}
else{
	$greenova_title = get_the_title();
}

if ( GREENOVA_Theme::$bgtype == 'bgcolor' ) {
	$greenova_bg = GREENOVA_Theme::$bgcolor;
} else {
	$greenova_bg = 'url(' . GREENOVA_Theme::$bgimg . ') no-repeat scroll center center / cover';
}

?>
<?php if ( GREENOVA_Theme::$has_banner == '1' || GREENOVA_Theme::$has_banner == 'on' ): ?>
	<div class="entry-banner" style="background:<?php echo esc_html( $greenova_bg ); ?>">
		<div class="container">
			<div class="entry-banner-content">
				<h1 class="entry-title"><?php echo wp_kses_post( $greenova_title );?></h1>
				<?php if ( GREENOVA_Theme::$has_breadcrumb == '1' || GREENOVA_Theme::$has_breadcrumb == 'on' ): ?>
					<?php get_template_part( 'template-parts/content', 'breadcrumb' );?>
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>