<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

global $post;
$terms = wp_get_post_terms( get_the_ID(), 'greenova_project_category');
$greenova_proj_client = get_post_meta( $id, 'greenova_proj_client', true );
$greenova_proj_url = get_post_meta( $id, 'greenova_proj_url', true );
?>	
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>		
	<div class="project-details">
		<div class="project-details-img">
			<?php if ( has_post_thumbnail() ) { ?>
				<?php the_post_thumbnail( 'greenova-size1', array( 'class' => 'img-responsive' ) ); ?>
			<?php } ?>
		</div>
		<div class="row">
		<div class="col-md-8" ><?php the_content();?></div>
		<div class="col-md-4" >
			<div class="project-info">
				<ul>
				<?php if ( !empty ( $greenova_proj_client ) ) { ?>
					<li><span><?php esc_html_e( 'Client ' , 'greenova' ); ?></span>: <?php echo esc_html ( $greenova_proj_client ); ?></li>
				<?php } ?>
				<?php if ( !empty ( $greenova_proj_url ) ) { ?>
					<li><span><?php esc_html_e( 'Live Demo ' , 'greenova' ); ?></span>: <?php echo esc_html ( $greenova_proj_url ); ?></li>
				<?php } ?>
					<li><span><?php esc_html_e( 'Category ' , 'greenova' ); ?></span>: 
						<?php
						$i = 1;
						foreach ( $terms as $term ) { $term_link = get_term_link( $term, 'greenova_project_category' ); if( is_wp_error( $term_link ) ) continue; 
						echo '<a href="' . $term_link . '">' . $term->name . '</a>'; 
						echo ( esc_html ( $i ) < esc_html ( count( $terms )))? ", " : ""; 
						$i++; }
						?>
					</li>
					<li><span><?php esc_html_e( 'Date ' , 'greenova' ); ?></span>: <?php echo esc_html ( get_the_date() ); ?></li>
				</ul>
			</div>
		</div>
		</div>		
	</div>
</div>