<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

global $post;
$terms = wp_get_post_terms( get_the_ID(), 'greenova_service_category');

$greenova_service_info_title = get_post_meta( get_the_ID(), 'greenova_service_info_title', true );
$greenova_service_info_des = get_post_meta( get_the_ID(), 'greenova_service_info_des', true );
$greenova_service_infos = get_post_meta( get_the_ID(), 'greenova_service_infos', true );
?>	
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>		
	<div class="service-details-top">					
		<?php if ( has_post_thumbnail() ) { ?>
			<?php the_post_thumbnail( 'greenova-size1', array( 'class' => 'img-responsive' ) ); ?>
		<?php } ?>		
		<ul class="service">
		<?php if ( has_term( '', 'greenova_service_category' ) ) { ?>
			<li class="rt-service-cats"><span class="rt-service-label"><?php esc_html_e( 'Categories', 'greenova' );?>:</span> <span class="rt-service-value">
			<?php foreach($terms as $term_single) {	
				$term_link = get_term_link( $term_single->term_id );
			?>
			<a href="<?php echo esc_attr($term_link); ?>"><?php echo esc_html( $term_single->name ); } ?></a>
			</span></li>
		</ul>
		<?php } ?>
		<?php the_content();?>		
	</div>	
	<?php if ( !empty ( $greenova_service_info_title ) ) { ?>
	<div class="service-details-bottom">	
		<h3 class="title-bar50"><?php echo wp_kses_post( $greenova_service_info_title ); ?></h3>
		<p><?php echo esc_html( $greenova_service_info_des ); ?></p>
		<?php if ( !empty( $greenova_service_infos ) ){ ?>
		<div class="row">
		<?php foreach ( $greenova_service_infos as $greenova_service_info ) { ?>
			<?php
			if ( empty( $greenova_service_info['skill_name'] ) || empty( $greenova_service_info['skill_value'] ) ) {
				continue;
			}
			?>
			<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
				<div class="benefit-box">
					<h3><?php echo esc_html( $greenova_service_info['skill_name'] );?></h3>
					<p><?php echo esc_html( $greenova_service_info['skill_value'] );?></p>
				</div>
			</div>
		<?php } ?>	
		</div>
		<?php } ?>		
	</div>
	<?php } ?>
</div>