<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */ 

$greenova_has_entry_meta  = ( ( !has_post_thumbnail() && GREENOVA_Theme::$options['post_date'] ) || GREENOVA_Theme::$options['post_author_name'] || GREENOVA_Theme::$options['post_comment_num'] || GREENOVA_Theme::$options['post_cats'] ) ? true : false;

$greenova_comments_number = number_format_i18n( get_comments_number() );
$greenova_comments_html = $greenova_comments_number < 2 ? esc_html__( 'Comment' , 'greenova' ) : esc_html__( 'Comments' , 'greenova' );
$greenova_comments_html = '('. $greenova_comments_number . ') ' . $greenova_comments_html;
$greenova_author_id       = get_the_author_meta( 'ID' );
$greenova_author_bio      = get_the_author_meta( 'description' );
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-header">
		<?php if ( has_post_thumbnail() ) { ?>
			<div class="entry-thumbnail-area">
				<?php the_post_thumbnail( 'greenova-size1' , array( 'class' => 'img-responsive' ) ); ?>
			</div>
		<?php } ?>
		<div class="entry-content">			
			<?php if ( $greenova_has_entry_meta ) { ?>
				<div class="entry-meta">
					<ul>
						<?php if ( GREENOVA_Theme::$options['post_date'] ): ?>
							<li><i class="fa fa-calendar" aria-hidden="true"></i><?php echo get_the_date();?></li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['post_author_name'] ): ?>
							<li><i class="fa fa-user-circle" aria-hidden="true"></i><?php esc_html_e( 'By ', 'greenova' ); ?><?php the_author_posts_link(); ?></li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['post_cats'] ): ?>
							<li><i class="fa fa-th-list" aria-hidden="true"></i><?php the_category( ', ' );?></li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['post_comment_num'] ): ?>
							<li><i class="far fa-comments" aria-hidden="true"></i><?php echo esc_html( $greenova_comments_html );?></li>
						<?php endif; ?>
					</ul>
				</div>
			<?php } ?>
			<?php the_content();?>
			<?php wp_link_pages();?>
		</div>
	</div>
	<?php if ( GREENOVA_Theme::$options['post_tags'] && has_tag() || GREENOVA_Theme::$options['post_social'] == 1 ) { ?>
	<div class="blog-single-info">
		<div class="row">
			<div class="col-md-8">
				<?php if ( GREENOVA_Theme::$options['post_tags'] && has_tag() ): ?>
				<div class="entry-footer">
					<div class="entry-footer-meta">			
						<div class="item-tags">
							<span><?php esc_html_e( 'Tags: ', 'greenova' );?></span><?php echo get_the_term_list( $post->ID, 'post_tag', '<ul class="tag_styles"><li>', '</li><li>', '</li></ul>' );?>
						</div>
					</div>
				</div>
				<?php endif; ?>
			</div>
			<div class="col-md-4">
				<?php if ( GREENOVA_Theme::$options['post_social'] == 1 ){ ?>
					<?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) && GREENOVA_Theme::$options['post_social'] ): ?>
					<div class="share"><?php ADDTOANY_SHARE_SAVE_KIT(); ?></div>                  
					<?php endif; ?>
				<?php } ?>
			</div>
		</div>
	</div>
	<?php } ?>
	<?php if ( GREENOVA_Theme::$options['post_author_bio'] && $greenova_author_bio ): ?>
		<div class="about-author">
			<div class="pull-left">
				<?php echo get_avatar( $greenova_author_id, 120 ); ?>
			</div>
			<div class="media-body">
				<div class="author-title"><?php esc_html_e( 'About The Author', 'greenova' );?></div>
				<div class="author-name"><?php the_author_posts_link();?></div>
				<div class="author-bio"><?php echo esc_html( $greenova_author_bio );?></div>
			</div>
			<div class="clear"></div>
		</div>			
	<?php endif; ?>
</div>