<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$greenova_has_entry_meta  = ( ( !has_post_thumbnail() && GREENOVA_Theme::$options['blog_date'] ) || GREENOVA_Theme::$options['blog_author_name'] || GREENOVA_Theme::$options['blog_comment_num'] || GREENOVA_Theme::$options['blog_cats'] ) ? true : false;

$greenova_comments_number = number_format_i18n( get_comments_number() );

$thumbnail = false;

if (  GREENOVA_Theme::$layout == 'right-sidebar' || GREENOVA_Theme::$layout == 'right-sidebar' ){
	$post_classes = array( 'col-lg-6 col-md-6 col-sm-6 col-xs-12' );
} else {
	$post_classes = array( 'col-lg-4 col-md-4 col-sm-4 col-xs-12' );
}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>	
	<div class="rt-blog-layout">
		<div class="entry-thumbnail-area">
			<a href="<?php the_permalink(); ?>">
			<?php if ( has_post_thumbnail() ) { ?>
				<?php the_post_thumbnail( 'greenova-size2', array( 'class' => 'img-resfponsive' ) );?>
			<?php } else {
				if ( !empty( GREENOVA_Theme::$options['no_preview_image']['id'] ) ) {
					$thumbnail = wp_get_attachment_image( GREENOVA_Theme::$options['no_preview_image']['id'], $thumb_size );
				}
				elseif ( !empty( GREENOVA_Theme::$options['no_preview_image']['url'] ) ) {
					$thumbnail = '<img class="attachment-greenova-size5 size-greenova-size5 wp-post-image" src="'.GREENOVA_IMG_URL.'noimage_370X270.jpg" alt="'.get_the_title().'">';
				}
				echo wp_kses_post( $thumbnail );
			} ?>
			</a>
			<ul>
				<?php if ( GREENOVA_Theme::$options['blog_date'] ) { ?>
				<li class="active"><?php echo get_the_time( 'M d, Y' ); ?></li>
				<?php } ?>				
				<?php if ( GREENOVA_Theme::$options['blog_author_name'] ) { ?>
				<li><i class="fa fa-user" aria-hidden="true"></i><span><?php esc_html_e( ' By ', 'greenova' ); ?></span><?php the_author_posts_link(); ?></li>
				<?php } if ( GREENOVA_Theme::$options['blog_comment_num'] ) { ?>
				<li><i class="fa fa-comment-o" aria-hidden="true"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $greenova_comments_number );?></a></li>
				<?php } ?>
			</ul>
		</div>
		<div class="entry-content">
			<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<div class="blog-text">
			<?php 				
			$id = get_the_ID();
			$content = get_the_content();
			$content = apply_filters( 'the_content', $content );
			$content = wp_trim_words( $content, 18 );
			echo wp_kses_post( $content ); ?>
			</div>
		</div>		
	</div>
</div>