<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = GREENOVA_Theme_Helper::nav_menu_args();

// Logo
$greenova_dark_logo = empty( GREENOVA_Theme::$options['logo']['url'] ) ? GREENOVA_IMG_URL . 'logo-dark.png' : GREENOVA_Theme::$options['logo']['url'];
$greenova_light_logo = empty( GREENOVA_Theme::$options['logo_light']['url'] ) ? GREENOVA_IMG_URL . 'logo-light.png' : GREENOVA_Theme::$options['logo_light']['url'];

$greenova_logo_col_num = (int) GREENOVA_Theme::$options['logo_width'];

// Menu and Icon wrapper classes
$greenova_icon_count = 0;
if ( GREENOVA_Theme::$options['search_icon'] ) {
	$greenova_icon_count++;
}
if ( GREENOVA_Theme::$options['cart_icon'] && class_exists( 'WC_Widget_Cart' ) ) {
	$greenova_icon_count++;
}

switch ( $greenova_icon_count ) {
	case 1:
	case 2:
	$greenova_icon_col_num = 1;
	break;
	case 3:
	$greenova_icon_col_num = 2;
	break;	
	default:
	$greenova_icon_col_num = 0;
	break;
}

$greenova_logo_class = "col-sm-{$greenova_logo_col_num} col-xs-12";
//$greenova_menu_class = 'col-sm-'. ( 12 - $greenova_logo_col_num - $greenova_icon_col_num ) . ' col-xs-12';
$greenova_menu_class = 'col-sm-'. ( 12 - $greenova_logo_col_num ) . ' col-xs-12';
$greenova_icon_class = "col-sm-{$greenova_icon_col_num} col-xs-12";

//Logo dimensions
$dark_logo_width   = isset( GREENOVA_Theme::$options['logo']['width'] ) ? GREENOVA_Theme::$options['logo']['width'] : '';
$dark_logo_height  = isset( GREENOVA_Theme::$options['logo']['height'] ) ? GREENOVA_Theme::$options['logo']['height'] : '';
$light_logo_width  = isset( GREENOVA_Theme::$options['logo_light']['width'] ) ? GREENOVA_Theme::$options['logo_light']['width'] : '';
$light_logo_height = isset( GREENOVA_Theme::$options['logo_light']['height'] ) ? GREENOVA_Theme::$options['logo_light']['height'] : '';

$dark_logo_dimensions = (!empty($dark_logo_width) && !empty($dark_logo_height)) ? 'width="'.$dark_logo_width.'" height="'.$dark_logo_height.'"' : 'width="211" height="58"';
$light_logo_dimensions = (!empty($light_logo_width) && !empty($light_logo_height)) ? 'width="'.$light_logo_width.'" height="'.$light_logo_height.'"' : 'width="211" height="58"';

?>
<div class="container masthead-container" id="sticker">
	<div class="row">
		<div class="<?php echo esc_attr( $greenova_logo_class );?>">
			<div class="site-branding">
				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>">
					<img <?php echo $dark_logo_dimensions; ?> src="<?php echo esc_url( $greenova_dark_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
				</a>
				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>">
					<img <?php echo $light_logo_dimensions; ?> src="<?php echo esc_url( $greenova_light_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
				</a>
			</div>
		</div>
		<div class="<?php echo esc_attr( $greenova_menu_class );?>">
			<div id="site-navigation" class="main-navigation">
				<?php if ( $greenova_icon_count ): ?>
					<?php get_template_part( 'template-parts/header/icon', 'area' );?>
				<?php endif; ?>
				<?php wp_nav_menu( $nav_menu_args );?>
			</div>
		</div>
	</div>
</div>