<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args   = GREENOVA_Theme_Helper::nav_menu_args();

// Logo
$greenova_dark_logo = empty( GREENOVA_Theme::$options['logo']['url'] ) ? GREENOVA_IMG_URL . 'logo-dark.png' : GREENOVA_Theme::$options['logo']['url'];
$greenova_light_logo = empty( GREENOVA_Theme::$options['logo_light']['url'] ) ? GREENOVA_IMG_URL . 'logo-light.png' : GREENOVA_Theme::$options['logo_light']['url'];

$greenova_logo_col_num = (int) GREENOVA_Theme::$options['logo_width'];

$greenova_logo_class = "col-sm-{$greenova_logo_col_num} col-xs-12";
$greenova_header_right_class = 'col-sm-'. ( 12 - $greenova_logo_col_num ) . ' col-xs-12';

// Icon
$greenova_has_icons = false;
if (  GREENOVA_Theme::$options['search_icon'] ||
	( GREENOVA_Theme::$options['cart_icon'] && class_exists( 'WC_Widget_Cart' ) ) ||
	( GREENOVA_Theme::$options['vertical_menu_icon'] && has_nav_menu( 'topright' ) ) ) {
	$greenova_has_icons = true;
}
$greenova_socials = GREENOVA_Theme_Helper::socials();

//Logo dimensions
$dark_logo_width = GREENOVA_Theme::$options['logo']['width'];
$dark_logo_height = GREENOVA_Theme::$options['logo']['height'];
$light_logo_width = GREENOVA_Theme::$options['logo_light']['width'];
$light_logo_height = GREENOVA_Theme::$options['logo_light']['height'];

$dark_logo_dimensions = (!empty($dark_logo_width) && !empty($dark_logo_height)) ? 'width="'.$dark_logo_width.'" height="'.$dark_logo_height.'"' : 'width="211" height="58"';
$light_logo_dimensions = (!empty($light_logo_width) && !empty($light_logo_height)) ? 'width="'.$light_logo_width.'" height="'.$light_logo_height.'"' : 'width="211" height="58"';
?>
<div class="container masthead-container" id="sticker">
	<div class="row header-firstrow">
		<div class="<?php echo esc_attr( $greenova_logo_class );?>">
			<div class="site-branding">
				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>">
					<img <?php echo $dark_logo_dimensions; ?> src="<?php echo esc_url( $greenova_dark_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
				</a>
				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>">
					<img <?php echo $light_logo_dimensions; ?> src="<?php echo esc_url( $greenova_light_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
				</a>
			</div>
		</div>
		<div class="<?php echo esc_attr( $greenova_header_right_class );?>">
			<ul class="header-address">
				<?php if ( GREENOVA_Theme::$options['phone'] || GREENOVA_Theme::$options['hour'] ): ?>
				<li>
					<div class="icon-left">
					<i class="fas fa-phone-alt" aria-hidden="true"></i>
					</div>
					<div class="address"><span><a href="tel:<?php echo esc_attr( GREENOVA_Theme::$options['phone'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['phone'] );?></a></span><?php echo wp_kses_post( GREENOVA_Theme::$options['hour'] );?></div>
				</li>
				<?php endif; ?>
				<?php if ( GREENOVA_Theme::$options['email'] ): ?>
				<li>
					<div class="icon-left">
					<i class="far fa-envelope" aria-hidden="true"></i>
					</div>
					<div class="address"><span><a href="mailto:<?php echo esc_attr( GREENOVA_Theme::$options['email'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['email'] );?></a></span><?php $header_mailus_txt = GREENOVA_Theme::$options['header_mailus_txt']; if ( !empty( $header_mailus_txt ) ){ echo esc_html( $header_mailus_txt ); } else { esc_html_e( 'Mail us', 'greenova' ); } ?></div>
				</li>
				<?php endif; ?>
				<?php if ( GREENOVA_Theme::$options['header_btn_txt'] ): ?>
				<li>
					<div class="address"><a class="light-button" href="<?php echo esc_html( GREENOVA_Theme::$options['header_btn_url'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['header_btn_txt'] );?><i class="fas fa-long-arrow-alt-right"></i></a></div>
				</li>
				<?php endif; ?>
			</ul>
		</div>
	</div>
</div>
<div class="full-menu">
	<div class="container masthead-container">
		<div id="site-navigation" class="main-navigation">
			<div class="nav-area clearfix">
				<?php wp_nav_menu( $nav_menu_args );?>
				
				<?php if ( $greenova_has_icons ): ?>
					<?php get_template_part( 'template-parts/header/icon', 'area' );?>
				<?php endif; ?>
				<?php /*<div class="header-cta">
					<a href="<?php echo GREENOVA_Theme::$options['header_btn_url'];?>"><?php echo GREENOVA_Theme::$options['header_btn_txt'];?></a>
				</div> */ ?>
			</div>
		</div>
	</div>
</div>