<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$greenova_socials = GREENOVA_Theme_Helper::socials();
$nav_menu_args   = GREENOVA_Theme_Helper::nav_menu_args();

// Logo
$greenova_dark_logo = empty( GREENOVA_Theme::$options['logo']['url'] ) ? GREENOVA_IMG_URL . 'logo-dark.png' : GREENOVA_Theme::$options['logo']['url'];
$greenova_light_logo = empty( GREENOVA_Theme::$options['logo_light']['url'] ) ? GREENOVA_IMG_URL . 'logo-light.png' : GREENOVA_Theme::$options['logo_light']['url'];

// Menu and Icon wrapper classes
$greenova_icon_count = 0;
if ( GREENOVA_Theme::$options['search_icon'] ) {
	$greenova_icon_count++;
}
if ( GREENOVA_Theme::$options['cart_icon'] && class_exists( 'WC_Widget_Cart' ) ) {
	$greenova_icon_count++;
}
if ( GREENOVA_Theme::$options['vertical_menu_icon'] && has_nav_menu( 'topright' ) ) {
	$greenova_icon_count++;
}

switch ( $greenova_icon_count ) {
	case 1:
	case 2:
	$greenova_menu_class = 'col-sm-10 col-xs-12';
	$greenova_icon_class = 'col-sm-2 col-xs-12';
	break;
	case 3:
	$greenova_menu_class = 'col-sm-10 col-xs-12';
	$greenova_icon_class = 'col-sm-2 col-xs-12';
	break;	
	default:
	$greenova_menu_class = 'col-sm-12 col-xs-12';
	break;
}

//Logo dimensions
$dark_logo_width = GREENOVA_Theme::$options['logo']['width'];
$dark_logo_height = GREENOVA_Theme::$options['logo']['height'];
$light_logo_width = GREENOVA_Theme::$options['logo_light']['width'];
$light_logo_height = GREENOVA_Theme::$options['logo_light']['height'];

$dark_logo_dimensions = (!empty($dark_logo_width) && !empty($dark_logo_height)) ? 'width="'.$dark_logo_width.'" height="'.$dark_logo_height.'"' : 'width="211" height="58"';
$light_logo_dimensions = (!empty($light_logo_width) && !empty($light_logo_height)) ? 'width="'.$light_logo_width.'" height="'.$light_logo_height.'"' : 'width="211" height="58"';

?>
<div class="container masthead-container" id="sticker">
	<div class="row header-firstrow">
		<div class="col-sm-2 col-xs-12">
			<div class="site-branding">
				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>">
					<img <?php echo $dark_logo_dimensions; ?> src="<?php echo esc_url( $greenova_dark_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
				</a>
				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>">
					<img <?php echo $light_logo_dimensions; ?> src="<?php echo esc_url( $greenova_light_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
				</a>
			</div>
		</div>
		<div class="col-sm-10 col-xs-12">
			<div class="header-firstrow-right">
				<div class="header-firstrow-right-contents">
					<ul class="header-contact">
						<?php if ( GREENOVA_Theme::$options['phone'] ): ?>
							<li>
								<i class="fas fa-phone-alt" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( GREENOVA_Theme::$options['phone'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['phone'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['email'] ): ?>
							<li>
								<i class="far fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( GREENOVA_Theme::$options['email'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['email'] );?></a>
							</li>
						<?php endif; ?>
					</ul>
					<?php if ( $greenova_socials ): ?>
						<ul class="header-social">
							<?php foreach ( $greenova_socials as $greenova_social ): ?>
								<li><a target="_blank" href="<?php echo esc_url( $greenova_social['url'] );?>"><i class="fab <?php echo esc_attr( $greenova_social['icon'] );?>"></i></a></li>
							<?php endforeach; ?>					
						</ul>						
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
	<hr class="menu-sep" />
	<div class="row">
		<div class="<?php echo esc_attr( $greenova_menu_class );?>">
			<div id="site-navigation" class="main-navigation">
				<?php wp_nav_menu( $nav_menu_args );?>
			</div>
		</div>
		<?php if ( $greenova_icon_count ): ?>
			<div class="<?php echo esc_attr( $greenova_icon_class );?>">
				<?php get_template_part( 'template-parts/header/icon', 'area' );?>
			</div>
		<?php endif; ?>
	</div>
</div>