<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args   = GREENOVA_Theme_Helper::nav_menu_args();

// Logo
$greenova_dark_logo = empty( GREENOVA_Theme::$options['logo']['url'] ) ? GREENOVA_IMG_URL . 'logo-dark.png' : GREENOVA_Theme::$options['logo']['url'];

//Logo dimensions
$dark_logo_width  = isset( GREENOVA_Theme::$options['logo']['width'] ) ? GREENOVA_Theme::$options['logo']['width'] : '';
$dark_logo_height = isset( GREENOVA_Theme::$options['logo']['height'] ) ? GREENOVA_Theme::$options['logo']['height'] : '';
$dark_logo_dimensions = (!empty($dark_logo_width) && !empty($dark_logo_height)) ? 'width="'.$dark_logo_width.'" height="'.$dark_logo_height.'"' : 'width="211" height="58"';
$phone = GREENOVA_Theme::$options['phone'];
$email = GREENOVA_Theme::$options['email'];

?>
<div class="rt-header-menu mean-container mobile-offscreen-menu" id="meanmenu">

	<?php
    if ( isset(GREENOVA_Theme::$options['top_bar_mobile']) && GREENOVA_Theme::$options['top_bar_mobile'] && (GREENOVA_Theme::$top_bar == 1 || GREENOVA_Theme::$top_bar == 'on') ){
        get_template_part( 'template-parts/header/header-top', GREENOVA_Theme::$top_bar_style );
    }
    ?>

    <div class="mean-bar">
        <div class="mobile-logo">
            <a href="<?php echo esc_url(home_url('/'));?>" alt="<?php echo esc_attr( get_bloginfo( 'title' ) );?>">
                <img <?php echo $dark_logo_dimensions; ?> src="<?php echo esc_url( $greenova_dark_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>">
            </a>
        </div>

        <div class="mob-info">
            <?php if($phone) : ?>
            <span class="phone"><a class="button-btn" target="_self" href="tel:<?php echo esc_attr($phone); ?>"><i class="fas fa-phone" aria-hidden="true"></i></a></span>
            <?php endif; ?>

            <?php if($email) : ?>
            <span class="mail"><a class="button-btn" target="_self" href="mailto:<?php echo esc_attr($email); ?>"><i class="fas fa-envelope" aria-hidden="true"></i></a></span>
            <?php endif; ?>

	        <?php if ( GREENOVA_Theme::$options['header_mobile_btn_txt'] ): ?>

            <a class="light-button" href="<?php echo esc_html( GREENOVA_Theme::$options['header_btn_url'] );?>">
                <span> <?php echo esc_html( GREENOVA_Theme::$options['header_mobile_btn_txt'] );?></span>
               <i class="fas fa-long-arrow-alt-right"></i></a>
	        <?php endif; ?>

        </div>

        <span class="sidebarBtn ">
            <span class="fa fa-bars">
            </span>
        </span>
    </div>

    <div class="rt-slide-nav">
        <div class="offscreen-navigation">
            <?php wp_nav_menu( $nav_menu_args );?>
        </div>
    </div>
</div>
