<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$greenova_socials = GREENOVA_Theme_Helper::socials();
$greenova_light_logo = empty( GREENOVA_Theme::$options['logo_light']['url'] ) ? GREENOVA_IMG_URL . 'logo-light.png' : GREENOVA_Theme::$options['logo_light']['url'];
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="row">
			<div class="col-sm-5 col-xs-12">
				<div class="tophead-contact">
					<ul>
						<?php if ( GREENOVA_Theme::$options['phone'] ): ?>
							<li>
								<i class="fas fa-phone-alt" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( GREENOVA_Theme::$options['phone'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['phone'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['email'] ): ?>
							<li>
								<i class="far fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( GREENOVA_Theme::$options['email'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['email'] );?></a>
							</li>
						<?php endif; ?>
					</ul>
				</div>				
			</div>
			<div class="col-sm-2 col-xs-12">
				<a class="topbar-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><img src="<?php echo esc_url( $greenova_light_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>				
			</div>
			<div class="col-sm-5 col-xs-12">
				<div class="tophead-right">
					<?php if ( $greenova_socials ): ?>
						<ul class="tophead-social">
							<?php foreach ( $greenova_socials as $greenova_social ): ?>
								<li><a target="_blank" href="<?php echo esc_url( $greenova_social['url'] );?>"><i class="fab <?php echo esc_attr( $greenova_social['icon'] );?>"></i></a></li>
							<?php endforeach; ?>
						</ul>
					<?php endif; ?>
				</div>				
			</div>
		</div>
	</div>
</div>