<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$greenova_socials = GREENOVA_Theme_Helper::socials();
$greenova_light_logo = empty( GREENOVA_Theme::$options['logo_light']['url'] ) ? GREENOVA_IMG_URL . 'logo-light.png' : GREENOVA_Theme::$options['logo_light']['url'];
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<div class="tophead-contact">
					<ul>
						<?php if ( GREENOVA_Theme::$options['top_bar_txt'] ): ?>
							<li><?php echo esc_html( GREENOVA_Theme::$options['top_bar_txt'] );?></li>
						<?php endif; ?>
					</ul>
				</div>
				<div class="tophead-right tophead-address">				
					<ul>
						<?php if ( GREENOVA_Theme::$options['phone'] ): ?>
							<li>
								<i class="fas fa-phone-alt" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( GREENOVA_Theme::$options['phone'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['phone'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['email'] ): ?>
							<li>
								<i class="far fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( GREENOVA_Theme::$options['email'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['email'] );?></a>
							</li>
						<?php endif; ?>
					</ul>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>