<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$greenova_socials = GREENOVA_Theme_Helper::socials();
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<div class="tophead-contact">
					<ul>
						<?php if ( GREENOVA_Theme::$options['phone'] ): ?>
							<li>
								<i class="fas fa-phone-alt" aria-hidden="true"></i><a href="tel:<?php echo esc_attr( GREENOVA_Theme::$options['phone'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['phone'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['email'] ): ?>
							<li>
								<i class="far fa-envelope" aria-hidden="true"></i><a href="mailto:<?php echo esc_attr( GREENOVA_Theme::$options['email'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['email'] );?></a>
							</li>
						<?php endif; ?>
						<?php if ( GREENOVA_Theme::$options['hour'] ): ?>
							<li>
								<i class="far fa-clock" aria-hidden="true"></i><?php echo esc_html( GREENOVA_Theme::$options['hour'] );?>
							</li>
						<?php endif; ?>
					</ul>
				</div>
				<div class="tophead-right">
					<?php if ( $greenova_socials ): ?>
						<ul class="tophead-social">
							<?php foreach ( $greenova_socials as $greenova_social ): ?>
								<li><a target="_blank" href="<?php echo esc_url( $greenova_social['url'] );?>"><i class="fab <?php echo esc_attr( $greenova_social['icon'] );?>"></i></a></li>
							<?php endforeach; ?>					
						</ul>						
					<?php endif; ?>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>