<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$greenova_socials = GREENOVA_Theme_Helper::socials();
?>
<div class="additional-menu-area">
	<div class="sidenav">
		<a href="#" class="closebtn">x</a>
		<?php wp_nav_menu( array( 'theme_location' => 'topright','container' => '' ) );?>
		
		<div class="sidenav-address">
			<h4><?php esc_html_e( 'Info', 'greenova' );?></h4>
			<?php if ( GREENOVA_Theme::$options['address'] ): ?>
			<span><?php echo wp_kses_post( GREENOVA_Theme::$options['address'] );?></span>
			<?php endif; ?>
			<?php if ( GREENOVA_Theme::$options['phone'] ): ?>
			<span><a href="tel:<?php echo esc_attr( GREENOVA_Theme::$options['phone'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['phone'] );?></a></span>
			<?php endif; ?>
			<?php if ( GREENOVA_Theme::$options['email'] ): ?>
			<span><a href="mailto:<?php echo esc_attr( GREENOVA_Theme::$options['email'] );?>"><?php echo esc_html( GREENOVA_Theme::$options['email'] );?></a></span>
			<?php endif; ?>
			<?php if ( $greenova_socials ): ?>
				<div class="sidenav-social">
					<?php foreach ( $greenova_socials as $greenova_social ): ?>
						<span><a target="_blank" href="<?php echo esc_url( $greenova_social['url'] );?>"><i class="fab <?php echo esc_attr( $greenova_social['icon'] );?>"></i></a></span>
					<?php endforeach; ?>					
				</div>						
			<?php endif; ?>
		</div>
	</div>
	<a class="side-menu-open side-menu-trigger"><i class="fa fa-bars" aria-hidden="true"></i></a>
</div>