<?php
/**
 * Template Name: Blog 2
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
 
// Layout class
if ( GREENOVA_Theme::$layout == 'full-width' ) {
	$layout_class = 'col-sm-12 col-xs-12';
	$post_class = 'col-lg-4 col-md-4 col-sm-4 col-xs-12';
}
else{
	$layout_class = 'col-sm-8 col-md-9 col-xs-12';
	$post_class = 'col-lg-6 col-md-6 col-sm-6 col-xs-12';
}
$args = array(
	'post_type' => "post",
);

if ( get_query_var('paged') ) {
	$args['paged'] = get_query_var('paged');
}
elseif ( get_query_var('page') ) {
	$args['paged'] = get_query_var('page');
}
else {
	$args['paged'] = 1;
}

$query = new WP_Query( $args );

global $wp_query;
$wp_query = NULL;
$wp_query = $query;
 
?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php
			if ( GREENOVA_Theme::$layout == 'left-sidebar' ) {
				get_sidebar();
			}
			?>
			<div class="<?php echo esc_attr( $layout_class );?>">
				<main id="main" class="site-main">					
					
					<?php if ( have_posts() ) :?>
						<?php
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/content-1', get_post_format() );
						endwhile;
						?>
						<div class="mt50"><?php GREENOVA_Theme_Helper::pagination();?></div>
					<?php else:?>
						<?php get_template_part( 'template-parts/content', 'none' );?>
					<?php endif;?>
					
				</main>					
			</div>			
			<?php
			if ( GREENOVA_Theme::$layout == 'right-sidebar' ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>