<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Greenova_Core;
$target   = $data['link']['is_external'] ? ' target="_blank"' : '';
$nofollow = $data['link']['nofollow'] ? ' rel="nofollow"' : '';
?>

<div class="rt-info-text-11 rt-info-box">
    <div class="service-box">
        <svg version="1.0" xmlns="http://www.w3.org/2000/svg"
             width="100%" height="52.000000pt" viewBox="0 0 370.000000 52.000000"
             preserveAspectRatio="xMidYMid meet">
            <g class="svg-pattern" transform="translate(0.000000,52.000000) scale(0.100000,-0.100000)"
               stroke="none">
                <path d="M165 466 c-30 -31 -68 -85 -84 -119 -17 -34 -31 -55 -31 -47 0 8 -11
			38 -24 65 l-24 50 -1 -207 -1 -208 1850 0 1850 0 0 114 c0 114 0 115 -32 157
			-40 51 -57 60 -51 25 6 -31 -4 -76 -17 -76 -15 0 -40 56 -40 92 0 18 7 46 15
			62 9 16 14 31 12 33 -9 9 -61 -44 -75 -76 l-15 -36 -11 45 c-16 63 -51 116
			-99 151 -56 41 -77 38 -39 -5 38 -44 63 -120 63 -192 0 -31 -2 -58 -5 -61 -12
			-12 -38 62 -33 94 4 20 2 31 -4 28 -13 -9 -49 -81 -50 -102 0 -16 -1 -16 -9 2
			-5 11 -11 36 -15 56 -5 36 -63 134 -72 125 -3 -3 0 -19 6 -37 13 -37 13 -135
			1 -164 -8 -18 -9 -18 -9 -2 -1 22 -29 77 -39 77 -4 0 -6 -18 -4 -40 2 -22 0
			-40 -5 -40 -16 0 -33 49 -34 98 l0 47 -19 -40 c-10 -22 -19 -50 -19 -62 -1
			-32 -21 -29 -21 3 0 36 -16 21 -25 -23 l-7 -38 -13 39 c-19 54 -35 68 -36 31
			0 -17 -4 -39 -9 -50 -7 -17 -9 -16 -9 9 -1 37 -35 107 -63 132 -21 19 -21 19
			-14 -1 17 -46 17 -73 0 -111 l-18 -39 -5 50 -6 50 -16 -25 c-9 -14 -21 -34
			-27 -44 -9 -17 -10 -16 -17 12 -3 17 -2 40 5 51 16 32 -5 25 -34 -10 -14 -17
			-26 -25 -26 -17 1 19 36 94 49 102 6 4 11 11 11 16 0 19 -62 -14 -89 -47 l-28
			-34 -53 51 c-29 28 -54 49 -57 46 -2 -2 5 -22 16 -45 13 -25 21 -59 21 -88
			l-1 -48 -13 31 c-15 34 -73 104 -87 104 -4 0 -5 -22 -2 -48 11 -95 -34 -118
			-57 -30 -9 30 -8 51 3 89 8 27 11 49 7 49 -15 0 -80 -113 -92 -157 -12 -51
			-28 -47 -28 8 0 49 -15 50 -30 3 -11 -33 -14 -35 -23 -18 -13 25 -89 104 -99
			104 -5 0 -2 -13 7 -30 18 -35 19 -97 1 -129 -13 -24 -13 -24 -20 13 -8 42 -59
			104 -112 137 -39 24 -56 19 -32 -8 40 -46 58 -114 42 -157 -5 -12 -15 -3 -38
			36 -34 57 -63 78 -46 34 10 -26 -4 -86 -20 -86 -13 0 -29 91 -23 128 3 17 2
			32 -1 32 -14 0 -46 -86 -46 -125 l0 -40 -21 45 c-23 51 -66 110 -79 110 -6 0
			-1 -15 10 -32 20 -33 25 -87 11 -123 -7 -18 -9 -18 -26 8 -13 20 -16 38 -11
			67 8 48 -7 53 -33 10 -18 -30 -31 -30 -31 0 0 23 -59 140 -71 140 -11 0 -12 3
			6 -45 15 -42 20 -145 8 -145 -5 0 -18 23 -30 50 -23 52 -48 69 -37 25 7 -29
			-2 -75 -16 -75 -16 0 -40 57 -40 97 0 21 7 49 16 61 26 38 7 37 -31 -1 -19
			-19 -38 -49 -41 -67 l-7 -31 -17 50 c-21 64 -61 122 -100 144 -34 20 -40 9
			-10 -18 33 -30 51 -129 32 -178 -6 -14 -13 -8 -32 32 -14 28 -28 51 -32 51 -5
			0 -8 -20 -8 -45 0 -25 -4 -45 -9 -45 -13 0 -23 67 -15 93 6 19 5 20 -9 9 -9
			-8 -21 -30 -28 -49 l-11 -36 -19 52 c-18 52 -83 151 -99 151 -5 0 1 -21 13
			-47 15 -34 21 -67 21 -115 0 -98 -20 -110 -32 -21 l-8 48 -17 -43 c-9 -23 -17
			-49 -17 -58 0 -8 -4 -12 -10 -9 -5 3 -10 17 -10 31 0 40 -18 27 -33 -23 l-14
			-47 -11 34 c-7 18 -12 41 -12 51 0 11 -4 19 -9 19 -10 0 -21 -34 -21 -67 0
			-32 -11 -28 -42 14 l-28 36 0 -49 -1 -49 -16 30 c-10 18 -17 54 -17 88 -1 48
			-3 55 -14 40 -6 -9 -17 -43 -24 -74 l-12 -58 -19 42 -20 42 -8 -48 c-4 -27
			-10 -51 -13 -54 -11 -12 -17 67 -7 103 6 22 11 43 11 47 0 16 -40 -14 -53 -40
			l-14 -26 -6 30 c-6 32 -91 153 -107 153 -6 0 1 -23 15 -51 27 -53 42 -135 31
			-166 -6 -14 -11 -10 -25 22 -20 44 -67 105 -82 105 -5 0 -7 -23 -3 -52 4 -39
			2 -58 -9 -73 -14 -18 -15 -18 -36 15 -25 41 -28 122 -6 160 19 32 19 46 1 30
			-33 -27 -77 -111 -89 -171 l-14 -64 -12 43 c-6 23 -9 47 -6 52 3 6 2 10 -4 10
			-5 0 -15 -17 -22 -37 -11 -35 -13 -36 -20 -15 -14 38 -69 112 -83 112 -11 0
			-9 -9 5 -37 20 -39 25 -89 10 -111 -6 -10 -14 -2 -30 30 -27 57 -28 138 -1
			197 11 24 18 46 15 49 -3 3 -30 -20 -60 -52z"/>
            </g>
        </svg>

        <div class="icon-holder">
			<?php
			echo $data['link']['url'] ? '<a href="' . $data['link']['url'] . '"' . $target . $nofollow . '>' : null;
			if ( 'image' == $data['icon_type'] ) {
				echo wp_get_attachment_image( $data['image_icon']['id'], 'full' );
			} else {
				echo "<span>";
				\Elementor\Icons_Manager::render_icon( $data['info_icon'], [ 'aria-hidden' => 'true' ] );
				echo "</span>";
			}
			echo $data['link']['url'] ? '</a>' : null;
			?>
        </div>


		<?php if ( $data['title'] ) : ?>
            <h3 class="info-title">
				<?php
				echo $data['link']['url'] ? '<a href="' . $data['link']['url'] . '"' . $target . $nofollow . '>' : null;
				echo wp_kses_post( $data['title'] );
				echo $data['link']['url'] ? '</a>' : null;
				?>
            </h3>
		<?php endif; ?>

        <div class="content-holder">
            <p><?php echo wp_kses_post( $data['sub_title'] ); ?></p>
        </div>

		<?php if ( $data['show_readmore_btn'] ) : ?>
            <div class="read-more-btn">
                <a class="white-button button-el" href="<?php echo esc_url( $data['link']['url'] ) ?>" <?php echo esc_attr( $target . ' ' . $nofollow ) ?>>
					<?php echo esc_html( $data['read_more_btn_text'] ); ?>
                </a>
            </div>
		<?php endif; ?>

    </div>
</div>