<?php
/**
 * WLS Options Class
 *
 * @package RT_WSL
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! class_exists( 'rtWLSOptions' ) ) :
	/**
	 * WLS Options Class
	 */
	class rtWLSOptions {

		/**
		 * Generate Getting field option
		 *
		 * @return array
		 */
		public function rtWLSGeneralSettings() {
			global $rtWLS;
			$settings = get_option( $rtWLS->options['settings'] );

			return [
				'image_resize' => [
					'type'  => 'checkbox',
					'name'  => 'image_resize',
					'id'    => 'wls_image_resize',
					'label' => esc_html__( 'Enable Image Re-Size', 'wp-logo-showcase' ),
					'value' => isset( $settings['image_resize'] ) ? trim( $settings['image_resize'] ) : null,
				],

				'image_width'  => [
					'type'        => 'number',
					'name'        => 'image_width',
					'id'          => 'wls_image_width',
					'label'       => esc_html__( 'Image Width', 'wp-logo-showcase' ),
					'holderClass' => 'hidden',
					'default'     => 250,
					'holderID'    => 'wls_image_width_holder',
					'value'       => isset( $settings['image_width'] ) ? absint( $settings['image_width'] ) : null,
				],

				'image_height' => [
					'type'        => 'number',
					'name'        => 'image_height',
					'id'          => 'wls_image_height',
					'label'       => esc_html__( 'Image Height', 'wp-logo-showcase' ),
					'holderClass' => 'hidden',
					'default'     => 190,
					'holderID'    => 'wls_image_height_holder',
					'value'       => isset( $settings['image_height'] ) ? absint( $settings['image_height'] ) : null,
				],

				'image_crop'   => [
					'type'        => 'select',
					'name'        => 'image_crop',
					'id'          => 'image_crop',
					'label'       => esc_html__( 'Image Crop', 'wp-logo-showcase' ),
					'class'       => 'rt-select2',
					'holderID'    => 'wls_image_crop_holder',
					'holderClass' => 'hidden',
					'options'     => [
						false => esc_html__( 'Soft Crop', 'wp-logo-showcase' ),
						true  => esc_html__( 'Hard Crop', 'wp-logo-showcase' ),
					],
					'value'       => isset( $settings['image_crop'] ) ? sanitize_text_field( $settings['image_crop'] ) : null,
				],
			];
		}

		/**
		 * Generate Custom css Field for setting page
		 *
		 * @return array
		 */
		public function rtWLSCustomCss() {
			global $rtWLS;

			$settings = get_option( $rtWLS->options['settings'] );

			return [
				'custom_css' => [
					'type'        => 'custom_css',
					'name'        => 'custom_css',
					'id'          => 'custom-css',
					'holderClass' => 'full',
					'value'       => isset( $settings['custom_css'] ) ? trim( $settings['custom_css'] ) : null,
				],
			];
		}

		/**
		 * Layout array
		 *
		 * @return array
		 */
		public function scLayout() {
			return [
				'grid-layout'     => esc_html__( 'Grid Layout', 'wp-logo-showcase' ),
				'carousel-layout' => esc_html__( 'Carousel Layout', 'wp-logo-showcase' ),
				'isotope-layout'  => esc_html__( 'Isotope Layout', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Layout item list
		 *
		 * @return array
		 */
		public function scLayoutItems() {
			return [
				'title'       => esc_html__( 'Title', 'wp-logo-showcase' ),
				'logo'        => esc_html__( 'Logo', 'wp-logo-showcase' ),
				'description' => esc_html__( 'Description', 'wp-logo-showcase' ),
			];
		}


		/**
		 * Style field
		 *
		 * @return array
		 */
		public function scStyleItems() {
			$items = $this->scLayoutItems();
			unset( $items['logo'] );

			return $items;
		}

		/**
		 * Font Weight Options
		 *
		 * @return array
		 */
		public function scWlsFontWeight() {
			return [
				'100' => esc_html__( '100', 'wp-logo-showcase' ),
				'200' => esc_html__( '200', 'wp-logo-showcase' ),
				'300' => esc_html__( '300', 'wp-logo-showcase' ),
				'400' => esc_html__( '400', 'wp-logo-showcase' ),
				'500' => esc_html__( '500', 'wp-logo-showcase' ),
				'600' => esc_html__( '600', 'wp-logo-showcase' ),
				'700' => esc_html__( '700', 'wp-logo-showcase' ),
				'800' => esc_html__( '700', 'wp-logo-showcase' ),
				'900' => esc_html__( '700', 'wp-logo-showcase' ),
				'400' => esc_html__( 'Normal', 'wp-logo-showcase' ),
				'500' => esc_html__( 'Medium', 'wp-logo-showcase' ),
				'600' => esc_html__( 'Semi Bold', 'wp-logo-showcase' ),
				'700' => esc_html__( 'Bold', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Align options
		 *
		 * @return array
		 */
		public function scWlsAlign() {
			return [
				'left'   => esc_html__( 'Left', 'wp-logo-showcase' ),
				'center' => esc_html__( 'Center', 'wp-logo-showcase' ),
				'right'  => esc_html__( 'Right', 'wp-logo-showcase' ),
			];
		}

		/**
		 * FontSize Options
		 *
		 * @return array
		 */
		public function scWlsFontSize() {

			$size = [];

			for ( $i = 14; $i <= 60; $i ++ ) {
				$size[ $i ] = "{$i} px";
			}

			return $size;
		}

		/**
		 * Order By Options
		 *
		 * @return array
		 */
		public function scOrderBy() {
			return [
				'menu_order' => esc_html__( 'Menu Order', 'wp-logo-showcase' ),
				'title'      => esc_html__( 'Name', 'wp-logo-showcase' ),
				'date'       => esc_html__( 'Date', 'wp-logo-showcase' ),
				'rand'       => esc_html__( 'Random order', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Order Options
		 *
		 * @return array
		 */
		public function scOrder() {
			return [
				'ASC'  => esc_html__( 'Ascending', 'wp-logo-showcase' ),
				'DESC' => esc_html__( 'Descending', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Style field options
		 *
		 * @return array
		 */
		public function scStyleFields() {
			return [
				'primary_color'          => [
					'type'  => 'colorpicker',
					'name'  => 'wls_primary_color',
					'label' => esc_html__( 'Primary color', 'wp-logo-showcase' ),
				],

				'button_bg_color'        => [
					'type'  => 'colorpicker',
					'name'  => 'wls_button_bg_color',
					'label' => esc_html__( 'Button background color', 'wp-logo-showcase' ),
				],

				'button_bg_hover_color'  => [
					'type'  => 'colorpicker',
					'name'  => 'wls_button_bg_hover_color',
					'label' => esc_html__( 'Button background color on hover', 'wp-logo-showcase' ),
				],

				'button_bg_active_color' => [
					'type'  => 'colorpicker',
					'name'  => 'wls_button_bg_active_color',
					'label' => esc_html__( 'Button background color on active', 'wp-logo-showcase' ),
				],

				'button_text_color'      => [
					'type'  => 'colorpicker',
					'name'  => 'wls_button_text_color',
					'label' => esc_html__( 'Button text color', 'wp-logo-showcase' ),
				],

				'gutter'                 => [
					'type'        => 'number',
					'name'        => 'wls_gutter',
					'label'       => esc_html__( 'Gutter / Padding', 'wp-logo-showcase' ),
					'description' => sprintf(
						'%s<br> %s',
						esc_html__( 'Unit will be pixel, No need to give any unit. Only integer value will be valid.', 'wp-logo-showcase' ),
						esc_html__( 'Leave it blank for default', 'wp-logo-showcase' )
					),
				],
			];
		}


		/**
		 * Column Options
		 *
		 * @return array
		 */
		public function scColumns() {
			return [
				1 => esc_html__( '1 Column', 'wp-logo-showcase' ),
				2 => esc_html__( '2 Column', 'wp-logo-showcase' ),
				3 => esc_html__( '3 Column', 'wp-logo-showcase' ),
				4 => esc_html__( '4 Column', 'wp-logo-showcase' ),
				5 => esc_html__( '5 Column', 'wp-logo-showcase' ),
				6 => esc_html__( '6 Column', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Link type options
		 *
		 * @return array
		 */
		public function scLinkTypes() {
			return [
				'new_window' => esc_html__( 'Open in new window', 'wp-logo-showcase' ),
				'self'       => esc_html__( 'Open in same window', 'wp-logo-showcase' ),
				'no_link'    => esc_html__( 'No link', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Filter Options
		 *
		 * @return array
		 */
		public function scFilterMetaFields() {
			global $rtWLS;

			return [
				'wls_post__in'     => [
					'name'        => 'wls_post__in',
					'label'       => esc_html__( 'Include only', 'wp-logo-showcase' ),
					'type'        => 'text',
					'class'       => 'full',
					'description' => esc_html__( 'List of post IDs to show (comma-separated values, for example: 1,2,3)', 'wp-logo-showcase' ),
				],

				'wls_post__not_in' => [
					'name'        => 'wls_post__not_in',
					'label'       => esc_html__( 'Exclude', 'wp-logo-showcase' ),
					'type'        => 'text',
					'class'       => 'full',
					'description' => esc_html__( 'List of post IDs to show (comma-separated values, for example: 1,2,3)', 'wp-logo-showcase' ),
				],

				'wls_limit'        => [
					'name'        => 'wls_limit',
					'label'       => esc_html__( 'Limit', 'wp-logo-showcase' ),
					'type'        => 'number',
					'class'       => 'full',
					'description' => esc_html__( 'The number of posts to show. Set empty to show all found posts.', 'wp-logo-showcase' ),
				],

				'wls_categories'   => [
					'name'        => 'wls_categories',
					'label'       => esc_html__( 'Categories', 'wp-logo-showcase' ),
					'type'        => 'select',
					'class'       => 'rt-select2',
					'id'          => 'wls_categories',
					'multiple'    => true,
					'description' => esc_html__( 'Select the category you want to filter, Leave it blank for All category', 'wp-logo-showcase' ),
					'options'     => $rtWLS->getAllWlsCategoryList(),
				],

				'wls_order_by'     => [
					'name'    => 'wls_order_by',
					'label'   => esc_html__( 'Order By', 'wp-logo-showcase' ),
					'type'    => 'select',
					'class'   => 'rt-select2',
					'default' => 'date',
					'options' => $this->scOrderBy(),
				],

				'wls_order'        => [
					'name'      => 'wls_order',
					'label'     => esc_html__( 'Order', 'wp-logo-showcase' ),
					'type'      => 'radio',
					'class'     => 'rt-select2',
					'options'   => $this->scOrder(),
					'default'   => 'DESC',
					'alignment' => 'vertical',
				],
			];
		}

		/**
		 * ShortCode Layout Options
		 *
		 * @return array
		 */
		public function scLayoutMetaFields() {
			global $rtWLS;

			return [
				'wls_layout'                  => [
					'name'    => 'wls_layout',
					'type'    => 'select',
					'id'      => 'wls_layout',
					'label'   => esc_html__( 'Layout', 'wp-logo-showcase' ),
					'class'   => 'rt-select2',
					'options' => $this->scLayout(),
				],

				'wls_desktop_column'          => [
					'name'        => 'wls_desktop_column',
					'type'        => 'select',
					'label'       => esc_html__( 'Desktop column', 'wp-logo-showcase' ),
					'id'          => 'wls_desktop_column',
					'holderClass' => 'wls_column_options_holder',
					'class'       => 'rt-select2',
					'default'     => 4,
					'options'     => $this->scColumns(),
				],

				'wls_tab_column'              => [
					'name'        => 'wls_tab_column',
					'type'        => 'select',
					'label'       => esc_html__( 'Tab column', 'wp-logo-showcase' ),
					'id'          => 'wls_tab_column',
					'holderClass' => 'wls_column_options_holder',
					'class'       => 'rt-select2',
					'default'     => 2,
					'options'     => $this->scColumns(),
				],

				'wls_mobile_column'           => [
					'name'        => 'wls_mobile_column',
					'type'        => 'select',
					'label'       => esc_html__( 'Mobile column', 'wp-logo-showcase' ),
					'id'          => 'wls_mobile_column',
					'holderClass' => 'wls_column_options_holder',
					'class'       => 'rt-select2',
					'default'     => 1,
					'options'     => $this->scColumns(),
				],

				'wls_desktop_slider'          => [
					'name'        => 'wls_desktop_slider',
					'type'        => 'number',
					'label'       => esc_html__( 'Desktop slider number', 'wp-logo-showcase' ),
					'id'          => 'wls_desktop_slider',
					'holderClass' => 'hidden wls_carousel_options_holder',
					'description' => esc_html__( 'If you want more that 6 item then set it.', 'wp-logo-showcase' ),
				],

				'wls_carousel_slidesToScroll' => [
					'name'        => 'wls_carousel_slidesToScroll',
					'label'       => esc_html__( 'Slides To Scroll', 'wp-logo-showcase' ),
					'holderClass' => 'hidden wls_carousel_options_holder',
					'type'        => 'number',
					'default'     => 3,
					'description' => esc_html__( 'Number of logo to to scroll, Recommended > same as slides to show', 'wp-logo-showcase' ),
				],

				'wls_carousel_speed'          => [
					'name'        => 'wls_carousel_speed',
					'label'       => esc_html__( 'Speed', 'wp-logo-showcase' ),
					'holderClass' => 'hidden wls_carousel_options_holder',
					'type'        => 'number',
					'default'     => 2000,
					'description' => esc_html__( 'Auto play Speed in milliseconds', 'wp-logo-showcase' ),
				],

				'wls_carousel_options'        => [
					'name'        => 'wls_carousel_options',
					'label'       => esc_html__( 'Carousel Options', 'wp-logo-showcase' ),
					'holderClass' => 'hidden wls_carousel_options_holder',
					'type'        => 'checkbox',
					'multiple'    => true,
					'alignment'   => 'vertical',
					'options'     => $rtWLS->carouselProperty(),
					'default'     => [ 'autoplay', 'arrows', 'dots', 'responsive', 'infinite' ],
				],

				'wls_tooltip'                 => [
					'name'   => 'wls_tooltip',
					'type'   => 'checkbox',
					'label'  => esc_html__( 'ToolTip', 'wp-logo-showcase' ),
					'option' => 'Enable',
					'id'     => 'wls_tooltip',
				],

				'wls_box_highlight'           => [
					'name'   => 'wls_box_highlight',
					'type'   => 'checkbox',
					'label'  => esc_html__( 'Box Highlight', 'wp-logo-showcase' ),
					'option' => 'Enable',
					'id'     => 'wls_box_highlight',
				],

				'wls_grayscale'               => [
					'name'   => 'wls_grayscale',
					'type'   => 'checkbox',
					'label'  => esc_html__( 'Grayscale', 'wp-logo-showcase' ),
					'option' => 'Enable',
					'id'     => 'wls_grayscale',
				],

				'wls_link_type'               => [
					'name'    => 'wls_link_type',
					'type'    => 'select',
					'label'   => esc_html__( 'Link Type', 'wp-logo-showcase' ),
					'id'      => 'wls_link_type',
					'class'   => 'rt-select2',
					'options' => $this->scLinkTypes(),
				],

				'wls_nofollow'                => [
					'name'   => 'wls_nofollow',
					'type'   => 'checkbox',
					'label'  => esc_html__( 'Nofollow', 'wp-logo-showcase' ),
					'option' => esc_html__( 'Enable', 'wp-logo-showcase' ),
				],

				'wls_image_size'              => [
					'name'    => 'wls_image_size',
					'type'    => 'select',
					'label'   => esc_html__( 'Image Size', 'wp-logo-showcase' ),
					'id'      => 'wls_image_size',
					'class'   => 'rt-select2',
					'options' => $rtWLS->get_image_sizes(),
				],

				'wls_custom_image_size'       => [
					'name'        => 'wls_custom_image_size',
					'type'        => 'image_size',
					'label'       => esc_html__( 'Custom Image Size', 'wp-logo-showcase' ),
					'holderClass' => 'hidden wls_image_size_holder',
				],
			];
		}

		/**
		 * Carousel Property
		 *
		 * @return array
		 */
		public function carouselProperty() {
			return [
				'autoplay'       => esc_html__( 'Auto Play', 'wp-logo-showcase' ),
				'arrows'         => esc_html__( 'Arrow nav button', 'wp-logo-showcase' ),
				'dots'           => esc_html__( 'Dots', 'wp-logo-showcase' ),
				'pauseOnHover'   => esc_html__( 'Pause on hover', 'wp-logo-showcase' ),
				'adaptiveHeight' => esc_html__( 'Adaptive height', 'wp-logo-showcase' ),
				'lazyLoad'       => esc_html__( 'Lazy Load (progressive)', 'wp-logo-showcase' ),
				'infinite'       => esc_html__( 'Infinite loop', 'wp-logo-showcase' ),
				'centerMode'     => esc_html__( 'Center mode', 'wp-logo-showcase' ),
				'rtl'            => esc_html__( 'Right to Left', 'wp-logo-showcase' ),
			];
		}

		/**
		 * Custom Meta field for logo post type
		 *
		 * @return array
		 */
		public function rtLogoMetaFields() {
			return [
				'site_url'         => [
					'type'        => 'url',
					'name'        => '_wls_site_url',
					'label'       => esc_html__( 'Client website URL', 'wp-logo-showcase' ),
					'placeholder' => esc_html__( 'Client URL e.g: http://example.com', 'wp-logo-showcase' ),
					'description' => esc_html__( 'Link to open when image is clicked (if links are active)', 'wp-logo-showcase' ),
				],

				'logo_description' => [
					'type'        => 'textarea',
					'name'        => '_wls_logo_description',
					'class'       => 'rt-textarea',
					'esc_html'    => true,
					'label'       => esc_html__( 'Logo Description', 'wp-logo-showcase' ),
					'placeholder' => esc_html__( 'Logo description', 'wp-logo-showcase' ),
				],

				'logo_img_url'     => [
					'type'        => 'url',
					'name'        => '_wls_logo_img_url',
					'label'       => esc_html__( 'Custom Image URL', 'wp-logo-showcase' ),
					'placeholder' => esc_html__( 'This will dominate over featured image', 'wp-logo-showcase' ),
					'description' => esc_html__( "If you don't want to use an image from your media gallery, you can set an URL for your image here.", 'wp-logo-showcase' ),
				],

				'logo_alt_text'    => [
					'type'        => 'text',
					'name'        => '_wls_logo_alt_text',
					'label'       => esc_html__( 'Alternate Text', 'wp-logo-showcase' ),
					'placeholder' => esc_html__( 'Alt for url and image', 'wp-logo-showcase' ),
				],
			];
		}
	}
endif;
