<?php
/**
 * Sorting Class
 *
 * Drag and drop sorting up on menu order
 *
 * @package RT_WSL
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! class_exists( 'rtWLSSorting' ) ) {
	/**
	 * Sorting Class
	 */
	class rtWLSSorting {
		public function __construct() {
			add_action( 'admin_init', [ $this, 'refresh' ] );
			add_action( 'wp_ajax_wls-logo-update-menu-order', [ $this, 'wls_logo_update_menu_order' ] );
			add_action( 'pre_get_posts', [ $this, 'wls_pre_get_posts' ] );
		}

		/**
		 * Query update for $rtWLS->post_type
		 *
		 * @param $wp_query
		 */
		public function wls_pre_get_posts( $wp_query ) {
			global $rtWLS;

			if ( is_admin() ) {
				if ( isset( $wp_query->query['post_type'] ) && ! isset( $_GET['orderby'] ) && $wp_query->query['post_type'] == $rtWLS->post_type && $wp_query->is_main_query() ) {
					$wp_query->set( 'orderby', 'menu_order' );
					$wp_query->set( 'order', 'ASC' );
				}
			}
		}

		/**
		 * Update menu order for $rtWLS->post_type
		 *
		 * @return bool
		 */
		public function wls_logo_update_menu_order() {
			global $wpdb;

			$data = ( ! empty( $_POST['post'] ) ? $_POST['post'] : [] );

			if ( ! is_array( $data ) ) {
				return false;
			}

			$id_arr = [];

			foreach ( $data as $position => $id ) {
					$id_arr[] = $id;
			}

			$menu_order_arr = [];

			foreach ( $id_arr as $key => $id ) {
				$results = $wpdb->get_results( "SELECT menu_order FROM $wpdb->posts WHERE ID = " . intval( $id ) );

				foreach ( $results as $result ) {
					$menu_order_arr[] = $result->menu_order;
				}
			}

			sort( $menu_order_arr );

			foreach ( $data as $position => $id ) {
				$wpdb->update( $wpdb->posts, [ 'menu_order' => $menu_order_arr[ $position ] ], [ 'ID' => intval( $id ) ] );
			}

			die();
		}

		/**
		 * Refresh database for  $rtWLS->post_type
		 */
		public function refresh() {
			global $wpdb, $rtWLS;

			$results = $wpdb->get_results(
				"SELECT ID FROM $wpdb->posts WHERE post_type = '" . $rtWLS->post_type . "' AND post_status IN ('publish', 'pending', 'draft', 'private', 'future') ORDER BY menu_order ASC "
			);

			foreach ( $results as $key => $result ) {
				$wpdb->update( $wpdb->posts, [ 'menu_order' => $key + 1 ], [ 'ID' => $result->ID ] );
			}
		}
	}
}
